/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.pattern;

import com.espertech.esper.epl.expression.core.ExprNodeUtility;
import com.espertech.esper.epl.spec.PatternObserverSpec;
import com.espertech.esper.pattern.EvalNode;
import com.espertech.esper.pattern.EvalNodeFactoryBase;
import com.espertech.esper.pattern.EvalObserverNode;
import com.espertech.esper.pattern.PatternAgentInstanceContext;
import com.espertech.esper.pattern.PatternExpressionPrecedenceEnum;
import com.espertech.esper.pattern.observer.ObserverFactory;
import java.io.StringWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EvalObserverFactoryNode
extends EvalNodeFactoryBase {
    private static final Logger log = LoggerFactory.getLogger(EvalObserverFactoryNode.class);
    private static final long serialVersionUID = 7130273585111632791L;
    private final PatternObserverSpec patternObserverSpec;
    private transient ObserverFactory observerFactory;

    protected EvalObserverFactoryNode(PatternObserverSpec patternObserverSpec) {
        this.patternObserverSpec = patternObserverSpec;
    }

    @Override
    public EvalNode makeEvalNode(PatternAgentInstanceContext agentInstanceContext, EvalNode parentNode) {
        return new EvalObserverNode(agentInstanceContext, this);
    }

    public PatternObserverSpec getPatternObserverSpec() {
        return this.patternObserverSpec;
    }

    public void setObserverFactory(ObserverFactory observerFactory) {
        this.observerFactory = observerFactory;
    }

    public ObserverFactory getObserverFactory() {
        return this.observerFactory;
    }

    public final String toString() {
        return "EvalObserverNode observerFactory=" + this.observerFactory + "  children=" + this.getChildNodes().size();
    }

    @Override
    public boolean isFilterChildNonQuitting() {
        return false;
    }

    @Override
    public boolean isStateful() {
        return false;
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer) {
        writer.write(this.patternObserverSpec.getObjectNamespace());
        writer.write(":");
        writer.write(this.patternObserverSpec.getObjectName());
        writer.write("(");
        ExprNodeUtility.toExpressionStringParameterList(this.patternObserverSpec.getObjectParameters(), writer);
        writer.write(")");
    }

    public String toPrecedenceFreeEPL() {
        StringWriter writer = new StringWriter();
        this.toPrecedenceFreeEPL(writer);
        return writer.toString();
    }

    @Override
    public PatternExpressionPrecedenceEnum getPrecedence() {
        return PatternExpressionPrecedenceEnum.ATOM;
    }

    public boolean isObserverStateNodeNonRestarting() {
        return this.observerFactory.isNonRestarting();
    }
}

