/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.pattern;

import com.espertech.esper.client.EPException;
import com.espertech.esper.client.EventBean;
import com.espertech.esper.collection.MultiKeyUntyped;
import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.time.ExprTimePeriod;
import com.espertech.esper.pattern.EvalFactoryNode;
import com.espertech.esper.pattern.MatchedEventConvertor;
import com.espertech.esper.pattern.MatchedEventMap;
import com.espertech.esper.pattern.PatternExpressionPrecedenceEnum;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PatternExpressionUtil {
    private static Logger log = LoggerFactory.getLogger(PatternExpressionUtil.class);

    public static Object getKeys(MatchedEventMap matchEvent, MatchedEventConvertor convertor, ExprEvaluator[] expressions, AgentInstanceContext agentInstanceContext) {
        EventBean[] eventsPerStream = convertor.convert(matchEvent);
        if (expressions.length == 1) {
            return expressions[0].evaluate(eventsPerStream, true, agentInstanceContext);
        }
        Object[] keys = new Object[expressions.length];
        for (int i = 0; i < keys.length; ++i) {
            keys[i] = expressions[i].evaluate(eventsPerStream, true, agentInstanceContext);
        }
        return new MultiKeyUntyped(keys);
    }

    public static List<Object> evaluate(String objectName, MatchedEventMap beginState, List<ExprNode> parameters, MatchedEventConvertor convertor, ExprEvaluatorContext exprEvaluatorContext) throws EPException {
        ArrayList<Object> results = new ArrayList<Object>();
        int count = 0;
        EventBean[] eventsPerStream = convertor.convert(beginState);
        for (ExprNode expr : parameters) {
            try {
                Object result = PatternExpressionUtil.evaluate(objectName, expr, eventsPerStream, exprEvaluatorContext);
                results.add(result);
                ++count;
            }
            catch (RuntimeException ex) {
                String message = objectName + " invalid parameter in expression " + count;
                if (ex.getMessage() != null) {
                    message = message + ": " + ex.getMessage();
                }
                log.error(message, (Throwable)ex);
                throw new EPException(message);
            }
        }
        return results;
    }

    public static Object evaluateTimePeriod(String objectName, MatchedEventMap beginState, ExprTimePeriod timePeriod, MatchedEventConvertor convertor, ExprEvaluatorContext exprEvaluatorContext) throws EPException {
        EventBean[] eventsPerStream = convertor.convert(beginState);
        try {
            return timePeriod.evaluateGetTimePeriod(eventsPerStream, true, exprEvaluatorContext);
        }
        catch (RuntimeException ex) {
            throw PatternExpressionUtil.handleRuntimeEx(ex, objectName);
        }
    }

    public static Object evaluate(String objectName, MatchedEventMap beginState, ExprNode parameter, MatchedEventConvertor convertor, ExprEvaluatorContext exprEvaluatorContext) throws EPException {
        EventBean[] eventsPerStream = convertor.convert(beginState);
        return PatternExpressionUtil.evaluate(objectName, parameter, eventsPerStream, exprEvaluatorContext);
    }

    private static Object evaluate(String objectName, ExprNode expression, EventBean[] eventsPerStream, ExprEvaluatorContext exprEvaluatorContext) throws EPException {
        try {
            return expression.getExprEvaluator().evaluate(eventsPerStream, true, exprEvaluatorContext);
        }
        catch (RuntimeException ex) {
            throw PatternExpressionUtil.handleRuntimeEx(ex, objectName);
        }
    }

    private static EPException handleRuntimeEx(RuntimeException ex, String objectName) {
        String message = objectName + " failed to evaluate expression";
        if (ex.getMessage() != null) {
            message = message + ": " + ex.getMessage();
        }
        log.error(message, (Throwable)ex);
        throw new EPException(message);
    }

    public static void toPrecedenceFreeEPL(StringWriter writer, String delimiterText, List<EvalFactoryNode> childNodes, PatternExpressionPrecedenceEnum precedence) {
        String delimiter = "";
        for (EvalFactoryNode child : childNodes) {
            writer.append(delimiter);
            child.toEPL(writer, precedence);
            delimiter = " " + delimiterText + " ";
        }
    }
}

