/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.pattern;

import com.espertech.esper.client.soda.AnnotationPart;
import com.espertech.esper.epl.spec.PatternStreamSpecRaw;
import com.espertech.esper.pattern.PatternLevelAnnotationFlags;
import java.util.ArrayDeque;
import java.util.Locale;

public class PatternLevelAnnotationUtil {
    private static final String DISCARDPARTIALSONMATCH = "DiscardPartialsOnMatch";
    private static final String SUPPRESSOVERLAPPINGMATCHES = "SuppressOverlappingMatches";

    public static AnnotationPart[] annotationsFromSpec(PatternStreamSpecRaw pattern) {
        ArrayDeque<AnnotationPart> parts = null;
        if (pattern.isDiscardPartialsOnMatch()) {
            parts = new ArrayDeque<AnnotationPart>();
            parts.add(new AnnotationPart(DISCARDPARTIALSONMATCH));
        }
        if (pattern.isSuppressSameEventMatches()) {
            if (parts == null) {
                parts = new ArrayDeque();
            }
            parts.add(new AnnotationPart(SUPPRESSOVERLAPPINGMATCHES));
        }
        if (parts == null) {
            return null;
        }
        return parts.toArray(new AnnotationPart[parts.size()]);
    }

    public static PatternLevelAnnotationFlags annotationsToSpec(AnnotationPart[] parts) {
        PatternLevelAnnotationFlags flags = new PatternLevelAnnotationFlags();
        if (parts == null) {
            return flags;
        }
        for (AnnotationPart part : parts) {
            PatternLevelAnnotationUtil.validateSetFlags(flags, part.getName());
        }
        return flags;
    }

    public static void validateSetFlags(PatternLevelAnnotationFlags flags, String annotation) {
        if (annotation.toLowerCase(Locale.ENGLISH).equals(DISCARDPARTIALSONMATCH.toLowerCase(Locale.ENGLISH))) {
            flags.setDiscardPartialsOnMatch(true);
        } else if (annotation.toLowerCase(Locale.ENGLISH).equals(SUPPRESSOVERLAPPINGMATCHES.toLowerCase(Locale.ENGLISH))) {
            flags.setSuppressSameEventMatches(true);
        } else {
            throw new IllegalArgumentException("Unrecognized pattern-level annotation '" + annotation + "'");
        }
    }
}

