/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.pattern.observer;

import com.espertech.esper.client.EPException;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprValidationContext;
import com.espertech.esper.epl.expression.time.ExprTimePeriod;
import com.espertech.esper.pattern.EvalStateNodeNumber;
import com.espertech.esper.pattern.MatchedEventConvertor;
import com.espertech.esper.pattern.MatchedEventMap;
import com.espertech.esper.pattern.PatternAgentInstanceContext;
import com.espertech.esper.pattern.observer.EventObserver;
import com.espertech.esper.pattern.observer.ObserverEventEvaluator;
import com.espertech.esper.pattern.observer.ObserverFactory;
import com.espertech.esper.pattern.observer.ObserverParameterException;
import com.espertech.esper.pattern.observer.ObserverParameterUtil;
import com.espertech.esper.pattern.observer.TimerIntervalObserver;
import com.espertech.esper.util.JavaClassHelper;
import com.espertech.esper.util.MetaDefItem;
import java.io.Serializable;
import java.util.List;

public class TimerIntervalObserverFactory
implements ObserverFactory,
MetaDefItem,
Serializable {
    private static final long serialVersionUID = -2808651894497586884L;
    private static final String NAME = "Timer-interval observer";
    protected ExprNode parameter;
    protected transient MatchedEventConvertor convertor;

    @Override
    public void setObserverParameters(List<ExprNode> parameters, MatchedEventConvertor convertor, ExprValidationContext validationContext) throws ObserverParameterException {
        Class returnType;
        ObserverParameterUtil.validateNoNamedParameters(NAME, parameters);
        String errorMessage = "Timer-interval observer requires a single numeric or time period parameter";
        if (parameters.size() != 1) {
            throw new ObserverParameterException(errorMessage);
        }
        if (!(parameters.get(0) instanceof ExprTimePeriod) && !JavaClassHelper.isNumeric(returnType = parameters.get(0).getExprEvaluator().getType())) {
            throw new ObserverParameterException(errorMessage);
        }
        this.parameter = parameters.get(0);
        this.convertor = convertor;
    }

    public long computeDelta(MatchedEventMap beginState, PatternAgentInstanceContext context) {
        if (this.parameter instanceof ExprTimePeriod) {
            ExprTimePeriod timePeriod = (ExprTimePeriod)this.parameter;
            return timePeriod.nonconstEvaluator().deltaUseEngineTime(this.convertor.convert(beginState), context.getAgentInstanceContext());
        }
        Object result = this.parameter.getExprEvaluator().evaluate(this.convertor.convert(beginState), true, context.getAgentInstanceContext());
        if (result == null) {
            throw new EPException("Null value returned for guard expression");
        }
        return context.getStatementContext().getTimeAbacus().deltaForSecondsNumber((Number)result);
    }

    @Override
    public EventObserver makeObserver(PatternAgentInstanceContext context, MatchedEventMap beginState, ObserverEventEvaluator observerEventEvaluator, EvalStateNodeNumber stateNodeId, Object observerState, boolean isFilterChildNonQuitting) {
        return new TimerIntervalObserver(this.computeDelta(beginState, context), beginState, observerEventEvaluator);
    }

    @Override
    public boolean isNonRestarting() {
        return false;
    }
}

