/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.rowregex;

import com.espertech.esper.client.ConfigurationEngineDefaults;
import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.Pair;
import com.espertech.esper.collection.SingleEventIterator;
import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.epl.agg.service.AggregationServiceMatchRecognize;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprNodeUtility;
import com.espertech.esper.epl.expression.prev.ExprPreviousMatchRecognizeNode;
import com.espertech.esper.epl.spec.MatchRecognizeDefineItem;
import com.espertech.esper.epl.spec.MatchRecognizeMeasureItem;
import com.espertech.esper.epl.spec.MatchRecognizeSkipEnum;
import com.espertech.esper.epl.spec.MatchRecognizeSpec;
import com.espertech.esper.event.ObjectArrayBackedEventBean;
import com.espertech.esper.event.arr.ObjectArrayEventBean;
import com.espertech.esper.event.arr.ObjectArrayEventType;
import com.espertech.esper.rowregex.EventRowRegexHelper;
import com.espertech.esper.rowregex.EventRowRegexIteratorResult;
import com.espertech.esper.rowregex.EventRowRegexNFAViewFactory;
import com.espertech.esper.rowregex.EventRowRegexNFAViewScheduleCallback;
import com.espertech.esper.rowregex.EventRowRegexNFAViewScheduler;
import com.espertech.esper.rowregex.EventRowRegexNFAViewService;
import com.espertech.esper.rowregex.EventRowRegexNFAViewServiceVisitor;
import com.espertech.esper.rowregex.EventRowRegexNFAViewUtil;
import com.espertech.esper.rowregex.MatchRecognizeStatePoolStmtSvc;
import com.espertech.esper.rowregex.MultimatchState;
import com.espertech.esper.rowregex.RegexExprPreviousEvalStrategy;
import com.espertech.esper.rowregex.RegexHandlerFactory;
import com.espertech.esper.rowregex.RegexNFAState;
import com.espertech.esper.rowregex.RegexNFAStateEnd;
import com.espertech.esper.rowregex.RegexNFAStateEntry;
import com.espertech.esper.rowregex.RegexNFAStrandResult;
import com.espertech.esper.rowregex.RegexPartitionState;
import com.espertech.esper.rowregex.RegexPartitionStateRandomAccessGetter;
import com.espertech.esper.rowregex.RegexPartitionStateRepo;
import com.espertech.esper.rowregex.RegexPartitionStateRepoGroupMeta;
import com.espertech.esper.rowregex.RegexPartitionTerminationStateComparator;
import com.espertech.esper.rowregex.RowRegexExprNode;
import com.espertech.esper.util.ExecutionPathDebugLog;
import com.espertech.esper.util.StopCallback;
import com.espertech.esper.view.ViewSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventRowRegexNFAView
extends ViewSupport
implements StopCallback,
EventRowRegexNFAViewService,
EventRowRegexNFAViewScheduleCallback {
    private static final Logger log = LoggerFactory.getLogger(EventRowRegexNFAView.class);
    private static final boolean IS_DEBUG = false;
    private static final Iterator<EventBean> NULL_ITERATOR = new SingleEventIterator(null);
    private final EventRowRegexNFAViewFactory factory;
    private final MatchRecognizeSpec matchRecognizeSpec;
    private final boolean isUnbound;
    private final boolean isIterateOnly;
    private final boolean isCollectMultimatches;
    private final boolean isTrackMaxStates;
    private final EventType rowEventType;
    private final AgentInstanceContext agentInstanceContext;
    private final AggregationServiceMatchRecognize aggregationService;
    protected final EventRowRegexNFAViewScheduler scheduler;
    private final boolean isOrTerminated;
    private final ExprEvaluator[] columnEvaluators;
    private final String[] columnNames;
    private final RegexNFAState[] startStates;
    protected final RegexNFAState[] allStates;
    private final String[] multimatchVariablesArray;
    private final int[] multimatchStreamNumToVariable;
    private final int[] multimatchVariableToStreamNum;
    private final LinkedHashMap<String, Pair<Integer, Boolean>> variableStreams;
    private final Map<Integer, String> streamsVariables;
    protected final int numEventsEventsPerStreamDefine;
    private final boolean isDefineAsksMultimatches;
    private final ObjectArrayBackedEventBean defineMultimatchEventBean;
    private final RegexPartitionStateRandomAccessGetter prevGetter;
    private final ObjectArrayBackedEventBean compositeEventBean;
    protected RegexPartitionStateRepo regexPartitionStateRepo;
    private LinkedHashSet<EventBean> windowMatchedEventset;

    public EventRowRegexNFAView(EventRowRegexNFAViewFactory factory, ObjectArrayEventType compositeEventType, EventType rowEventType, MatchRecognizeSpec matchRecognizeSpec, LinkedHashMap<String, Pair<Integer, Boolean>> variableStreams, Map<Integer, String> streamsVariables, Set<String> variablesSingle, AgentInstanceContext agentInstanceContext, TreeMap<Integer, List<ExprPreviousMatchRecognizeNode>> callbacksPerIndex, AggregationServiceMatchRecognize aggregationService, boolean isDefineAsksMultimatches, ObjectArrayBackedEventBean defineMultimatchEventBean, boolean[] isExprRequiresMultimatchState, boolean isUnbound, boolean isIterateOnly, boolean isCollectMultimatches, RowRegexExprNode expandedPatternNode, ConfigurationEngineDefaults.MatchRecognize matchRecognizeConfig, EventRowRegexNFAViewScheduler scheduler) {
        this.factory = factory;
        this.matchRecognizeSpec = matchRecognizeSpec;
        this.isTrackMaxStates = matchRecognizeConfig != null && matchRecognizeConfig.getMaxStates() != null;
        this.compositeEventBean = new ObjectArrayEventBean(new Object[variableStreams.size()], compositeEventType);
        this.rowEventType = rowEventType;
        this.variableStreams = variableStreams;
        this.scheduler = scheduler;
        if (variablesSingle.size() == variableStreams.size()) {
            this.multimatchVariablesArray = new String[0];
            this.multimatchStreamNumToVariable = new int[0];
            this.multimatchVariableToStreamNum = new int[0];
        } else {
            this.multimatchVariablesArray = new String[variableStreams.size() - variablesSingle.size()];
            this.multimatchVariableToStreamNum = new int[this.multimatchVariablesArray.length];
            this.multimatchStreamNumToVariable = new int[variableStreams.size()];
            Arrays.fill(this.multimatchStreamNumToVariable, -1);
            int count = 0;
            for (Map.Entry<String, Pair<Integer, Boolean>> entry : variableStreams.entrySet()) {
                if (!entry.getValue().getSecond().booleanValue()) continue;
                int n = count++;
                this.multimatchVariablesArray[n] = entry.getKey();
                this.multimatchVariableToStreamNum[n] = entry.getValue().getFirst();
                this.multimatchStreamNumToVariable[entry.getValue().getFirst().intValue()] = n;
            }
        }
        this.streamsVariables = streamsVariables;
        this.aggregationService = aggregationService;
        this.isDefineAsksMultimatches = isDefineAsksMultimatches;
        this.defineMultimatchEventBean = defineMultimatchEventBean;
        this.numEventsEventsPerStreamDefine = isDefineAsksMultimatches ? variableStreams.size() + 1 : variableStreams.size();
        this.isUnbound = isUnbound;
        this.isIterateOnly = isIterateOnly;
        this.agentInstanceContext = agentInstanceContext;
        this.isCollectMultimatches = isCollectMultimatches;
        if (matchRecognizeSpec.getInterval() != null) {
            agentInstanceContext.addTerminationCallback(this);
            this.isOrTerminated = matchRecognizeSpec.getInterval().isOrTerminated();
        } else {
            this.isOrTerminated = false;
        }
        this.windowMatchedEventset = new LinkedHashSet();
        if (!callbacksPerIndex.isEmpty()) {
            int[] randomAccessIndexesRequested = new int[callbacksPerIndex.size()];
            int count = 0;
            for (Map.Entry entry : callbacksPerIndex.entrySet()) {
                randomAccessIndexesRequested[count] = (Integer)entry.getKey();
                ++count;
            }
            this.prevGetter = new RegexPartitionStateRandomAccessGetter(randomAccessIndexesRequested, isUnbound);
        } else {
            this.prevGetter = null;
        }
        LinkedHashMap<String, ExprNode> variableDefinitions = new LinkedHashMap<String, ExprNode>();
        for (MatchRecognizeDefineItem defineItem : matchRecognizeSpec.getDefines()) {
            variableDefinitions.put(defineItem.getIdentifier(), defineItem.getExpression());
        }
        RegexNFAStrandResult strand = EventRowRegexHelper.recursiveBuildStartStates(expandedPatternNode, variableDefinitions, variableStreams, isExprRequiresMultimatchState);
        this.startStates = strand.getStartStates().toArray(new RegexNFAState[strand.getStartStates().size()]);
        this.allStates = strand.getAllStates().toArray(new RegexNFAState[strand.getAllStates().size()]);
        if (log.isDebugEnabled()) {
            log.info("NFA tree:\n" + EventRowRegexNFAViewUtil.print(this.startStates));
        }
        this.columnNames = new String[matchRecognizeSpec.getMeasures().size()];
        this.columnEvaluators = new ExprEvaluator[matchRecognizeSpec.getMeasures().size()];
        int count = 0;
        for (MatchRecognizeMeasureItem measureItem : matchRecognizeSpec.getMeasures()) {
            this.columnNames[count] = measureItem.getName();
            this.columnEvaluators[count] = measureItem.getExpr().getExprEvaluator();
            ++count;
        }
        RegexHandlerFactory regexHandlerFactory = agentInstanceContext.getStatementContext().getRegexPartitionStateRepoFactory();
        RegexPartitionTerminationStateComparator terminationStateCompare = new RegexPartitionTerminationStateComparator(this.multimatchStreamNumToVariable, variableStreams);
        if (this.matchRecognizeSpec.getPartitionByExpressions().isEmpty()) {
            this.regexPartitionStateRepo = regexHandlerFactory.makeSingle(this.prevGetter, agentInstanceContext, this, matchRecognizeSpec.getInterval() != null, terminationStateCompare);
        } else {
            RegexPartitionStateRepoGroupMeta stateRepoGroupMeta = new RegexPartitionStateRepoGroupMeta(matchRecognizeSpec.getInterval() != null, ExprNodeUtility.toArray(matchRecognizeSpec.getPartitionByExpressions()), ExprNodeUtility.getEvaluators(matchRecognizeSpec.getPartitionByExpressions()), agentInstanceContext);
            this.regexPartitionStateRepo = regexHandlerFactory.makePartitioned(this.prevGetter, stateRepoGroupMeta, agentInstanceContext, this, matchRecognizeSpec.getInterval() != null, terminationStateCompare);
        }
    }

    @Override
    public void stop() {
        if (this.scheduler != null) {
            this.scheduler.removeSchedule();
        }
        if (this.isTrackMaxStates) {
            int size = this.regexPartitionStateRepo.getStateCount();
            MatchRecognizeStatePoolStmtSvc poolSvc = this.agentInstanceContext.getStatementContext().getMatchRecognizeStatePoolStmtSvc();
            poolSvc.getEngineSvc().decreaseCount(this.agentInstanceContext, size);
            poolSvc.getStmtHandler().decreaseCount(size);
        }
        this.regexPartitionStateRepo.destroy();
    }

    @Override
    public void init(EventBean[] newEvents) {
        this.updateInternal(newEvents, null, false);
    }

    @Override
    public void update(EventBean[] newData, EventBean[] oldData) {
        this.updateInternal(newData, oldData, true);
    }

    /*
     * WARNING - void declaration
     */
    private void updateInternal(EventBean[] newData, EventBean[] oldData, boolean postOutput) {
        if (this.isIterateOnly) {
            if (oldData != null) {
                this.regexPartitionStateRepo.removeOld(oldData, false, new boolean[oldData.length]);
            }
            if (newData != null) {
                void var6_10;
                EventBean[] eventBeanArray = newData;
                int n = eventBeanArray.length;
                boolean bl = false;
                while (var6_10 < n) {
                    EventBean newEvent = eventBeanArray[var6_10];
                    RegexPartitionState partitionState = this.regexPartitionStateRepo.getState(newEvent, true);
                    if (partitionState != null && partitionState.getRandomAccess() != null) {
                        partitionState.getRandomAccess().newEventPrepare(newEvent);
                    }
                    ++var6_10;
                }
            }
            return;
        }
        if (oldData != null) {
            boolean isOutOfSequenceRemove = false;
            EventBean first = null;
            if (!this.windowMatchedEventset.isEmpty()) {
                first = (EventBean)this.windowMatchedEventset.iterator().next();
            }
            boolean[] blArray = new boolean[oldData.length];
            int count = 0;
            for (EventBean oldEvent : oldData) {
                boolean removed = this.windowMatchedEventset.remove(oldEvent);
                if (!removed) continue;
                if (oldEvent != first && first != null) {
                    isOutOfSequenceRemove = true;
                }
                blArray[count++] = true;
                if (this.windowMatchedEventset.isEmpty()) continue;
                first = (EventBean)this.windowMatchedEventset.iterator().next();
            }
            if (isOutOfSequenceRemove) {
                if (this.isTrackMaxStates) {
                    int size = this.regexPartitionStateRepo.getStateCount();
                    MatchRecognizeStatePoolStmtSvc poolSvc = this.agentInstanceContext.getStatementContext().getMatchRecognizeStatePoolStmtSvc();
                    poolSvc.getEngineSvc().decreaseCount(this.agentInstanceContext, size);
                    poolSvc.getStmtHandler().decreaseCount(size);
                }
                this.regexPartitionStateRepo = this.regexPartitionStateRepo.copyForIterate(true);
                Iterator<EventBean> parentEvents = this.getParent().iterator();
                EventRowRegexIteratorResult iteratorResult = this.processIterator(true, parentEvents, this.regexPartitionStateRepo);
                this.regexPartitionStateRepo.setEventSequenceNum(iteratorResult.getEventSequenceNum());
            } else {
                int numRemoved = this.regexPartitionStateRepo.removeOld(oldData, this.windowMatchedEventset.isEmpty(), blArray);
                if (this.isTrackMaxStates) {
                    MatchRecognizeStatePoolStmtSvc poolSvc = this.agentInstanceContext.getStatementContext().getMatchRecognizeStatePoolStmtSvc();
                    poolSvc.getEngineSvc().decreaseCount(this.agentInstanceContext, numRemoved);
                    poolSvc.getStmtHandler().decreaseCount(numRemoved);
                }
            }
        }
        if (newData == null) {
            return;
        }
        List<RegexNFAStateEntry> endStates = new ArrayList<RegexNFAStateEntry>();
        List<RegexNFAStateEntry> terminationStatesAll = null;
        for (EventBean newEvent : newData) {
            ArrayList<RegexNFAStateEntry> nextStates = new ArrayList<RegexNFAStateEntry>(2);
            int eventSequenceNumber = this.regexPartitionStateRepo.incrementAndGetEventSequenceNum();
            RegexPartitionState partitionState = this.regexPartitionStateRepo.getState(newEvent, true);
            Iterator<RegexNFAStateEntry> currentStatesIterator = partitionState.getCurrentStatesIterator();
            if (partitionState.getRandomAccess() != null) {
                partitionState.getRandomAccess().newEventPrepare(newEvent);
            }
            if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
                log.info("Evaluating event " + newEvent.getUnderlying() + "\ncurrent : " + EventRowRegexNFAViewUtil.printStates(partitionState.getCurrentStatesForPrint(), this.streamsVariables, this.variableStreams, this.multimatchStreamNumToVariable));
            }
            List<RegexNFAStateEntry> terminationStates = this.step(false, currentStatesIterator, newEvent, nextStates, endStates, !this.isUnbound, eventSequenceNumber, partitionState.getOptionalKeys());
            if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
                log.info("Evaluated event " + newEvent.getUnderlying() + "\nnext : " + EventRowRegexNFAViewUtil.printStates(nextStates, this.streamsVariables, this.variableStreams, this.multimatchStreamNumToVariable) + "\nend : " + EventRowRegexNFAViewUtil.printStates(endStates, this.streamsVariables, this.variableStreams, this.multimatchStreamNumToVariable));
            }
            if (terminationStates != null) {
                if (terminationStatesAll == null) {
                    terminationStatesAll = terminationStates;
                } else {
                    terminationStatesAll.addAll(terminationStates);
                }
            }
            partitionState.setCurrentStates(nextStates);
        }
        if (endStates.isEmpty() && (!this.isOrTerminated || terminationStatesAll == null)) {
            return;
        }
        if (!this.matchRecognizeSpec.isAllMatches()) {
            endStates = this.rankEndStatesMultiPartition(endStates);
        }
        if (this.matchRecognizeSpec.getInterval() != null) {
            Iterator<RegexNFAStateEntry> iterator = endStates.iterator();
            while (iterator.hasNext()) {
                RegexNFAStateEntry endState = iterator.next();
                RegexPartitionState partitionState = this.regexPartitionStateRepo.getState(endState.getPartitionKey());
                if (partitionState == null) {
                    log.warn("Null partition state encountered, skipping row");
                    continue;
                }
                boolean scheduleDelivery = !this.isOrTerminated ? true : endState.getState().getNextStates().size() != 1 || !(endState.getState().getNextStates().get(0) instanceof RegexNFAStateEnd);
                if (!scheduleDelivery) continue;
                long matchBeginTime = endState.getMatchBeginEventTime();
                long current = this.agentInstanceContext.getStatementContext().getSchedulingService().getTime();
                long deltaFromStart = current - matchBeginTime;
                long deltaUntil = this.matchRecognizeSpec.getInterval().getScheduleForwardDelta(current, this.agentInstanceContext) - deltaFromStart;
                if (this.regexPartitionStateRepo.getScheduleState().containsKey(matchBeginTime)) {
                    this.scheduleCallback(deltaUntil, endState);
                    iterator.remove();
                    continue;
                }
                if (deltaFromStart >= deltaUntil) continue;
                this.scheduleCallback(deltaUntil, endState);
                iterator.remove();
            }
            if (this.isOrTerminated && terminationStatesAll != null) {
                for (RegexNFAStateEntry terminationState : terminationStatesAll) {
                    RegexPartitionState partitionState = this.regexPartitionStateRepo.getState(terminationState.getPartitionKey());
                    if (partitionState == null) {
                        log.warn("Null partition state encountered, skipping row");
                        continue;
                    }
                    this.removeScheduleAddEndState(terminationState, endStates);
                }
                if (!this.matchRecognizeSpec.isAllMatches()) {
                    endStates = this.rankEndStatesMultiPartition(endStates);
                }
            }
            if (endStates.isEmpty()) {
                return;
            }
        } else if (this.matchRecognizeSpec.getSkip().getSkip() == MatchRecognizeSkipEnum.PAST_LAST_ROW) {
            for (RegexNFAStateEntry endState : endStates) {
                RegexPartitionState partitionState = this.regexPartitionStateRepo.getState(endState.getPartitionKey());
                if (partitionState == null) {
                    log.warn("Null partition state encountered, skipping row");
                    continue;
                }
                Iterator<RegexNFAStateEntry> stateIter = partitionState.getCurrentStatesIterator();
                while (stateIter.hasNext()) {
                    RegexNFAStateEntry currentState = stateIter.next();
                    if (currentState.getMatchBeginEventSeqNo() > endState.getMatchEndEventSeqNo()) continue;
                    stateIter.remove();
                }
            }
        } else if (this.matchRecognizeSpec.getSkip().getSkip() == MatchRecognizeSkipEnum.TO_NEXT_ROW) {
            for (RegexNFAStateEntry endState : endStates) {
                RegexPartitionState partitionState = this.regexPartitionStateRepo.getState(endState.getPartitionKey());
                if (partitionState == null) {
                    log.warn("Null partition state encountered, skipping row");
                    continue;
                }
                Iterator<RegexNFAStateEntry> stateIter = partitionState.getCurrentStatesIterator();
                while (stateIter.hasNext()) {
                    RegexNFAStateEntry currentState = stateIter.next();
                    if (currentState.getMatchBeginEventSeqNo() > endState.getMatchBeginEventSeqNo()) continue;
                    stateIter.remove();
                }
            }
        }
        EventBean[] eventBeanArray = new EventBean[endStates.size()];
        int count = 0;
        for (RegexNFAStateEntry endState : endStates) {
            RegexPartitionState state;
            eventBeanArray[count] = this.generateOutputRow(endState);
            ++count;
            if (endState.getPartitionKey() == null || !(state = this.regexPartitionStateRepo.getState(endState.getPartitionKey())).isEmptyCurrentState() || state.getRandomAccess() != null) continue;
            this.regexPartitionStateRepo.removeState(endState.getPartitionKey());
        }
        if (postOutput) {
            this.updateChildren(eventBeanArray, null);
        }
    }

    private RegexNFAStateEntry rankEndStates(List<RegexNFAStateEntry> endStates) {
        Collections.sort(endStates, EventRowRegexHelper.END_STATE_COMPARATOR);
        RegexNFAStateEntry found = null;
        int min = Integer.MAX_VALUE;
        boolean multipleMinimums = false;
        for (RegexNFAStateEntry state : endStates) {
            if (state.getMatchBeginEventSeqNo() < min) {
                found = state;
                min = state.getMatchBeginEventSeqNo();
                continue;
            }
            if (state.getMatchBeginEventSeqNo() != min) continue;
            multipleMinimums = true;
        }
        if (!multipleMinimums) {
            Collections.singletonList(found);
        }
        int[] best = null;
        found = null;
        for (RegexNFAStateEntry state : endStates) {
            if (state.getMatchBeginEventSeqNo() != min) continue;
            if (best == null) {
                best = state.getGreedycountPerState();
                found = state;
                continue;
            }
            int[] current = state.getGreedycountPerState();
            if (!this.compare(current, best)) continue;
            best = current;
            found = state;
        }
        return found;
    }

    private boolean compare(int[] current, int[] best) {
        for (RegexNFAState state : this.allStates) {
            if (state.isGreedy() == null || !(state.isGreedy() != false ? current[state.getNodeNumFlat()] > best[state.getNodeNumFlat()] : current[state.getNodeNumFlat()] < best[state.getNodeNumFlat()])) continue;
            return true;
        }
        return false;
    }

    private EventRowRegexIteratorResult processIterator(boolean isOutOfSeqDelete, Iterator<EventBean> events, RegexPartitionStateRepo regexPartitionStateRepo) {
        ArrayList<RegexNFAStateEntry> endStates = new ArrayList<RegexNFAStateEntry>();
        int eventSequenceNumber = 0;
        while (events.hasNext()) {
            ArrayList<RegexNFAStateEntry> nextStates = new ArrayList<RegexNFAStateEntry>(2);
            EventBean theEvent = events.next();
            ++eventSequenceNumber;
            RegexPartitionState partitionState = regexPartitionStateRepo.getState(theEvent, false);
            Iterator<RegexNFAStateEntry> currentStates = partitionState.getCurrentStatesIterator();
            if (partitionState.getRandomAccess() != null) {
                partitionState.getRandomAccess().existingEventPrepare(theEvent);
            }
            if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
                log.info("Evaluating event " + theEvent.getUnderlying() + "\ncurrent : " + EventRowRegexNFAViewUtil.printStates(partitionState.getCurrentStatesForPrint(), this.streamsVariables, this.variableStreams, this.multimatchStreamNumToVariable));
            }
            this.step(!isOutOfSeqDelete, currentStates, theEvent, nextStates, endStates, false, eventSequenceNumber, partitionState.getOptionalKeys());
            if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
                log.info("Evaluating event " + theEvent.getUnderlying() + "\nnext : " + EventRowRegexNFAViewUtil.printStates(nextStates, this.streamsVariables, this.variableStreams, this.multimatchStreamNumToVariable) + "\nend : " + EventRowRegexNFAViewUtil.printStates(endStates, this.streamsVariables, this.variableStreams, this.multimatchStreamNumToVariable));
            }
            partitionState.setCurrentStates(nextStates);
        }
        return new EventRowRegexIteratorResult(endStates, eventSequenceNumber);
    }

    @Override
    public EventType getEventType() {
        return this.rowEventType;
    }

    @Override
    public Iterator<EventBean> iterator() {
        RegexPartitionStateRepo regexPartitionStateRepoNew;
        if (this.isUnbound) {
            return NULL_ITERATOR;
        }
        Iterator<EventBean> it = this.parent.iterator();
        EventRowRegexIteratorResult iteratorResult = this.processIterator(false, it, regexPartitionStateRepoNew = this.regexPartitionStateRepo.copyForIterate(false));
        List<RegexNFAStateEntry> endStates = iteratorResult.getEndStates();
        if (endStates.isEmpty()) {
            return NULL_ITERATOR;
        }
        endStates = this.rankEndStatesMultiPartition(endStates);
        ArrayList<EventBean> output = new ArrayList<EventBean>();
        for (RegexNFAStateEntry endState : endStates) {
            output.add(this.generateOutputRow(endState));
        }
        return output.iterator();
    }

    @Override
    public void accept(EventRowRegexNFAViewServiceVisitor visitor) {
        this.regexPartitionStateRepo.accept(visitor);
    }

    private List<RegexNFAStateEntry> rankEndStatesMultiPartition(List<RegexNFAStateEntry> endStates) {
        List<RegexNFAStateEntry> entries;
        if (endStates.isEmpty()) {
            return endStates;
        }
        if (endStates.size() == 1) {
            return endStates;
        }
        if (this.matchRecognizeSpec.getPartitionByExpressions().isEmpty()) {
            return this.rankEndStatesWithinPartitionByStart(endStates);
        }
        LinkedHashMap<Object, Object> perPartition = new LinkedHashMap<Object, Object>();
        for (RegexNFAStateEntry endState : endStates) {
            Object value = perPartition.get(endState.getPartitionKey());
            if (value == null) {
                perPartition.put(endState.getPartitionKey(), endState);
                continue;
            }
            if (value instanceof List) {
                entries = (ArrayList<RegexNFAStateEntry>)value;
                entries.add(endState);
                continue;
            }
            entries = new ArrayList<RegexNFAStateEntry>();
            entries.add((RegexNFAStateEntry)value);
            entries.add(endState);
            perPartition.put(endState.getPartitionKey(), entries);
        }
        ArrayList<RegexNFAStateEntry> finalEndStates = new ArrayList<RegexNFAStateEntry>();
        for (Map.Entry entry : perPartition.entrySet()) {
            if (entry.getValue() instanceof RegexNFAStateEntry) {
                finalEndStates.add((RegexNFAStateEntry)entry.getValue());
                continue;
            }
            entries = (List)entry.getValue();
            finalEndStates.addAll(this.rankEndStatesWithinPartitionByStart(entries));
        }
        return finalEndStates;
    }

    private List<RegexNFAStateEntry> rankEndStatesWithinPartitionByStart(List<RegexNFAStateEntry> endStates) {
        Integer[] keys;
        if (endStates.isEmpty()) {
            return endStates;
        }
        if (endStates.size() == 1) {
            return endStates;
        }
        TreeMap<Integer, Object> endStatesPerBeginEvent = new TreeMap<Integer, Object>();
        for (RegexNFAStateEntry entry : endStates) {
            ArrayList<RegexNFAStateEntry> entries;
            Integer beginNum = entry.getMatchBeginEventSeqNo();
            Object value = endStatesPerBeginEvent.get(beginNum);
            if (value == null) {
                endStatesPerBeginEvent.put(beginNum, entry);
                continue;
            }
            if (value instanceof List) {
                entries = (ArrayList<RegexNFAStateEntry>)value;
                entries.add(entry);
                continue;
            }
            entries = new ArrayList<RegexNFAStateEntry>();
            entries.add((RegexNFAStateEntry)value);
            entries.add(entry);
            endStatesPerBeginEvent.put(beginNum, entries);
        }
        if (endStatesPerBeginEvent.size() == 1) {
            List endStatesUnranked = (List)endStatesPerBeginEvent.values().iterator().next();
            if (this.matchRecognizeSpec.isAllMatches()) {
                return endStatesUnranked;
            }
            RegexNFAStateEntry chosen = this.rankEndStates(endStatesUnranked);
            return Collections.singletonList(chosen);
        }
        ArrayList<RegexNFAStateEntry> endStatesRanked = new ArrayList<RegexNFAStateEntry>();
        Set keyset = endStatesPerBeginEvent.keySet();
        for (Integer key : keys = keyset.toArray(new Integer[keyset.size()])) {
            RegexNFAStateEntry entryTaken;
            Object value = endStatesPerBeginEvent.remove(key);
            if (value == null) continue;
            if (value instanceof List) {
                List endStatesUnranked = (List)value;
                if (endStatesUnranked.isEmpty()) continue;
                entryTaken = this.rankEndStates(endStatesUnranked);
                if (this.matchRecognizeSpec.isAllMatches()) {
                    endStatesRanked.addAll(endStatesUnranked);
                } else {
                    endStatesRanked.add(entryTaken);
                }
            } else {
                entryTaken = (RegexNFAStateEntry)value;
                endStatesRanked.add(entryTaken);
            }
            if (entryTaken == null) continue;
            if (this.matchRecognizeSpec.getSkip().getSkip() == MatchRecognizeSkipEnum.PAST_LAST_ROW) {
                int skipPastRow = entryTaken.getMatchEndEventSeqNo();
                this.removeSkippedEndStates(endStatesPerBeginEvent, skipPastRow);
                continue;
            }
            if (this.matchRecognizeSpec.getSkip().getSkip() != MatchRecognizeSkipEnum.TO_NEXT_ROW) continue;
            int skipPastRow = entryTaken.getMatchBeginEventSeqNo();
            this.removeSkippedEndStates(endStatesPerBeginEvent, skipPastRow);
        }
        return endStatesRanked;
    }

    private void removeSkippedEndStates(TreeMap<Integer, Object> endStatesPerEndEvent, int skipPastRow) {
        for (Map.Entry<Integer, Object> entry : endStatesPerEndEvent.entrySet()) {
            Object value = entry.getValue();
            if (value instanceof List) {
                List endStatesUnranked = (List)value;
                Iterator it = endStatesUnranked.iterator();
                while (it.hasNext()) {
                    RegexNFAStateEntry endState = (RegexNFAStateEntry)it.next();
                    if (endState.getMatchBeginEventSeqNo() > skipPastRow) continue;
                    it.remove();
                }
                continue;
            }
            RegexNFAStateEntry endState = (RegexNFAStateEntry)value;
            if (endState.getMatchBeginEventSeqNo() > skipPastRow) continue;
            endStatesPerEndEvent.put(entry.getKey(), null);
        }
    }

    private List<RegexNFAStateEntry> step(boolean skipTrackMaxState, Iterator<RegexNFAStateEntry> currentStatesIterator, EventBean theEvent, List<RegexNFAStateEntry> nextStates, List<RegexNFAStateEntry> endStates, boolean isRetainEventSet, int currentEventSequenceNumber, Object partitionKey) {
        ArrayList<RegexNFAStateEntry> terminationStates = null;
        while (currentStatesIterator.hasNext()) {
            List<RegexNFAState> nextStatesFromHere;
            RegexNFAStateEntry currentState = currentStatesIterator.next();
            if (this.isTrackMaxStates && !skipTrackMaxState) {
                MatchRecognizeStatePoolStmtSvc poolSvc = this.agentInstanceContext.getStatementContext().getMatchRecognizeStatePoolStmtSvc();
                poolSvc.getEngineSvc().decreaseCount(this.agentInstanceContext);
                poolSvc.getStmtHandler().decreaseCount();
            }
            EventBean[] eventsPerStream = currentState.getEventsPerStream();
            int currentStateStreamNum = currentState.getState().getStreamNum();
            eventsPerStream[currentStateStreamNum] = theEvent;
            if (this.isDefineAsksMultimatches) {
                eventsPerStream[this.numEventsEventsPerStreamDefine - 1] = this.getMultimatchState(currentState);
            }
            if (currentState.getState().matches(eventsPerStream, this.agentInstanceContext)) {
                if (isRetainEventSet) {
                    this.windowMatchedEventset.add(theEvent);
                }
                boolean copy = (nextStatesFromHere = currentState.getState().getNextStates()).size() > 1;
                for (RegexNFAState next : nextStatesFromHere) {
                    EventBean[] eventsForState = eventsPerStream;
                    MultimatchState[] multimatches = currentState.getOptionalMultiMatches();
                    int[] greedyCounts = currentState.getGreedycountPerState();
                    if (copy) {
                        eventsForState = new EventBean[eventsForState.length];
                        System.arraycopy(eventsPerStream, 0, eventsForState, 0, eventsForState.length);
                        int[] greedyCountsCopy = new int[greedyCounts.length];
                        System.arraycopy(greedyCounts, 0, greedyCountsCopy, 0, greedyCounts.length);
                        greedyCounts = greedyCountsCopy;
                        if (this.isCollectMultimatches) {
                            multimatches = this.deepCopy(multimatches);
                        }
                    }
                    if (this.isCollectMultimatches && currentState.getState().isMultiple()) {
                        multimatches = this.addTag(currentState.getState().getStreamNum(), theEvent, multimatches);
                        eventsForState[currentStateStreamNum] = null;
                    }
                    if (currentState.getState().isGreedy() != null && currentState.getState().isGreedy().booleanValue()) {
                        int n = currentState.getState().getNodeNumFlat();
                        greedyCounts[n] = greedyCounts[n] + 1;
                    }
                    RegexNFAStateEntry entry = new RegexNFAStateEntry(currentState.getMatchBeginEventSeqNo(), currentState.getMatchBeginEventTime(), currentState.getState(), eventsForState, greedyCounts, multimatches, partitionKey);
                    if (next instanceof RegexNFAStateEnd) {
                        entry.setMatchEndEventSeqNo(currentEventSequenceNumber);
                        endStates.add(entry);
                        continue;
                    }
                    if (this.isTrackMaxStates && !skipTrackMaxState) {
                        MatchRecognizeStatePoolStmtSvc poolSvc = this.agentInstanceContext.getStatementContext().getMatchRecognizeStatePoolStmtSvc();
                        boolean allow = poolSvc.getEngineSvc().tryIncreaseCount(this.agentInstanceContext);
                        if (!allow) continue;
                        poolSvc.getStmtHandler().increaseCount();
                        entry.setState(next);
                        nextStates.add(entry);
                        continue;
                    }
                    entry.setState(next);
                    nextStates.add(entry);
                }
                continue;
            }
            if (!this.isOrTerminated) continue;
            eventsPerStream[currentStateStreamNum] = null;
            nextStatesFromHere = currentState.getState().getNextStates();
            RegexNFAState theEndState = null;
            for (RegexNFAState next : nextStatesFromHere) {
                if (!(next instanceof RegexNFAStateEnd)) continue;
                theEndState = next;
            }
            if (theEndState == null) continue;
            RegexNFAStateEntry entry = new RegexNFAStateEntry(currentState.getMatchBeginEventSeqNo(), currentState.getMatchBeginEventTime(), theEndState, eventsPerStream, currentState.getGreedycountPerState(), currentState.getOptionalMultiMatches(), partitionKey);
            if (terminationStates == null) {
                terminationStates = new ArrayList<RegexNFAStateEntry>();
            }
            terminationStates.add(entry);
        }
        for (RegexNFAState startState : this.startStates) {
            List<RegexNFAState> nextStatesFromHere;
            EventBean[] eventsPerStream = new EventBean[this.numEventsEventsPerStreamDefine];
            int currentStateStreamNum = startState.getStreamNum();
            eventsPerStream[currentStateStreamNum] = theEvent;
            if (!startState.matches(eventsPerStream, this.agentInstanceContext)) continue;
            if (isRetainEventSet) {
                this.windowMatchedEventset.add(theEvent);
            }
            boolean copy = (nextStatesFromHere = startState.getNextStates()).size() > 1;
            for (RegexNFAState next : nextStatesFromHere) {
                if (this.isTrackMaxStates && !skipTrackMaxState) {
                    MatchRecognizeStatePoolStmtSvc poolSvc = this.agentInstanceContext.getStatementContext().getMatchRecognizeStatePoolStmtSvc();
                    boolean allow = poolSvc.getEngineSvc().tryIncreaseCount(this.agentInstanceContext);
                    if (!allow) continue;
                    poolSvc.getStmtHandler().increaseCount();
                }
                EventBean[] eventsForState = eventsPerStream;
                MultimatchState[] multimatches = this.isCollectMultimatches ? new MultimatchState[this.multimatchVariablesArray.length] : null;
                int[] greedyCounts = new int[this.allStates.length];
                if (copy) {
                    eventsForState = new EventBean[eventsForState.length];
                    System.arraycopy(eventsPerStream, 0, eventsForState, 0, eventsForState.length);
                    int[] greedyCountsCopy = new int[greedyCounts.length];
                    System.arraycopy(greedyCounts, 0, greedyCountsCopy, 0, greedyCounts.length);
                    greedyCounts = greedyCountsCopy;
                }
                if (this.isCollectMultimatches && startState.isMultiple()) {
                    multimatches = this.addTag(startState.getStreamNum(), theEvent, multimatches);
                    eventsForState[currentStateStreamNum] = null;
                }
                if (startState.isGreedy() != null && startState.isGreedy().booleanValue()) {
                    int n = startState.getNodeNumFlat();
                    greedyCounts[n] = greedyCounts[n] + 1;
                }
                long time = 0L;
                if (this.matchRecognizeSpec.getInterval() != null) {
                    time = this.agentInstanceContext.getStatementContext().getSchedulingService().getTime();
                }
                RegexNFAStateEntry entry = new RegexNFAStateEntry(currentEventSequenceNumber, time, startState, eventsForState, greedyCounts, multimatches, partitionKey);
                if (next instanceof RegexNFAStateEnd) {
                    entry.setMatchEndEventSeqNo(currentEventSequenceNumber);
                    endStates.add(entry);
                    continue;
                }
                entry.setState(next);
                nextStates.add(entry);
            }
        }
        return terminationStates;
    }

    private ObjectArrayBackedEventBean getMultimatchState(RegexNFAStateEntry currentState) {
        if (currentState.getOptionalMultiMatches() == null || !currentState.getState().isExprRequiresMultimatchState()) {
            return null;
        }
        Object[] props = this.defineMultimatchEventBean.getProperties();
        MultimatchState[] states = currentState.getOptionalMultiMatches();
        for (int i = 0; i < props.length; ++i) {
            MultimatchState state = states[i];
            props[i] = state == null ? null : state.getShrinkEventArray();
        }
        return this.defineMultimatchEventBean;
    }

    private MultimatchState[] deepCopy(MultimatchState[] multimatchStates) {
        if (multimatchStates == null) {
            return null;
        }
        MultimatchState[] copy = new MultimatchState[multimatchStates.length];
        for (int i = 0; i < copy.length; ++i) {
            if (multimatchStates[i] == null) continue;
            copy[i] = new MultimatchState(multimatchStates[i]);
        }
        return copy;
    }

    private MultimatchState[] addTag(int streamNum, EventBean theEvent, MultimatchState[] multimatches) {
        int index;
        MultimatchState state;
        if (multimatches == null) {
            multimatches = new MultimatchState[this.multimatchVariablesArray.length];
        }
        if ((state = multimatches[index = this.multimatchStreamNumToVariable[streamNum]]) == null) {
            multimatches[index] = new MultimatchState(theEvent);
            return multimatches;
        }
        multimatches[index].add(theEvent);
        return multimatches;
    }

    private EventBean generateOutputRow(RegexNFAStateEntry entry) {
        Object[] rowDataRaw = this.compositeEventBean.getProperties();
        for (Map.Entry<String, Pair<Integer, Boolean>> variableDef : this.variableStreams.entrySet()) {
            if (variableDef.getValue().getSecond().booleanValue()) continue;
            int index = variableDef.getValue().getFirst();
            rowDataRaw[index] = entry.getEventsPerStream()[index];
        }
        if (this.aggregationService != null) {
            this.aggregationService.clearResults();
        }
        if (entry.getOptionalMultiMatches() != null) {
            MultimatchState[] multimatchStateArray = entry.getOptionalMultiMatches();
            for (int i = 0; i < multimatchStateArray.length; ++i) {
                EventBean[] multimatchEvents;
                if (multimatchStateArray[i] == null) {
                    rowDataRaw[this.multimatchVariableToStreamNum[i]] = null;
                    continue;
                }
                rowDataRaw[this.multimatchVariableToStreamNum[i]] = multimatchEvents = multimatchStateArray[i].getShrinkEventArray();
                if (this.aggregationService == null) continue;
                EventBean[] eventsPerStream = entry.getEventsPerStream();
                int streamNum = this.multimatchVariableToStreamNum[i];
                EventBean[] eventBeanArray = multimatchEvents;
                int n = eventBeanArray.length;
                for (int j = 0; j < n; ++j) {
                    EventBean multimatchEvent;
                    eventsPerStream[streamNum] = multimatchEvent = eventBeanArray[j];
                    this.aggregationService.applyEnter(eventsPerStream, streamNum, this.agentInstanceContext);
                }
            }
        } else {
            for (int index : this.multimatchVariableToStreamNum) {
                rowDataRaw[index] = null;
            }
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        int columnNum = 0;
        EventBean[] eventsPerStream = new EventBean[1];
        for (ExprEvaluator expression : this.columnEvaluators) {
            eventsPerStream[0] = this.compositeEventBean;
            Object result = expression.evaluate(eventsPerStream, true, this.agentInstanceContext);
            hashMap.put(this.columnNames[columnNum], result);
            ++columnNum;
        }
        return this.agentInstanceContext.getStatementContext().getEventAdapterService().adapterForTypedMap(hashMap, this.rowEventType);
    }

    private void scheduleCallback(long timeDelta, RegexNFAStateEntry endState) {
        long matchBeginTime = endState.getMatchBeginEventTime();
        if (this.regexPartitionStateRepo.getScheduleState().isEmpty()) {
            this.regexPartitionStateRepo.getScheduleState().putOrAdd(matchBeginTime, endState);
            this.scheduler.addSchedule(timeDelta);
        } else {
            long currentFirstKey;
            boolean newEntry = this.regexPartitionStateRepo.getScheduleState().putOrAdd(matchBeginTime, endState);
            if (newEntry && (currentFirstKey = this.regexPartitionStateRepo.getScheduleState().firstKey()) > matchBeginTime) {
                this.scheduler.changeSchedule(timeDelta);
            }
        }
    }

    private void removeScheduleAddEndState(RegexNFAStateEntry terminationState, List<RegexNFAStateEntry> foundEndStates) {
        long matchBeginTime = terminationState.getMatchBeginEventTime();
        boolean removedOne = this.regexPartitionStateRepo.getScheduleState().findRemoveAddToList(matchBeginTime, terminationState, foundEndStates);
        if (removedOne && this.regexPartitionStateRepo.getScheduleState().isEmpty()) {
            this.scheduler.removeSchedule();
        }
    }

    @Override
    public void triggered() {
        long cutOffTime;
        long firstKey;
        long currentTime = this.agentInstanceContext.getStatementContext().getSchedulingService().getTime();
        long intervalMSec = this.matchRecognizeSpec.getInterval().getScheduleBackwardDelta(currentTime, this.agentInstanceContext);
        if (this.regexPartitionStateRepo.getScheduleState().isEmpty()) {
            return;
        }
        List<RegexNFAStateEntry> indicatables = new ArrayList<RegexNFAStateEntry>();
        while ((firstKey = this.regexPartitionStateRepo.getScheduleState().firstKey()) <= (cutOffTime = currentTime - intervalMSec)) {
            this.regexPartitionStateRepo.getScheduleState().removeAddRemoved(firstKey, indicatables);
            if (!this.regexPartitionStateRepo.getScheduleState().isEmpty()) continue;
            break;
        }
        if (!this.regexPartitionStateRepo.getScheduleState().isEmpty()) {
            long msecAfterCurrentTime = this.regexPartitionStateRepo.getScheduleState().firstKey() + intervalMSec - this.agentInstanceContext.getStatementContext().getSchedulingService().getTime();
            this.scheduler.addSchedule(msecAfterCurrentTime);
        }
        if (!this.matchRecognizeSpec.isAllMatches()) {
            indicatables = this.rankEndStatesMultiPartition(indicatables);
        }
        EventBean[] outBeans = new EventBean[indicatables.size()];
        int count = 0;
        for (RegexNFAStateEntry endState : indicatables) {
            outBeans[count] = this.generateOutputRow(endState);
            ++count;
        }
        this.updateChildren(outBeans, null);
    }

    @Override
    public RegexExprPreviousEvalStrategy getPreviousEvaluationStrategy() {
        return this.prevGetter;
    }

    public EventRowRegexNFAViewFactory getFactory() {
        return this.factory;
    }
}

