/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.schedule;

import com.espertech.esper.type.CronParameter;
import com.espertech.esper.type.ScheduleUnit;
import com.espertech.esper.util.MetaDefItem;
import java.io.Serializable;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public final class ScheduleSpec
implements MetaDefItem,
Serializable {
    private final EnumMap<ScheduleUnit, SortedSet<Integer>> unitValues;
    private String optionalTimeZone;
    private CronParameter optionalDayOfMonthOperator;
    private CronParameter optionalDayOfWeekOperator;
    private static final long serialVersionUID = -7050807714879367353L;

    public ScheduleSpec(EnumMap<ScheduleUnit, SortedSet<Integer>> unitValues, String optionalTimeZone, CronParameter optionalDayOfMonthOperator, CronParameter optionalDayOfWeekOperator) throws IllegalArgumentException {
        ScheduleSpec.validate(unitValues);
        ScheduleSpec.compress(unitValues);
        this.unitValues = unitValues;
        this.optionalTimeZone = optionalTimeZone;
        this.optionalDayOfMonthOperator = optionalDayOfMonthOperator;
        this.optionalDayOfWeekOperator = optionalDayOfWeekOperator;
    }

    public ScheduleSpec() {
        this.unitValues = new EnumMap(ScheduleUnit.class);
        this.unitValues.put(ScheduleUnit.MINUTES, null);
        this.unitValues.put(ScheduleUnit.HOURS, null);
        this.unitValues.put(ScheduleUnit.DAYS_OF_MONTH, null);
        this.unitValues.put(ScheduleUnit.MONTHS, null);
        this.unitValues.put(ScheduleUnit.DAYS_OF_WEEK, null);
        this.optionalTimeZone = null;
    }

    public CronParameter getOptionalDayOfMonthOperator() {
        return this.optionalDayOfMonthOperator;
    }

    public CronParameter getOptionalDayOfWeekOperator() {
        return this.optionalDayOfWeekOperator;
    }

    public void setOptionalTimeZone(String optionalTimeZone) {
        this.optionalTimeZone = optionalTimeZone;
    }

    public final EnumMap<ScheduleUnit, SortedSet<Integer>> getUnitValues() {
        return this.unitValues;
    }

    public String getOptionalTimeZone() {
        return this.optionalTimeZone;
    }

    public final void addValue(ScheduleUnit element, int value) {
        SortedSet<Integer> set = this.unitValues.get((Object)element);
        if (set == null) {
            set = new TreeSet<Integer>();
            this.unitValues.put(element, set);
        }
        set.add(value);
    }

    public final String toString() {
        StringBuilder buffer = new StringBuilder();
        for (ScheduleUnit element : ScheduleUnit.values()) {
            if (!this.unitValues.containsKey((Object)element)) continue;
            Set valueSet = this.unitValues.get((Object)element);
            buffer.append((Object)((Object)element) + "={");
            if (valueSet == null) {
                buffer.append("null");
            } else {
                String delimiter = "";
                Iterator iterator = valueSet.iterator();
                while (iterator.hasNext()) {
                    int i = (Integer)iterator.next();
                    buffer.append(delimiter + i);
                    delimiter = ",";
                }
            }
            buffer.append("} ");
        }
        return buffer.toString();
    }

    public final boolean equals(Object otherObject) {
        if (otherObject == this) {
            return true;
        }
        if (otherObject == null) {
            return false;
        }
        if (this.getClass() != otherObject.getClass()) {
            return false;
        }
        ScheduleSpec other = (ScheduleSpec)otherObject;
        if (this.unitValues.size() != other.unitValues.size()) {
            return false;
        }
        for (Map.Entry<ScheduleUnit, SortedSet<Integer>> entry : this.unitValues.entrySet()) {
            Set mySet = entry.getValue();
            Set otherSet = other.unitValues.get((Object)entry.getKey());
            if (otherSet == null && mySet != null) {
                return false;
            }
            if (otherSet != null && mySet == null) {
                return false;
            }
            if (otherSet == null && mySet == null) continue;
            if (mySet.size() != otherSet.size()) {
                return false;
            }
            Iterator iterator = mySet.iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                if (otherSet.contains(i)) continue;
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 0;
        for (Map.Entry<ScheduleUnit, SortedSet<Integer>> entry : this.unitValues.entrySet()) {
            if (entry.getValue() == null) continue;
            hashCode *= 31;
            hashCode ^= ((Integer)entry.getValue().iterator().next()).intValue();
        }
        return hashCode;
    }

    protected static void compress(Map<ScheduleUnit, SortedSet<Integer>> unitValues) {
        for (Map.Entry<ScheduleUnit, SortedSet<Integer>> entry : unitValues.entrySet()) {
            int elementValueSetSize = entry.getKey().max() - entry.getKey().min() + 1;
            if (entry.getValue() == null || entry.getValue().size() != elementValueSetSize) continue;
            unitValues.put(entry.getKey(), null);
        }
    }

    protected static void validate(Map<ScheduleUnit, SortedSet<Integer>> unitValues) {
        if (!(unitValues.containsKey((Object)ScheduleUnit.MONTHS) && unitValues.containsKey((Object)ScheduleUnit.DAYS_OF_WEEK) && unitValues.containsKey((Object)ScheduleUnit.HOURS) && unitValues.containsKey((Object)ScheduleUnit.MINUTES) && unitValues.containsKey((Object)ScheduleUnit.DAYS_OF_MONTH))) {
            throw new IllegalArgumentException("Incomplete information for schedule specification, only the following keys are supplied=" + Arrays.toString(unitValues.keySet().toArray()));
        }
        for (ScheduleUnit unit : ScheduleUnit.values()) {
            if (unit == ScheduleUnit.SECONDS && !unitValues.containsKey((Object)unit) || unitValues.get((Object)unit) == null) continue;
            SortedSet<Integer> values = unitValues.get((Object)unit);
            for (Integer value : values) {
                if (value >= unit.min() && value <= unit.max()) continue;
                throw new IllegalArgumentException("Invalid value found for schedule unit, value of " + value + " is not valid for unit " + (Object)((Object)unit));
            }
        }
    }
}

