/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.spatial.quadtree.mxciffilterindex;

import com.espertech.esper.spatial.quadtree.core.BoundingBox;
import com.espertech.esper.spatial.quadtree.core.QuadrantAppliesEnum;
import com.espertech.esper.spatial.quadtree.mxcif.MXCIFQuadTree;
import com.espertech.esper.spatial.quadtree.mxcif.MXCIFQuadTreeNode;
import com.espertech.esper.spatial.quadtree.mxcif.MXCIFQuadTreeNodeBranch;
import com.espertech.esper.spatial.quadtree.mxcif.MXCIFQuadTreeNodeLeaf;
import com.espertech.esper.spatial.quadtree.mxciffilterindex.XYWHRectangleWValue;
import com.espertech.esper.spatial.quadtree.mxcifrowindex.MXCIFQuadTreeFilterIndexCheckBB;
import java.util.Collection;
import java.util.LinkedList;

public class MXCIFQuadTreeFilterIndexSet {
    public static <L> void set(double x, double y, double width, double height, L value, MXCIFQuadTree<Object> tree) {
        MXCIFQuadTreeNode<Object> root = tree.getRoot();
        MXCIFQuadTreeFilterIndexCheckBB.checkBB(root.getBb(), x, y, width, height);
        MXCIFQuadTreeNode<Object> replacement = MXCIFQuadTreeFilterIndexSet.setOnNode(x, y, width, height, value, root, tree);
        tree.setRoot(replacement);
    }

    private static <L> MXCIFQuadTreeNode<Object> setOnNode(double x, double y, double width, double height, L value, MXCIFQuadTreeNode<Object> node, MXCIFQuadTree<Object> tree) {
        if (node instanceof MXCIFQuadTreeNodeLeaf) {
            MXCIFQuadTreeNodeLeaf leaf = (MXCIFQuadTreeNodeLeaf)node;
            int count = MXCIFQuadTreeFilterIndexSet.setOnNode(leaf, x, y, width, height, value);
            leaf.incCount(count);
            if (leaf.getCount() <= tree.getLeafCapacity() || node.getLevel() >= tree.getMaxTreeHeight()) {
                return leaf;
            }
            node = MXCIFQuadTreeFilterIndexSet.subdivide(leaf, tree);
        }
        MXCIFQuadTreeNodeBranch branch = (MXCIFQuadTreeNodeBranch)node;
        MXCIFQuadTreeFilterIndexSet.addToBranch(branch, x, y, width, height, value, tree);
        return node;
    }

    private static void addToBranch(MXCIFQuadTreeNodeBranch<Object> branch, double x, double y, double width, double height, Object value, MXCIFQuadTree<Object> tree) {
        QuadrantAppliesEnum quadrant = branch.getBb().getQuadrantApplies(x, y, width, height);
        if (quadrant == QuadrantAppliesEnum.NW) {
            branch.setNw(MXCIFQuadTreeFilterIndexSet.setOnNode(x, y, width, height, value, branch.getNw(), tree));
        } else if (quadrant == QuadrantAppliesEnum.NE) {
            branch.setNe(MXCIFQuadTreeFilterIndexSet.setOnNode(x, y, width, height, value, branch.getNe(), tree));
        } else if (quadrant == QuadrantAppliesEnum.SW) {
            branch.setSw(MXCIFQuadTreeFilterIndexSet.setOnNode(x, y, width, height, value, branch.getSw(), tree));
        } else if (quadrant == QuadrantAppliesEnum.SE) {
            branch.setSe(MXCIFQuadTreeFilterIndexSet.setOnNode(x, y, width, height, value, branch.getSe(), tree));
        } else if (quadrant == QuadrantAppliesEnum.SOME) {
            int count = MXCIFQuadTreeFilterIndexSet.setOnNode(branch, x, y, width, height, value);
            branch.incCount(count);
        } else {
            throw new IllegalStateException("Quandrant not applies to any");
        }
    }

    private static <L> MXCIFQuadTreeNode<Object> subdivide(MXCIFQuadTreeNodeLeaf<Object> leaf, MXCIFQuadTree<Object> tree) {
        double w = (leaf.getBb().getMaxX() - leaf.getBb().getMinX()) / 2.0;
        double h = (leaf.getBb().getMaxY() - leaf.getBb().getMinY()) / 2.0;
        double minx = leaf.getBb().getMinX();
        double miny = leaf.getBb().getMinY();
        BoundingBox bbNW = new BoundingBox(minx, miny, minx + w, miny + h);
        BoundingBox bbNE = new BoundingBox(minx + w, miny, leaf.getBb().getMaxX(), miny + h);
        BoundingBox bbSW = new BoundingBox(minx, miny + h, minx + w, leaf.getBb().getMaxY());
        BoundingBox bbSE = new BoundingBox(minx + w, miny + h, leaf.getBb().getMaxX(), leaf.getBb().getMaxY());
        MXCIFQuadTreeNodeLeaf<Object> nw = new MXCIFQuadTreeNodeLeaf<Object>(bbNW, leaf.getLevel() + 1, null, 0);
        MXCIFQuadTreeNodeLeaf<Object> ne = new MXCIFQuadTreeNodeLeaf<Object>(bbNE, leaf.getLevel() + 1, null, 0);
        MXCIFQuadTreeNodeLeaf<Object> sw = new MXCIFQuadTreeNodeLeaf<Object>(bbSW, leaf.getLevel() + 1, null, 0);
        MXCIFQuadTreeNodeLeaf<Object> se = new MXCIFQuadTreeNodeLeaf<Object>(bbSE, leaf.getLevel() + 1, null, 0);
        MXCIFQuadTreeNodeBranch<Object> branch = new MXCIFQuadTreeNodeBranch<Object>(leaf.getBb(), leaf.getLevel(), null, 0, nw, ne, sw, se);
        Object rectangles = leaf.getData();
        if (rectangles instanceof XYWHRectangleWValue) {
            XYWHRectangleWValue rectangle = (XYWHRectangleWValue)rectangles;
            MXCIFQuadTreeFilterIndexSet.subdivide(rectangle, branch, tree);
        } else {
            Collection collection = (Collection)rectangles;
            for (XYWHRectangleWValue rectangle : collection) {
                MXCIFQuadTreeFilterIndexSet.subdivide(rectangle, branch, tree);
            }
        }
        return branch;
    }

    private static <L> void subdivide(XYWHRectangleWValue<L> rectangle, MXCIFQuadTreeNodeBranch<Object> branch, MXCIFQuadTree<Object> tree) {
        double x = rectangle.getX();
        double y = rectangle.getY();
        double w = rectangle.getW();
        double h = rectangle.getH();
        QuadrantAppliesEnum quadrant = branch.getBb().getQuadrantApplies(x, y, w, h);
        if (quadrant == QuadrantAppliesEnum.NW) {
            branch.setNw(MXCIFQuadTreeFilterIndexSet.setOnNode(x, y, w, h, rectangle, branch.getNw(), tree));
        } else if (quadrant == QuadrantAppliesEnum.NE) {
            branch.setNe(MXCIFQuadTreeFilterIndexSet.setOnNode(x, y, w, h, rectangle, branch.getNe(), tree));
        } else if (quadrant == QuadrantAppliesEnum.SW) {
            branch.setSw(MXCIFQuadTreeFilterIndexSet.setOnNode(x, y, w, h, rectangle, branch.getSw(), tree));
        } else if (quadrant == QuadrantAppliesEnum.SE) {
            branch.setSe(MXCIFQuadTreeFilterIndexSet.setOnNode(x, y, w, h, rectangle, branch.getSe(), tree));
        } else if (quadrant == QuadrantAppliesEnum.SOME) {
            int numAdded = MXCIFQuadTreeFilterIndexSet.setOnNode(branch, x, y, w, h, rectangle);
            branch.incCount(numAdded);
        } else {
            throw new IllegalStateException("No intersection");
        }
    }

    private static <L> int setOnNode(MXCIFQuadTreeNode<Object> node, double x, double y, double width, double height, L value) {
        Object currentValue = node.getData();
        if (value instanceof XYWHRectangleWValue) {
            XYWHRectangleWValue rectangle = (XYWHRectangleWValue)value;
            if (!rectangle.coordinateEquals(x, y, width, height)) {
                throw new IllegalStateException();
            }
            if (currentValue == null) {
                node.setData(rectangle);
                return 1;
            }
            if (currentValue instanceof XYWHRectangleWValue) {
                XYWHRectangleWValue other = (XYWHRectangleWValue)currentValue;
                if (other.coordinateEquals(x, y, width, height)) {
                    other.setValue(value);
                    return 0;
                }
                LinkedList<XYWHRectangleWValue> collection = new LinkedList<XYWHRectangleWValue>();
                collection.add(other);
                collection.add(rectangle);
                node.setData(collection);
                return 1;
            }
            Collection collection = (Collection)currentValue;
            for (XYWHRectangleWValue other : collection) {
                if (!other.coordinateEquals(x, y, width, height)) continue;
                other.setValue(value);
                return 0;
            }
            collection.add(rectangle);
            return 1;
        }
        if (currentValue == null) {
            XYWHRectangleWValue<L> point = new XYWHRectangleWValue<L>(x, y, width, height, value);
            node.setData(point);
            return 1;
        }
        if (currentValue instanceof XYWHRectangleWValue) {
            XYWHRectangleWValue other = (XYWHRectangleWValue)currentValue;
            if (other.coordinateEquals(x, y, width, height)) {
                other.setValue(value);
                return 0;
            }
            LinkedList<XYWHRectangleWValue<L>> collection = new LinkedList<XYWHRectangleWValue<L>>();
            collection.add(other);
            collection.add(new XYWHRectangleWValue<L>(x, y, width, height, value));
            node.setData(collection);
            return 1;
        }
        Collection collection = (Collection)currentValue;
        for (XYWHRectangleWValue other : collection) {
            if (!other.coordinateEquals(x, y, width, height)) continue;
            other.setValue(value);
            return 0;
        }
        collection.add(new XYWHRectangleWValue<L>(x, y, width, height, value));
        return 1;
    }
}

