/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.spatial.quadtree.mxcifrowindex;

import com.espertech.esper.spatial.quadtree.mxcif.XYWHRectangle;
import java.util.Collection;
import java.util.LinkedList;

public class XYWHRectangleMultiType
extends XYWHRectangle {
    private Object multityped;

    public XYWHRectangleMultiType(double x, double y, double w, double h, Object multityped) {
        super(x, y, w, h);
        this.multityped = multityped;
    }

    public Object getMultityped() {
        return this.multityped;
    }

    public void setMultityped(Object multityped) {
        this.multityped = multityped;
    }

    public int count() {
        if (this.multityped instanceof Collection) {
            return ((Collection)this.multityped).size();
        }
        return 1;
    }

    public void addSingleValue(Object value) {
        if (this.multityped == null) {
            this.multityped = value;
            return;
        }
        if (this.multityped instanceof Collection) {
            ((Collection)this.multityped).add(value);
            return;
        }
        LinkedList<Object> coll = new LinkedList<Object>();
        coll.add(this.multityped);
        coll.add(value);
        this.multityped = coll;
    }

    public void addMultiType(XYWHRectangleMultiType other) {
        if (other.getX() != this.x || other.getY() != this.y) {
            throw new IllegalArgumentException("Coordinate mismatch");
        }
        if (!(other.multityped instanceof Collection)) {
            this.addSingleValue(other.getMultityped());
            return;
        }
        Collection otherCollection = (Collection)other.multityped;
        if (this.multityped instanceof Collection) {
            ((Collection)this.multityped).addAll(otherCollection);
            return;
        }
        LinkedList<Object> coll = new LinkedList<Object>();
        coll.add(this.multityped);
        coll.addAll(otherCollection);
        this.multityped = coll;
    }

    public void collectInto(Collection<Object> result) {
        if (!(this.multityped instanceof Collection)) {
            result.add(this.multityped);
            return;
        }
        result.addAll((Collection)this.multityped);
    }

    public boolean remove(Object value) {
        if (this.multityped == null) {
            return false;
        }
        if (this.multityped.equals(value)) {
            this.multityped = null;
            return true;
        }
        if (this.multityped instanceof Collection) {
            return ((Collection)this.multityped).remove(value);
        }
        return false;
    }

    public boolean isEmpty() {
        return this.multityped == null || this.multityped instanceof Collection && ((Collection)this.multityped).isEmpty();
    }

    public String toString() {
        return "XYWHRectangleMultiType{x=" + this.x + ", y=" + this.y + ", w=" + this.w + ", h=" + this.h + ", multityped=" + this.multityped + '}';
    }
}

