/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.util;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.annotation.AuditEnum;
import com.espertech.esper.event.EventBeanUtility;
import com.espertech.esper.util.AuditCallback;
import com.espertech.esper.util.AuditContext;
import java.io.StringWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditPath {
    private static final Logger AUDIT_LOG_DESTINATION = LoggerFactory.getLogger((String)"com.espertech.esper.audit");
    private static volatile AuditCallback auditCallback;
    public static final String QUERYPLAN_LOG = "com.espertech.esper.queryplan";
    public static final String JDBC_LOG = "com.espertech.esper.jdbc";
    public static final String AUDIT_LOG = "com.espertech.esper.audit";
    public static boolean isAuditEnabled;
    private static String auditPattern;

    public static void setAuditPattern(String auditPattern) {
        AuditPath.auditPattern = auditPattern;
    }

    public static void auditInsertInto(String engineURI, String statementName, EventBean theEvent) {
        AuditPath.auditLog(engineURI, statementName, AuditEnum.INSERT, EventBeanUtility.summarize(theEvent));
    }

    public static void auditContextPartition(String engineURI, String statementName, boolean allocate, int agentInstanceId) {
        StringWriter writer = new StringWriter();
        writer.write(allocate ? "Allocate" : "Destroy");
        writer.write(" cpid ");
        writer.write(Integer.toString(agentInstanceId));
        AuditPath.auditLog(engineURI, statementName, AuditEnum.CONTEXTPARTITION, writer.toString());
    }

    public static void auditLog(String engineURI, String statementName, AuditEnum category, String message) {
        if (auditPattern == null) {
            String text = AuditContext.defaultFormat(statementName, category, message);
            AUDIT_LOG_DESTINATION.info(text);
        } else {
            String result = auditPattern.replace("%s", statementName).replace("%u", engineURI).replace("%c", category.getValue()).replace("%m", message);
            AUDIT_LOG_DESTINATION.info(result);
        }
        if (auditCallback != null) {
            auditCallback.audit(new AuditContext(engineURI, statementName, category, message));
        }
    }

    public static boolean isInfoEnabled() {
        return AUDIT_LOG_DESTINATION.isInfoEnabled() || auditCallback != null;
    }

    public static void setAuditCallback(AuditCallback auditCallback) {
        AuditPath.auditCallback = auditCallback;
    }

    public static AuditCallback getAuditCallback() {
        return auditCallback;
    }

    static {
        isAuditEnabled = false;
    }
}

