/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.util;

import com.espertech.esper.client.dataflow.EPDataFlowOperatorParameterProvider;
import com.espertech.esper.client.dataflow.EPDataFlowOperatorParameterProviderContext;
import com.espertech.esper.dataflow.annotations.DataFlowOpParameter;
import com.espertech.esper.epl.core.EngineImportService;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprIdentNode;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprNodeOrigin;
import com.espertech.esper.epl.expression.core.ExprNodeUtility;
import com.espertech.esper.epl.expression.core.ExprValidationContext;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.expression.core.ExprValidationPropertyException;
import com.espertech.esper.event.WriteablePropertyDescriptor;
import com.espertech.esper.event.bean.PropertyHelper;
import com.espertech.esper.event.property.MappedProperty;
import com.espertech.esper.event.property.Property;
import com.espertech.esper.event.property.PropertyParser;
import com.espertech.esper.util.JavaClassHelper;
import com.espertech.esper.util.PopulateFieldWValueDescriptor;
import com.espertech.esper.util.URIUtil;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PopulateUtil {
    private static final String CLASS_PROPERTY_NAME = "class";
    private static final String SYSTEM_PROPETIES_NAME = "systemProperties".toLowerCase(Locale.ENGLISH);
    private static Logger log = LoggerFactory.getLogger(PopulateUtil.class);

    public static Object instantiatePopulateObject(Map<String, Object> objectProperties, Class topClass, ExprNodeOrigin exprNodeOrigin, ExprValidationContext exprValidationContext) throws ExprValidationException {
        Object top;
        Class applicableClass = topClass;
        if (topClass.isInterface()) {
            applicableClass = PopulateUtil.findInterfaceImplementation(objectProperties, topClass, exprValidationContext.getEngineImportService());
        }
        try {
            top = applicableClass.newInstance();
        }
        catch (RuntimeException e) {
            throw new ExprValidationException("Exception instantiating class " + applicableClass.getName() + ": " + e.getMessage(), e);
        }
        catch (InstantiationException e) {
            throw new ExprValidationException(PopulateUtil.getMessageExceptionInstantiating(applicableClass), e);
        }
        catch (IllegalAccessException e) {
            throw new ExprValidationException("Illegal access to construct class " + applicableClass.getName() + ": " + e.getMessage(), e);
        }
        PopulateUtil.populateObject(topClass.getSimpleName(), 0, topClass.getSimpleName(), objectProperties, top, exprNodeOrigin, exprValidationContext, null, null);
        return top;
    }

    public static void populateObject(String operatorName, int operatorNum, String dataFlowName, Map<String, Object> objectProperties, Object top, ExprNodeOrigin exprNodeOrigin, ExprValidationContext exprValidationContext, EPDataFlowOperatorParameterProvider optionalParameterProvider, Map<String, Object> optionalParameterURIs) throws ExprValidationException {
        Iterator<Map.Entry<String, Object>> value;
        Class<?> applicableClass = top.getClass();
        Set<WriteablePropertyDescriptor> writables = PropertyHelper.getWritableProperties(applicableClass);
        Set<Field> annotatedFields = JavaClassHelper.findAnnotatedFields(top.getClass(), DataFlowOpParameter.class);
        Set<Method> annotatedMethods = JavaClassHelper.findAnnotatedMethods(top.getClass(), DataFlowOpParameter.class);
        LinkedHashSet<Method> catchAllMethods = new LinkedHashSet<Method>();
        if (annotatedMethods != null) {
            for (Method method : annotatedMethods) {
                DataFlowOpParameter anno = (DataFlowOpParameter)JavaClassHelper.getAnnotations(DataFlowOpParameter.class, method.getDeclaredAnnotations()).get(0);
                if (!anno.all()) continue;
                if (method.getParameterTypes().length == 2 && method.getParameterTypes()[0] == String.class && method.getParameterTypes()[1] == Object.class) {
                    catchAllMethods.add(method);
                    continue;
                }
                throw new ExprValidationException("Invalid annotation for catch-call");
            }
        }
        for (Map.Entry entry : objectProperties.entrySet()) {
            boolean found = false;
            String propertyName = (String)entry.getKey();
            for (Method method : catchAllMethods) {
                try {
                    method.invoke(top, propertyName, entry.getValue());
                }
                catch (IllegalAccessException e) {
                    throw new ExprValidationException("Illegal access invoking method for property '" + propertyName + "' for class " + applicableClass.getName() + " method " + method.getName(), e);
                }
                catch (InvocationTargetException e) {
                    throw new ExprValidationException("Exception invoking method for property '" + propertyName + "' for class " + applicableClass.getName() + " method " + method.getName() + ": " + e.getTargetException().getMessage(), e);
                }
                found = true;
            }
            if (propertyName.toLowerCase(Locale.ENGLISH).equals(CLASS_PROPERTY_NAME)) continue;
            WriteablePropertyDescriptor descriptor = PopulateUtil.findDescriptor(applicableClass, propertyName, writables);
            if (descriptor != null) {
                Object coerceProperty = PopulateUtil.coerceProperty(propertyName, applicableClass, entry.getValue(), descriptor.getType(), exprNodeOrigin, exprValidationContext, false, true);
                try {
                    descriptor.getWriteMethod().invoke(top, coerceProperty);
                    continue;
                }
                catch (IllegalArgumentException e) {
                    throw new ExprValidationException("Illegal argument invoking setter method for property '" + propertyName + "' for class " + applicableClass.getName() + " method " + descriptor.getWriteMethod().getName() + " provided value " + coerceProperty, e);
                }
                catch (IllegalAccessException e) {
                    throw new ExprValidationException("Illegal access invoking setter method for property '" + propertyName + "' for class " + applicableClass.getName() + " method " + descriptor.getWriteMethod().getName(), e);
                }
                catch (InvocationTargetException e) {
                    throw new ExprValidationException("Exception invoking setter method for property '" + propertyName + "' for class " + applicableClass.getName() + " method " + descriptor.getWriteMethod().getName() + ": " + e.getTargetException().getMessage(), e);
                }
            }
            for (Field annotatedField : annotatedFields) {
                DataFlowOpParameter anno = (DataFlowOpParameter)JavaClassHelper.getAnnotations(DataFlowOpParameter.class, annotatedField.getDeclaredAnnotations()).get(0);
                if (!anno.name().equals(propertyName) && !annotatedField.getName().equals(propertyName)) continue;
                Object coerceProperty = PopulateUtil.coerceProperty(propertyName, applicableClass, entry.getValue(), annotatedField.getType(), exprNodeOrigin, exprValidationContext, true, true);
                try {
                    annotatedField.setAccessible(true);
                    annotatedField.set(top, coerceProperty);
                }
                catch (Exception e) {
                    throw new ExprValidationException("Failed to set field '" + annotatedField.getName() + "': " + e.getMessage(), e);
                }
                found = true;
                break;
            }
            if (found) continue;
            throw new ExprValidationException("Failed to find writable property '" + propertyName + "' for class " + applicableClass.getName());
        }
        if (optionalParameterURIs != null) {
            for (Field field : annotatedFields) {
                try {
                    field.setAccessible(true);
                    String uri = operatorName + "/" + field.getName();
                    if (optionalParameterURIs.containsKey(uri)) {
                        value = optionalParameterURIs.get(uri);
                        field.set(top, value);
                        if (!log.isDebugEnabled()) continue;
                        log.debug("Found parameter '" + uri + "' for data flow " + dataFlowName + " setting " + value);
                        continue;
                    }
                    if (!log.isDebugEnabled()) continue;
                    log.debug("Not found parameter '" + uri + "' for data flow " + dataFlowName);
                }
                catch (Exception e) {
                    throw new ExprValidationException("Failed to set field '" + field.getName() + "': " + e.getMessage(), e);
                }
            }
            for (Method method : annotatedMethods) {
                DataFlowOpParameter anno = (DataFlowOpParameter)JavaClassHelper.getAnnotations(DataFlowOpParameter.class, method.getDeclaredAnnotations()).get(0);
                if (!anno.all() || method.getParameterTypes().length != 2 || method.getParameterTypes()[0] != String.class || method.getParameterTypes()[1] != Object.class) continue;
                for (Map.Entry<String, Object> entry : optionalParameterURIs.entrySet()) {
                    String[] elements = URIUtil.parsePathElements(URI.create(entry.getKey()));
                    if (elements.length < 2) {
                        throw new ExprValidationException("Failed to parse URI '" + entry.getKey() + "', expected 'operator_name/property_name' format");
                    }
                    if (!elements[0].equals(operatorName)) continue;
                    try {
                        method.invoke(top, elements[1], entry.getValue());
                    }
                    catch (IllegalAccessException e) {
                        throw new ExprValidationException("Illegal access invoking method for property '" + entry.getKey() + "' for class " + applicableClass.getName() + " method " + method.getName(), e);
                    }
                    catch (InvocationTargetException e) {
                        throw new ExprValidationException("Exception invoking method for property '" + entry.getKey() + "' for class " + applicableClass.getName() + " method " + method.getName() + ": " + e.getTargetException().getMessage(), e);
                    }
                }
            }
        }
        if (optionalParameterProvider != null) {
            for (Field field : annotatedFields) {
                try {
                    field.setAccessible(true);
                    Object provided = field.get(top);
                    value = optionalParameterProvider.provide(new EPDataFlowOperatorParameterProviderContext(operatorName, field.getName(), top, operatorNum, provided, dataFlowName));
                    if (value == null) continue;
                    field.set(top, value);
                }
                catch (Exception e) {
                    throw new ExprValidationException("Failed to set field '" + field.getName() + "': " + e.getMessage(), e);
                }
            }
        }
    }

    private static Class findInterfaceImplementation(Map<String, Object> properties, Class topClass, EngineImportService engineImportService) throws ExprValidationException {
        Class clazz;
        String message;
        block7: {
            message = "Failed to find implementation for interface " + topClass.getName();
            if (!properties.containsKey(CLASS_PROPERTY_NAME)) {
                throw new ExprValidationException(message + ", for interfaces please specified the '" + CLASS_PROPERTY_NAME + "' field that provides the class name either as a simple class name or fully qualified");
            }
            clazz = null;
            String className = (String)properties.get(CLASS_PROPERTY_NAME);
            try {
                clazz = JavaClassHelper.getClassForName(className, engineImportService.getClassForNameProvider());
            }
            catch (ClassNotFoundException e) {
                if (!className.contains(".")) {
                    className = topClass.getPackage().getName() + "." + className;
                    try {
                        clazz = JavaClassHelper.getClassForName(className, engineImportService.getClassForNameProvider());
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                }
                if (clazz != null) break block7;
                throw new ExprValidationPropertyException(message + ", could not find class by name '" + className + "'");
            }
        }
        if (!JavaClassHelper.isSubclassOrImplementsInterface(clazz, topClass)) {
            throw new ExprValidationException(message + ", class " + JavaClassHelper.getClassNameFullyQualPretty(clazz) + " does not implement the interface");
        }
        return clazz;
    }

    public static void populateSpecCheckParameters(PopulateFieldWValueDescriptor[] descriptors, Map<String, Object> jsonRaw, Object spec, ExprNodeOrigin exprNodeOrigin, ExprValidationContext exprValidationContext) throws ExprValidationException {
        LinkedHashMap<String, Object> lowerCaseJsonRaw = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Object> entry : jsonRaw.entrySet()) {
            lowerCaseJsonRaw.put(entry.getKey().toLowerCase(Locale.ENGLISH), entry.getValue());
        }
        jsonRaw = lowerCaseJsonRaw;
        for (PopulateFieldWValueDescriptor desc : descriptors) {
            Object value = jsonRaw.remove(desc.getPropertyName().toLowerCase(Locale.ENGLISH));
            Object coerced = PopulateUtil.coerceProperty(desc.getPropertyName(), desc.getContainerType(), value, desc.getFieldType(), exprNodeOrigin, exprValidationContext, desc.isForceNumeric(), false);
            desc.getSetter().set(coerced);
        }
        if (!jsonRaw.isEmpty()) {
            throw new ExprValidationException("Unrecognized parameter '" + jsonRaw.keySet().iterator().next() + "'");
        }
    }

    public static Object coerceProperty(String propertyName, Class containingType, Object value, Class type, ExprNodeOrigin exprNodeOrigin, ExprValidationContext exprValidationContext, boolean forceNumeric, boolean includeClassNameInEx) throws ExprValidationException {
        String detail;
        if (value instanceof ExprNode && type != ExprNode.class) {
            if (value instanceof ExprIdentNode) {
                Property prop;
                ExprIdentNode identNode = (ExprIdentNode)value;
                try {
                    prop = PropertyParser.parseAndWalkLaxToSimple(identNode.getFullUnresolvedName());
                }
                catch (Exception ex) {
                    throw new ExprValidationException("Failed to parse property '" + identNode.getFullUnresolvedName() + "'");
                }
                if (!(prop instanceof MappedProperty)) {
                    throw new ExprValidationException("Unrecognized property '" + identNode.getFullUnresolvedName() + "'");
                }
                MappedProperty mappedProperty = (MappedProperty)prop;
                if (mappedProperty.getPropertyNameAtomic().toLowerCase(Locale.ENGLISH).equals(SYSTEM_PROPETIES_NAME)) {
                    return System.getProperty(mappedProperty.getKey());
                }
            } else {
                ExprNode exprNode = (ExprNode)value;
                ExprNode validated = ExprNodeUtility.getValidatedSubtree(exprNodeOrigin, exprNode, exprValidationContext);
                exprValidationContext.getVariableService().setLocalVersion();
                ExprEvaluator evaluator = validated.getExprEvaluator();
                if (evaluator == null) {
                    throw new ExprValidationException("Failed to evaluate expression '" + ExprNodeUtility.toExpressionStringMinPrecedenceSafe(exprNode) + "'");
                }
                value = evaluator.evaluate(null, true, null);
            }
        }
        if (value == null) {
            return null;
        }
        if (value.getClass() == type) {
            return value;
        }
        if (JavaClassHelper.isAssignmentCompatible(value.getClass(), type)) {
            if (forceNumeric && JavaClassHelper.getBoxedType(value.getClass()) != JavaClassHelper.getBoxedType(type) && JavaClassHelper.isNumeric(type) && JavaClassHelper.isNumeric(value.getClass())) {
                value = JavaClassHelper.coerceBoxed((Number)value, JavaClassHelper.getBoxedType(type));
            }
            return value;
        }
        if (JavaClassHelper.isSubclassOrImplementsInterface(value.getClass(), type)) {
            return value;
        }
        if (type.isArray()) {
            if (!(value instanceof Collection)) {
                detail = "expects an array but receives a value of type " + value.getClass().getName();
                throw new ExprValidationException(PopulateUtil.getExceptionText(propertyName, containingType, includeClassNameInEx, detail));
            }
            Object[] items = ((Collection)value).toArray();
            Object coercedArray = Array.newInstance(type.getComponentType(), items.length);
            for (int i = 0; i < items.length; ++i) {
                Object coercedValue = PopulateUtil.coerceProperty(propertyName + " (array element)", type, items[i], type.getComponentType(), exprNodeOrigin, exprValidationContext, false, includeClassNameInEx);
                Array.set(coercedArray, i, coercedValue);
            }
            return coercedArray;
        }
        if (!(value instanceof Map)) {
            detail = "expects an " + JavaClassHelper.getClassNameFullyQualPretty(type) + " but receives a value of type " + value.getClass().getName();
            throw new ExprValidationException(PopulateUtil.getExceptionText(propertyName, containingType, includeClassNameInEx, detail));
        }
        Map props = (Map)value;
        return PopulateUtil.instantiatePopulateObject(props, type, exprNodeOrigin, exprValidationContext);
    }

    private static String getExceptionText(String propertyName, Class containingType, boolean includeClassNameInEx, String detailText) {
        String msg = "Property '" + propertyName + "'";
        if (includeClassNameInEx) {
            msg = msg + " of class " + JavaClassHelper.getClassNameFullyQualPretty(containingType);
        }
        msg = msg + " " + detailText;
        return msg;
    }

    private static WriteablePropertyDescriptor findDescriptor(Class clazz, String propertyName, Set<WriteablePropertyDescriptor> writables) throws ExprValidationException {
        for (WriteablePropertyDescriptor desc : writables) {
            if (!desc.getPropertyName().toLowerCase(Locale.ENGLISH).equals(propertyName.toLowerCase(Locale.ENGLISH))) continue;
            return desc;
        }
        return null;
    }

    private static String getMessageExceptionInstantiating(Class clazz) {
        return "Exception instantiating class " + clazz.getName() + ", please make sure the class has a public no-arg constructor (and for inner classes is declared static)";
    }
}

