/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view.ext;

import com.espertech.esper.client.EventType;
import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.core.context.util.AgentInstanceViewFactoryChainContext;
import com.espertech.esper.core.service.StatementContext;
import com.espertech.esper.epl.expression.core.ExprConstantNode;
import com.espertech.esper.epl.expression.core.ExprContextPropertyNode;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprNodeUtility;
import com.espertech.esper.epl.expression.core.ExprOrderedExpr;
import com.espertech.esper.view.DataWindowViewFactory;
import com.espertech.esper.view.DataWindowViewWithPrevious;
import com.espertech.esper.view.View;
import com.espertech.esper.view.ViewFactory;
import com.espertech.esper.view.ViewFactoryContext;
import com.espertech.esper.view.ViewFactorySupport;
import com.espertech.esper.view.ViewParameterException;
import com.espertech.esper.view.ext.IStreamSortRankRandomAccess;
import com.espertech.esper.view.ext.RankWindowView;
import com.espertech.esper.view.ext.SortWindowView;
import com.espertech.esper.view.window.RandomAccessByIndexGetter;
import java.util.List;

public class RankWindowViewFactory
implements DataWindowViewFactory,
DataWindowViewWithPrevious {
    private static final String NAME = "Rank";
    private List<ExprNode> viewParameters;
    protected ExprNode[] uniqueCriteriaExpressions;
    protected ExprNode[] sortCriteriaExpressions;
    protected boolean[] isDescendingValues;
    protected ExprEvaluator[] uniqueEvals;
    protected ExprEvaluator[] sortEvals;
    protected ExprEvaluator sizeEvaluator;
    private EventType eventType;
    protected boolean useCollatorSort;

    @Override
    public void setViewParameters(ViewFactoryContext viewFactoryContext, List<ExprNode> viewParams) throws ViewParameterException {
        this.viewParameters = viewParams;
    }

    @Override
    public void attach(EventType parentEventType, StatementContext statementContext, ViewFactory optionalParentFactory, List<ViewFactory> parentViewFactories) throws ViewParameterException {
        int i;
        this.eventType = parentEventType;
        String message = "Rank view requires a list of expressions providing unique keys, a numeric size parameter and a list of expressions providing sort keys";
        if (this.viewParameters.size() < 3) {
            throw new ViewParameterException(message);
        }
        ExprNode[] validated = ViewFactorySupport.validate(NAME, parentEventType, statementContext, this.viewParameters, true);
        int indexNumericSize = -1;
        for (i = 0; i < validated.length; ++i) {
            if (!(validated[i] instanceof ExprConstantNode) && !(validated[i] instanceof ExprContextPropertyNode)) continue;
            indexNumericSize = i;
            break;
        }
        if (indexNumericSize == -1) {
            throw new ViewParameterException("Failed to find constant value for the numeric size parameter");
        }
        if (indexNumericSize == 0) {
            throw new ViewParameterException("Failed to find unique value expressions that are expected to occur before the numeric size parameter");
        }
        if (indexNumericSize == validated.length - 1) {
            throw new ViewParameterException("Failed to find sort key expressions after the numeric size parameter");
        }
        for (i = 0; i < indexNumericSize; ++i) {
            ViewFactorySupport.assertReturnsNonConstant(NAME, validated[i], i);
        }
        for (i = indexNumericSize + 1; i < validated.length; ++i) {
            ViewFactorySupport.assertReturnsNonConstant(NAME, validated[i], i);
        }
        ViewFactorySupport.validateNoProperties(this.getViewName(), validated[indexNumericSize], indexNumericSize);
        this.sizeEvaluator = ViewFactorySupport.validateSizeParam(this.getViewName(), statementContext, validated[indexNumericSize], indexNumericSize);
        this.uniqueCriteriaExpressions = new ExprNode[indexNumericSize];
        System.arraycopy(validated, 0, this.uniqueCriteriaExpressions, 0, indexNumericSize);
        this.sortCriteriaExpressions = new ExprNode[validated.length - indexNumericSize - 1];
        this.isDescendingValues = new boolean[this.sortCriteriaExpressions.length];
        int count = 0;
        for (int i2 = indexNumericSize + 1; i2 < validated.length; ++i2) {
            if (validated[i2] instanceof ExprOrderedExpr) {
                this.isDescendingValues[count] = ((ExprOrderedExpr)validated[i2]).isDescending();
                this.sortCriteriaExpressions[count] = validated[i2].getChildNodes()[0];
            } else {
                this.sortCriteriaExpressions[count] = validated[i2];
            }
            ++count;
        }
        this.uniqueEvals = ExprNodeUtility.getEvaluators(this.uniqueCriteriaExpressions);
        this.sortEvals = ExprNodeUtility.getEvaluators(this.sortCriteriaExpressions);
        if (statementContext.getConfigSnapshot() != null) {
            this.useCollatorSort = statementContext.getConfigSnapshot().getEngineDefaults().getLanguage().isSortUsingCollator();
        }
    }

    @Override
    public View makeView(AgentInstanceViewFactoryChainContext agentInstanceViewFactoryContext) {
        int sortWindowSize = ViewFactorySupport.evaluateSizeParam(this.getViewName(), this.sizeEvaluator, agentInstanceViewFactoryContext.getAgentInstanceContext());
        IStreamSortRankRandomAccess rankedRandomAccess = agentInstanceViewFactoryContext.getStatementContext().getViewServicePreviousFactory().getOptPreviousExprSortedRankedAccess(agentInstanceViewFactoryContext);
        return new RankWindowView(this, this.uniqueCriteriaExpressions, this.uniqueEvals, this.sortCriteriaExpressions, this.sortEvals, this.isDescendingValues, sortWindowSize, rankedRandomAccess, this.useCollatorSort, agentInstanceViewFactoryContext);
    }

    @Override
    public Object makePreviousGetter() {
        return new RandomAccessByIndexGetter();
    }

    @Override
    public EventType getEventType() {
        return this.eventType;
    }

    @Override
    public boolean canReuse(View view, AgentInstanceContext agentInstanceContext) {
        if (!(view instanceof SortWindowView)) {
            return false;
        }
        SortWindowView other = (SortWindowView)view;
        int sortWindowSize = ViewFactorySupport.evaluateSizeParam(this.getViewName(), this.sizeEvaluator, agentInstanceContext);
        if (other.getSortWindowSize() != sortWindowSize || !this.compare(other.getIsDescendingValues(), this.isDescendingValues) || !ExprNodeUtility.deepEquals(other.getSortCriteriaExpressions(), this.sortCriteriaExpressions, false)) {
            return false;
        }
        return other.isEmpty();
    }

    private boolean compare(boolean[] one, boolean[] two) {
        if (one.length != two.length) {
            return false;
        }
        for (int i = 0; i < one.length; ++i) {
            if (one[i] == two[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public String getViewName() {
        return NAME;
    }

    public boolean[] getIsDescendingValues() {
        return this.isDescendingValues;
    }

    public ExprEvaluator[] getUniqueEvals() {
        return this.uniqueEvals;
    }

    public ExprEvaluator[] getSortEvals() {
        return this.sortEvals;
    }

    public boolean isUseCollatorSort() {
        return this.useCollatorSort;
    }
}

