/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view.stat;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.SingleEventIterator;
import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.view.DerivedValueView;
import com.espertech.esper.view.ViewFactory;
import com.espertech.esper.view.ViewSupport;
import com.espertech.esper.view.stat.BaseStatisticsBean;
import com.espertech.esper.view.stat.StatViewAdditionalProps;
import java.util.Iterator;

public abstract class BaseBivariateStatisticsView
extends ViewSupport
implements DerivedValueView {
    private static final String NAME = "Statistics";
    protected final ViewFactory viewFactory;
    protected BaseStatisticsBean statisticsBean = new BaseStatisticsBean();
    private final ExprNode expressionX;
    private final ExprNode expressionY;
    private final ExprEvaluator expressionXEval;
    private final ExprEvaluator expressionYEval;
    private final EventBean[] eventsPerStream = new EventBean[1];
    protected final AgentInstanceContext agentInstanceContext;
    protected final StatViewAdditionalProps additionalProps;
    protected final EventType eventType;
    protected Object[] lastValuesEventNew;
    private EventBean lastNewEvent;

    protected abstract EventBean populateMap(BaseStatisticsBean var1, EventAdapterService var2, EventType var3, StatViewAdditionalProps var4, Object[] var5);

    public BaseBivariateStatisticsView(ViewFactory viewFactory, AgentInstanceContext agentInstanceContext, ExprNode expressionX, ExprNode expressionY, EventType eventType, StatViewAdditionalProps additionalProps) {
        this.viewFactory = viewFactory;
        this.agentInstanceContext = agentInstanceContext;
        this.expressionX = expressionX;
        this.expressionXEval = expressionX.getExprEvaluator();
        this.expressionY = expressionY;
        this.expressionYEval = expressionY.getExprEvaluator();
        this.eventType = eventType;
        this.additionalProps = additionalProps;
    }

    @Override
    public void update(EventBean[] newData, EventBean[] oldData) {
        double y;
        double x;
        Number ynum;
        Number xnum;
        int i;
        EventBean oldValues = null;
        if (this.lastNewEvent == null && this.hasViews()) {
            oldValues = this.populateMap(this.statisticsBean, this.agentInstanceContext.getStatementContext().getEventAdapterService(), this.eventType, this.additionalProps, this.lastValuesEventNew);
        }
        if (newData != null) {
            for (i = 0; i < newData.length; ++i) {
                this.eventsPerStream[0] = newData[i];
                xnum = (Number)this.expressionXEval.evaluate(this.eventsPerStream, true, this.agentInstanceContext);
                ynum = (Number)this.expressionYEval.evaluate(this.eventsPerStream, true, this.agentInstanceContext);
                if (xnum == null || ynum == null) continue;
                x = xnum.doubleValue();
                y = ynum.doubleValue();
                this.statisticsBean.addPoint(x, y);
            }
            if (this.additionalProps != null && newData.length != 0) {
                if (this.lastValuesEventNew == null) {
                    this.lastValuesEventNew = new Object[this.additionalProps.getAdditionalExpr().length];
                }
                for (int val = 0; val < this.additionalProps.getAdditionalExpr().length; ++val) {
                    this.lastValuesEventNew[val] = this.additionalProps.getAdditionalExpr()[val].evaluate(this.eventsPerStream, true, this.agentInstanceContext);
                }
            }
        }
        if (oldData != null) {
            for (i = 0; i < oldData.length; ++i) {
                this.eventsPerStream[0] = oldData[i];
                xnum = (Number)this.expressionXEval.evaluate(this.eventsPerStream, true, this.agentInstanceContext);
                ynum = (Number)this.expressionYEval.evaluate(this.eventsPerStream, true, this.agentInstanceContext);
                if (xnum == null || ynum == null) continue;
                x = xnum.doubleValue();
                y = ynum.doubleValue();
                this.statisticsBean.removePoint(x, y);
            }
        }
        if (this.hasViews()) {
            EventBean newDataMap = this.populateMap(this.statisticsBean, this.agentInstanceContext.getStatementContext().getEventAdapterService(), this.eventType, this.additionalProps, this.lastValuesEventNew);
            EventBean[] newEvents = new EventBean[]{newDataMap};
            EventBean[] oldEvents = this.lastNewEvent == null ? new EventBean[]{oldValues} : new EventBean[]{this.lastNewEvent};
            this.updateChildren(newEvents, oldEvents);
            this.lastNewEvent = newDataMap;
        }
    }

    @Override
    public final Iterator<EventBean> iterator() {
        return new SingleEventIterator(this.populateMap(this.statisticsBean, this.agentInstanceContext.getStatementContext().getEventAdapterService(), this.eventType, this.additionalProps, this.lastValuesEventNew));
    }

    public final ExprNode getExpressionX() {
        return this.expressionX;
    }

    public final ExprNode getExpressionY() {
        return this.expressionY;
    }

    public BaseStatisticsBean getStatisticsBean() {
        return this.statisticsBean;
    }

    public Object[] getLastValuesEventNew() {
        return this.lastValuesEventNew;
    }

    public void setLastValuesEventNew(Object[] lastValuesEventNew) {
        this.lastValuesEventNew = lastValuesEventNew;
    }

    public StatViewAdditionalProps getAdditionalProps() {
        return this.additionalProps;
    }

    @Override
    public ViewFactory getViewFactory() {
        return this.viewFactory;
    }
}

