/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view.stat;

import com.espertech.esper.client.EventType;
import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.core.context.util.AgentInstanceViewFactoryChainContext;
import com.espertech.esper.core.service.StatementContext;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprNodeUtility;
import com.espertech.esper.util.JavaClassHelper;
import com.espertech.esper.view.View;
import com.espertech.esper.view.ViewFactory;
import com.espertech.esper.view.ViewFactoryContext;
import com.espertech.esper.view.ViewFactorySupport;
import com.espertech.esper.view.ViewParameterException;
import com.espertech.esper.view.stat.StatViewAdditionalProps;
import com.espertech.esper.view.stat.UnivariateStatisticsView;
import java.util.List;

public class UnivariateStatisticsViewFactory
implements ViewFactory {
    protected static final String NAME = "Univariate statistics";
    private List<ExprNode> viewParameters;
    private int streamNumber;
    protected ExprNode fieldExpression;
    protected StatViewAdditionalProps additionalProps;
    protected EventType eventType;

    @Override
    public void setViewParameters(ViewFactoryContext viewFactoryContext, List<ExprNode> expressionParameters) throws ViewParameterException {
        this.viewParameters = expressionParameters;
        this.streamNumber = viewFactoryContext.getStreamNum();
    }

    @Override
    public void attach(EventType parentEventType, StatementContext statementContext, ViewFactory optionalParentFactory, List<ViewFactory> parentViewFactories) throws ViewParameterException {
        ExprNode[] validated = ViewFactorySupport.validate(this.getViewName(), parentEventType, statementContext, this.viewParameters, true);
        if (validated.length < 1) {
            throw new ViewParameterException(this.getViewParamMessage());
        }
        if (!JavaClassHelper.isNumeric(validated[0].getExprEvaluator().getType())) {
            throw new ViewParameterException(this.getViewParamMessage());
        }
        this.fieldExpression = validated[0];
        this.additionalProps = StatViewAdditionalProps.make(validated, 1, parentEventType);
        this.eventType = UnivariateStatisticsView.createEventType(statementContext, this.additionalProps, this.streamNumber);
    }

    @Override
    public View makeView(AgentInstanceViewFactoryChainContext agentInstanceViewFactoryContext) {
        return new UnivariateStatisticsView(this, agentInstanceViewFactoryContext);
    }

    @Override
    public EventType getEventType() {
        return this.eventType;
    }

    @Override
    public boolean canReuse(View view, AgentInstanceContext agentInstanceContext) {
        if (!(view instanceof UnivariateStatisticsView)) {
            return false;
        }
        if (this.additionalProps != null) {
            return false;
        }
        UnivariateStatisticsView other = (UnivariateStatisticsView)view;
        return ExprNodeUtility.deepEquals(other.getFieldExpression(), this.fieldExpression, false);
    }

    @Override
    public String getViewName() {
        return NAME;
    }

    private String getViewParamMessage() {
        return this.getViewName() + " view require a single expression returning a numeric value as a parameter";
    }

    public void setFieldExpression(ExprNode fieldExpression) {
        this.fieldExpression = fieldExpression;
    }

    public void setAdditionalProps(StatViewAdditionalProps additionalProps) {
        this.additionalProps = additionalProps;
    }

    public StatViewAdditionalProps getAdditionalProps() {
        return this.additionalProps;
    }

    public void setEventType(EventType eventType) {
        this.eventType = eventType;
    }
}

