/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view.window;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.collection.OneEventCollection;
import com.espertech.esper.collection.ViewUpdatedCollection;
import com.espertech.esper.core.context.util.AgentInstanceViewFactoryChainContext;
import com.espertech.esper.epl.agg.service.AggregationServiceAggExpressionDesc;
import com.espertech.esper.epl.agg.service.AggregationServiceFactoryDesc;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.event.arr.ObjectArrayEventBean;
import com.espertech.esper.view.View;
import com.espertech.esper.view.ViewDataVisitor;
import com.espertech.esper.view.ViewFactory;
import com.espertech.esper.view.window.ExpressionViewBase;
import com.espertech.esper.view.window.ExpressionViewOAFieldEnum;
import com.espertech.esper.view.window.ExpressionWindowTimestampEventPair;
import com.espertech.esper.view.window.ExpressionWindowTimestampEventPairIterator;
import com.espertech.esper.view.window.ExpressionWindowViewFactory;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.Set;

public class ExpressionWindowView
extends ExpressionViewBase {
    private final ExpressionWindowViewFactory dataWindowViewFactory;
    protected final ArrayDeque<ExpressionWindowTimestampEventPair> window = new ArrayDeque();
    private final EventBean[] removedEvents = new EventBean[1];

    public ExpressionWindowView(ExpressionWindowViewFactory dataWindowViewFactory, ViewUpdatedCollection viewUpdatedCollection, ExprEvaluator expiryExpression, AggregationServiceFactoryDesc aggregationServiceFactoryDesc, ObjectArrayEventBean builtinEventProps, Set<String> variableNames, AgentInstanceViewFactoryChainContext agentInstanceContext) {
        super(viewUpdatedCollection, expiryExpression, aggregationServiceFactoryDesc, builtinEventProps, variableNames, agentInstanceContext);
        this.dataWindowViewFactory = dataWindowViewFactory;
    }

    @Override
    public String getViewName() {
        return this.dataWindowViewFactory.getViewName();
    }

    @Override
    public View cloneView() {
        return this.dataWindowViewFactory.makeView(this.agentInstanceContext);
    }

    public boolean isEmpty() {
        return this.window.isEmpty();
    }

    @Override
    public void scheduleCallback() {
        this.expire(null, null);
    }

    @Override
    public final void update(EventBean[] newData, EventBean[] oldData) {
        if (newData != null) {
            for (EventBean newEvent : newData) {
                ExpressionWindowTimestampEventPair pair = new ExpressionWindowTimestampEventPair(this.agentInstanceContext.getTimeProvider().getTime(), newEvent);
                this.window.add(pair);
                this.internalHandleAdd(pair);
            }
            if (this.aggregationService != null) {
                this.aggregationService.applyEnter(newData, null, this.agentInstanceContext);
            }
        }
        if (oldData != null) {
            Iterator<ExpressionWindowTimestampEventPair> it = this.window.iterator();
            while (it.hasNext()) {
                ExpressionWindowTimestampEventPair pair = it.next();
                for (EventBean anOldData : oldData) {
                    if (pair.getTheEvent() != anOldData) continue;
                    it.remove();
                    break;
                }
                this.internalHandleRemoved(pair);
            }
            if (this.aggregationService != null) {
                this.aggregationService.applyLeave(oldData, null, this.agentInstanceContext);
            }
        }
        this.expire(newData, oldData);
    }

    public void internalHandleRemoved(ExpressionWindowTimestampEventPair pair) {
    }

    public void internalHandleExpired(ExpressionWindowTimestampEventPair pair) {
    }

    public void internalHandleAdd(ExpressionWindowTimestampEventPair pair) {
    }

    private void expire(EventBean[] newData, EventBean[] oldData) {
        OneEventCollection expired = null;
        if (oldData != null) {
            expired = new OneEventCollection();
            expired.add(oldData);
        }
        int expiredCount = 0;
        if (!this.window.isEmpty()) {
            ExpressionWindowTimestampEventPair first;
            boolean pass;
            ExpressionWindowTimestampEventPair newest = this.window.getLast();
            while (!(pass = this.checkEvent(first = this.window.getFirst(), newest, expiredCount))) {
                if (expired == null) {
                    expired = new OneEventCollection();
                }
                EventBean removed = this.window.removeFirst().getTheEvent();
                expired.add(removed);
                if (this.aggregationService != null) {
                    this.removedEvents[0] = removed;
                    this.aggregationService.applyLeave(this.removedEvents, null, this.agentInstanceContext);
                }
                ++expiredCount;
                this.internalHandleExpired(first);
                if (!this.window.isEmpty()) continue;
                if (this.aggregationService == null) break;
                this.aggregationService.clearResults(this.agentInstanceContext);
                break;
            }
        }
        EventBean[] expiredArr = null;
        if (expired != null) {
            expiredArr = expired.toArray();
        }
        if (this.viewUpdatedCollection != null) {
            this.viewUpdatedCollection.update(newData, expiredArr);
        }
        if (this.hasViews()) {
            this.updateChildren(newData, expiredArr);
        }
    }

    private boolean checkEvent(ExpressionWindowTimestampEventPair first, ExpressionWindowTimestampEventPair newest, int numExpired) {
        ExpressionViewOAFieldEnum.populate(this.builtinEventProps.getProperties(), this.window.size(), first.getTimestamp(), newest.getTimestamp(), this, numExpired, first.getTheEvent(), newest.getTheEvent());
        this.eventsPerStream[0] = first.getTheEvent();
        for (AggregationServiceAggExpressionDesc aggregateNode : this.aggregateNodes) {
            aggregateNode.assignFuture(this.aggregationService);
        }
        Boolean result = (Boolean)this.expiryExpression.evaluate(this.eventsPerStream, true, this.agentInstanceContext);
        if (result == null) {
            return false;
        }
        return result;
    }

    @Override
    public final Iterator<EventBean> iterator() {
        return new ExpressionWindowTimestampEventPairIterator(this.window.iterator());
    }

    @Override
    public void update(Object newValue, Object oldValue) {
        if (!this.agentInstanceContext.getStatementContext().getSchedulingService().isScheduled(this.scheduleHandle)) {
            this.agentInstanceContext.getStatementContext().getSchedulingService().add(0L, this.scheduleHandle, this.scheduleSlot);
        }
    }

    public ArrayDeque<ExpressionWindowTimestampEventPair> getWindow() {
        return this.window;
    }

    @Override
    public void visitView(ViewDataVisitor viewDataVisitor) {
        viewDataVisitor.visitPrimary(this.window, true, this.dataWindowViewFactory.getViewName(), null);
    }

    @Override
    public ViewFactory getViewFactory() {
        return this.dataWindowViewFactory;
    }
}

