/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view.window;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.ViewUpdatedCollection;
import com.espertech.esper.core.context.util.AgentInstanceViewFactoryChainContext;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.time.ExprTimePeriodEvalDeltaConst;
import com.espertech.esper.epl.expression.time.ExprTimePeriodEvalDeltaResult;
import com.espertech.esper.event.EventBeanUtility;
import com.espertech.esper.view.CloneableView;
import com.espertech.esper.view.DataWindowView;
import com.espertech.esper.view.View;
import com.espertech.esper.view.ViewDataVisitor;
import com.espertech.esper.view.ViewFactory;
import com.espertech.esper.view.ViewSupport;
import com.espertech.esper.view.window.ExternallyTimedBatchViewFactory;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;

public class ExternallyTimedBatchView
extends ViewSupport
implements DataWindowView,
CloneableView {
    private final ExternallyTimedBatchViewFactory factory;
    private final ExprNode timestampExpression;
    private final ExprEvaluator timestampExpressionEval;
    private final ExprTimePeriodEvalDeltaConst timeDeltaComputation;
    private final EventBean[] eventsPerStream = new EventBean[1];
    protected EventBean[] lastBatch;
    private Long oldestTimestamp;
    protected final Set<EventBean> window = new LinkedHashSet<EventBean>();
    protected Long referenceTimestamp;
    protected ViewUpdatedCollection viewUpdatedCollection;
    protected AgentInstanceViewFactoryChainContext agentInstanceViewFactoryContext;

    public ExternallyTimedBatchView(ExternallyTimedBatchViewFactory factory, ExprNode timestampExpression, ExprEvaluator timestampExpressionEval, ExprTimePeriodEvalDeltaConst timeDeltaComputation, Long optionalReferencePoint, ViewUpdatedCollection viewUpdatedCollection, AgentInstanceViewFactoryChainContext agentInstanceViewFactoryContext) {
        this.factory = factory;
        this.timestampExpression = timestampExpression;
        this.timestampExpressionEval = timestampExpressionEval;
        this.timeDeltaComputation = timeDeltaComputation;
        this.viewUpdatedCollection = viewUpdatedCollection;
        this.agentInstanceViewFactoryContext = agentInstanceViewFactoryContext;
        this.referenceTimestamp = optionalReferencePoint;
    }

    @Override
    public View cloneView() {
        return this.factory.makeView(this.agentInstanceViewFactoryContext);
    }

    public final ExprNode getTimestampExpression() {
        return this.timestampExpression;
    }

    @Override
    public final EventType getEventType() {
        return this.parent.getEventType();
    }

    @Override
    public final void update(EventBean[] newData, EventBean[] oldData) {
        if (oldData != null && oldData.length != 0) {
            for (EventBean anOldData : oldData) {
                this.window.remove(anOldData);
                this.handleInternalRemovedEvent(anOldData);
            }
            this.determineOldestTimestamp();
        }
        EventBean[] batchNewData = null;
        if (newData != null) {
            for (EventBean newEvent : newData) {
                long timestamp = this.getLongValue(newEvent);
                if (this.referenceTimestamp == null) {
                    this.referenceTimestamp = timestamp;
                }
                if (this.oldestTimestamp == null) {
                    this.oldestTimestamp = timestamp;
                } else {
                    ExprTimePeriodEvalDeltaResult delta = this.timeDeltaComputation.deltaAddWReference(this.oldestTimestamp, this.referenceTimestamp);
                    this.referenceTimestamp = delta.getLastReference();
                    if (timestamp - this.oldestTimestamp >= delta.getDelta()) {
                        batchNewData = batchNewData == null ? this.window.toArray(new EventBean[this.window.size()]) : EventBeanUtility.addToArray(batchNewData, this.window);
                        this.window.clear();
                        this.oldestTimestamp = null;
                    }
                }
                this.window.add(newEvent);
                this.handleInternalAddEvent(newEvent, batchNewData != null);
            }
        }
        if (batchNewData != null) {
            this.handleInternalPostBatch(this.window, batchNewData);
            if (this.viewUpdatedCollection != null) {
                this.viewUpdatedCollection.update(batchNewData, this.lastBatch);
            }
            this.updateChildren(batchNewData, this.lastBatch);
            this.lastBatch = batchNewData;
            this.determineOldestTimestamp();
        }
        if (oldData != null && oldData.length > 0) {
            if (this.viewUpdatedCollection != null) {
                this.viewUpdatedCollection.update(null, oldData);
            }
            this.updateChildren(null, oldData);
        }
    }

    @Override
    public final Iterator<EventBean> iterator() {
        return this.window.iterator();
    }

    public final String toString() {
        return this.getClass().getName() + " timestampExpression=" + this.timestampExpression;
    }

    public boolean isEmpty() {
        return this.window.isEmpty();
    }

    public ExprTimePeriodEvalDeltaConst getTimeDeltaComputation() {
        return this.timeDeltaComputation;
    }

    @Override
    public void visitView(ViewDataVisitor viewDataVisitor) {
        viewDataVisitor.visitPrimary(this.window, true, this.factory.getViewName(), null);
    }

    @Override
    public ViewFactory getViewFactory() {
        return this.factory;
    }

    protected void determineOldestTimestamp() {
        this.oldestTimestamp = this.window.isEmpty() ? null : Long.valueOf(this.getLongValue(this.window.iterator().next()));
    }

    protected void handleInternalPostBatch(Set<EventBean> window, EventBean[] batchNewData) {
    }

    protected void handleInternalRemovedEvent(EventBean anOldData) {
    }

    protected void handleInternalAddEvent(EventBean anNewData, boolean isNextBatch) {
    }

    private long getLongValue(EventBean obj) {
        this.eventsPerStream[0] = obj;
        Number num = (Number)this.timestampExpressionEval.evaluate(this.eventsPerStream, true, this.agentInstanceViewFactoryContext);
        return num.longValue();
    }
}

