/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esperio.kafka;

import com.espertech.esper.client.EPServiceProvider;
import com.espertech.esper.client.time.CurrentTimeSpanEvent;
import com.espertech.esper.util.JavaClassHelper;
import com.espertech.esperio.kafka.EsperIOKafkaInputProcessor;
import com.espertech.esperio.kafka.EsperIOKafkaInputProcessorContext;
import com.espertech.esperio.kafka.EsperIOKafkaInputTimestampExtractor;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EsperIOKafkaInputProcessorDefault
implements EsperIOKafkaInputProcessor {
    private static Logger log = LoggerFactory.getLogger(EsperIOKafkaInputProcessorDefault.class);
    private EPServiceProvider engine;
    private EsperIOKafkaInputTimestampExtractor timestampExtractor;

    public void init(EsperIOKafkaInputProcessorContext context) {
        this.engine = context.getEngine();
        String timestampExtractorClassName = context.getProperties().getProperty("esperio.kafka.input.timestampextractor");
        if (timestampExtractorClassName != null) {
            this.timestampExtractor = (EsperIOKafkaInputTimestampExtractor)JavaClassHelper.instantiate(EsperIOKafkaInputTimestampExtractor.class, timestampExtractorClassName, context.getEngine().getEngineImportService().getClassForNameProvider());
        }
    }

    public void process(ConsumerRecords<Object, Object> records) {
        for (ConsumerRecord record : records) {
            if (this.timestampExtractor != null) {
                long timestamp = this.timestampExtractor.extract(record);
                if (log.isDebugEnabled()) {
                    log.debug("Sending time span {}", (Object)timestamp);
                }
                this.engine.getEPRuntime().sendEvent(new CurrentTimeSpanEvent(timestamp));
            }
            if (record.value() == null) continue;
            if (log.isDebugEnabled()) {
                log.debug("Sending event {}", (Object)record.value().toString());
            }
            this.engine.getEPRuntime().sendEvent(record.value());
        }
    }

    public void close() {
    }
}

