/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esperio.kafka;

import com.espertech.esper.client.Configuration;
import com.espertech.esper.client.EPServiceProvider;
import com.espertech.esper.client.EPServiceProviderManager;
import com.espertech.esperio.kafka.EsperIOKafkaInputAdapterPlugin;
import com.espertech.esperio.kafka.EsperIOKafkaInputProcessorDefault;
import com.espertech.esperio.kafka.EsperIOKafkaInputSubscriberByTopicList;
import com.espertech.esperio.kafka.EsperIOKafkaOutputAdapterPlugin;
import com.espertech.esperio.kafka.KafkaOutputDefault;
import java.util.Properties;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.StringSerializer;

public class SupportConstants {
    public static final String DEV_BOOTSTRAP_SERVER = "127.0.0.1:9092";
    public static final String DEV_INPUT_TOPIC_SUPPORTBEAN_STRING = "esperio_regression_input_t1";
    public static final String DEV_INPUT_TOPIC_SUPPORTBEAN_JAVASERIALIZED = "esperio_regression_input_t2";
    public static final String DEV_INPUT_TOPIC_BYTES = "esperio_regression_input_t3";
    public static final String DEV_OUTPUT_TOPIC_JSON = "esperio_regression_output_t1";

    public static Properties getInputPluginProps(String topicName, String valueDeserializerClassName, String timestampExtractorClassName) {
        Properties props = new Properties();
        props.put("bootstrap.servers", DEV_BOOTSTRAP_SERVER);
        props.put("key.deserializer", StringDeserializer.class.getName());
        props.put("value.deserializer", valueDeserializerClassName);
        props.put("group.id", topicName + "__mygroup");
        props.put("esperio.kafka.input.subscriber", EsperIOKafkaInputSubscriberByTopicList.class.getName());
        props.put("esperio.kafka.topics", topicName);
        props.put("esperio.kafka.input.processor", EsperIOKafkaInputProcessorDefault.class.getName());
        if (timestampExtractorClassName != null) {
            props.put("esperio.kafka.input.timestampextractor", timestampExtractorClassName);
        }
        return props;
    }

    public static Properties getOutputPluginProps() {
        Properties props = new Properties();
        props.put("bootstrap.servers", DEV_BOOTSTRAP_SERVER);
        return props;
    }

    public static EPServiceProvider getEngineWKafkaInput(String uri, Properties pluginProperties) {
        Configuration engineConfig = new Configuration();
        engineConfig.getEngineDefaults().getThreading().setInternalTimerEnabled(false);
        engineConfig.addPluginLoader(EsperIOKafkaInputAdapterPlugin.class.getSimpleName(), EsperIOKafkaInputAdapterPlugin.class.getName(), pluginProperties, null);
        return EPServiceProviderManager.getProvider(uri, engineConfig);
    }

    public static EPServiceProvider getEngineWKafkaOutput(String uri, Properties pluginProperties) {
        Configuration engineConfig = new Configuration();
        engineConfig.addImport(KafkaOutputDefault.class);
        engineConfig.getEngineDefaults().getThreading().setInternalTimerEnabled(false);
        engineConfig.addPluginLoader(EsperIOKafkaOutputAdapterPlugin.class.getSimpleName(), EsperIOKafkaOutputAdapterPlugin.class.getName(), pluginProperties, null);
        return EPServiceProviderManager.getProvider(uri, engineConfig);
    }

    public static Properties getProducerProps(String valueSerializerClassName) {
        Properties props = new Properties();
        props.put("bootstrap.servers", DEV_BOOTSTRAP_SERVER);
        props.put("key.serializer", StringSerializer.class.getName());
        props.put("value.serializer", valueSerializerClassName);
        return props;
    }
}

