/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.client.dataflow.io;

import com.espertech.esper.client.dataflow.io.DataInputToObjectCollector;
import com.espertech.esper.client.dataflow.io.DataInputToObjectCollectorContext;
import com.espertech.esper.util.EventBeanSummarizer;
import com.espertech.esper.util.SerializerUtil;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataInputToObjectCollectorSerializable
implements DataInputToObjectCollector {
    private static final Logger log = LoggerFactory.getLogger(DataInputToObjectCollectorSerializable.class);

    @Override
    public void collect(DataInputToObjectCollectorContext context) throws IOException {
        int size = context.getDataInput().readInt();
        byte[] bytes = new byte[size];
        context.getDataInput().readFully(bytes);
        Object event = SerializerUtil.byteArrToObject(bytes);
        if (log.isDebugEnabled()) {
            log.debug("Submitting event " + EventBeanSummarizer.summarizeUnderlying(event));
        }
        context.getEmitter().submit(event);
    }
}

