/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.client.soda;

import com.espertech.esper.client.soda.DataFlowOperatorParameter;
import com.espertech.esper.client.soda.ExpressionBase;
import com.espertech.esper.client.soda.ExpressionPrecedenceEnum;
import com.espertech.esper.util.StringValue;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.Map;

public class ConstantExpression
extends ExpressionBase {
    private Object constant;
    private String constantType;
    private static final long serialVersionUID = 1787950621647511049L;

    public ConstantExpression() {
    }

    public String getConstantType() {
        return this.constantType;
    }

    public void setConstantType(String constantType) {
        this.constantType = constantType;
    }

    public ConstantExpression(Object constant) {
        this.constant = constant;
    }

    public ConstantExpression(Object constant, String constantType) {
        this.constant = constant;
        this.constantType = constantType;
    }

    @Override
    public ExpressionPrecedenceEnum getPrecedence() {
        return ExpressionPrecedenceEnum.UNARY;
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer) {
        if (this.constant instanceof Iterable) {
            Iterable iterable = (Iterable)this.constant;
            Iterator iterator = iterable.iterator();
            writer.append("[");
            String delimiter = "";
            while (iterator.hasNext()) {
                Object next = iterator.next();
                writer.append(delimiter);
                DataFlowOperatorParameter.renderValue(writer, next);
                delimiter = ",";
            }
            writer.append("]");
        } else if (this.constant instanceof Map) {
            Map map = (Map)this.constant;
            writer.append("{");
            String delimiter = "";
            for (Map.Entry entry : map.entrySet()) {
                writer.append(delimiter);
                writer.append((CharSequence)entry.getKey());
                writer.append(": ");
                DataFlowOperatorParameter.renderValue(writer, entry.getValue());
                delimiter = ",";
            }
            writer.append("}");
        } else {
            StringValue.renderConstantAsEPL(writer, this.constant);
        }
    }

    public Object getConstant() {
        return this.constant;
    }

    public void setConstant(Object constant) {
        this.constant = constant;
    }
}

