/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.client.soda;

import com.espertech.esper.client.soda.EPStatementFormatter;
import com.espertech.esper.client.soda.Expression;
import com.espertech.esper.client.soda.Stream;
import com.espertech.esper.client.soda.View;
import java.io.StringWriter;
import java.util.List;

public abstract class ProjectedStream
extends Stream {
    private static final long serialVersionUID = -8999968913067920696L;
    private List<View> views;
    private boolean unidirectional;
    private boolean retainUnion;
    private boolean retainIntersection;

    public ProjectedStream() {
    }

    public abstract void toEPLProjectedStream(StringWriter var1, EPStatementFormatter var2);

    public abstract void toEPLProjectedStreamType(StringWriter var1);

    protected ProjectedStream(List<View> views, String optStreamName) {
        super(optStreamName);
        this.views = views;
    }

    public ProjectedStream addView(String namespace, String name) {
        this.views.add(View.create(namespace, name));
        return this;
    }

    public ProjectedStream addView(String namespace, String name, List<Expression> parameters) {
        this.views.add(View.create(namespace, name, parameters));
        return this;
    }

    public ProjectedStream addView(String namespace, String name, Expression ... parameters) {
        this.views.add(View.create(namespace, name, parameters));
        return this;
    }

    public ProjectedStream addView(String name, Expression ... parameters) {
        this.views.add(View.create(null, name, parameters));
        return this;
    }

    public ProjectedStream addView(View view) {
        this.views.add(view);
        return this;
    }

    public List<View> getViews() {
        return this.views;
    }

    public void setViews(List<View> views) {
        this.views = views;
    }

    @Override
    public void toEPLStream(StringWriter writer, EPStatementFormatter formatter) {
        this.toEPLProjectedStream(writer, formatter);
        ProjectedStream.toEPLViews(writer, this.views);
    }

    @Override
    public void toEPLStreamType(StringWriter writer) {
        this.toEPLProjectedStreamType(writer);
        if (this.views != null && this.views.size() != 0) {
            writer.write(46);
            String delimiter = "";
            for (View view : this.views) {
                writer.write(delimiter);
                writer.append(view.getNamespace()).append(".").append(view.getName()).append("()");
                delimiter = ".";
            }
        }
    }

    public boolean isUnidirectional() {
        return this.unidirectional;
    }

    public void setUnidirectional(boolean isUnidirectional) {
        this.unidirectional = isUnidirectional;
    }

    public ProjectedStream unidirectional(boolean isUnidirectional) {
        this.unidirectional = isUnidirectional;
        return this;
    }

    public boolean isRetainUnion() {
        return this.retainUnion;
    }

    public void setRetainUnion(boolean retainUnion) {
        this.retainUnion = retainUnion;
    }

    public boolean isRetainIntersection() {
        return this.retainIntersection;
    }

    public void setRetainIntersection(boolean retainIntersection) {
        this.retainIntersection = retainIntersection;
    }

    protected static void toEPLViews(StringWriter writer, List<View> views) {
        block4: {
            if (views == null || views.size() == 0) break block4;
            if (views.iterator().next().getNamespace() == null) {
                writer.write(35);
                String delimiter = "";
                for (View view : views) {
                    writer.write(delimiter);
                    view.toEPLWithHash(writer);
                    delimiter = "#";
                }
            } else {
                writer.write(46);
                String delimiter = "";
                for (View view : views) {
                    writer.write(delimiter);
                    view.toEPL(writer);
                    delimiter = ".";
                }
            }
        }
    }

    @Override
    public void toEPLStreamOptions(StringWriter writer) {
        if (this.unidirectional) {
            writer.write(" unidirectional");
        } else if (this.retainUnion) {
            writer.write(" retain-union");
        } else if (this.retainIntersection) {
            writer.write(" retain-intersection");
        }
    }
}

