/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.client.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateTime {
    public static final String DEFAULT_XMLLIKE_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS";
    public static final String DEFAULT_XMLLIKE_DATE_FORMAT_WITH_ZONE = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    private static final Logger log = LoggerFactory.getLogger(DateTime.class);

    public static Calendar toCalendar(String datestring) {
        return DateTime.parseGetCal(datestring, new SimpleDateFormat());
    }

    public static Calendar toCalendar(String datestring, String format) {
        Date d = DateTime.parse(datestring, format);
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(d.getTime());
        return cal;
    }

    public static Date toDate(String datestring) {
        return DateTime.parse(datestring);
    }

    public static Date toDate(String datestring, String format) {
        return DateTime.parse(datestring, format);
    }

    public static Long toMillisec(String datestring) {
        Date date = DateTime.parse(datestring);
        if (date == null) {
            return null;
        }
        return date.getTime();
    }

    public static Long toMillisec(String datestring, String format) {
        Date date = DateTime.parse(datestring, format);
        if (date == null) {
            return null;
        }
        return date.getTime();
    }

    public static String print(Object date) {
        return DateTime.print(date, new SimpleDateFormat(DEFAULT_XMLLIKE_DATE_FORMAT));
    }

    public static String printWithZone(Object date) {
        return DateTime.print(date, new SimpleDateFormat(DEFAULT_XMLLIKE_DATE_FORMAT_WITH_ZONE));
    }

    private static String print(Object date, SimpleDateFormat sdf) {
        if (date instanceof Long) {
            return sdf.format(new Date((Long)date));
        }
        if (date instanceof Date) {
            return sdf.format((Date)date);
        }
        if (date instanceof Calendar) {
            return sdf.format(((Calendar)date).getTime());
        }
        throw new IllegalArgumentException("Date format for type '" + date.getClass() + "' not possible");
    }

    public static long parseDefaultMSec(String dateTime) {
        return DateTime.parse(dateTime, new SimpleDateFormat(DEFAULT_XMLLIKE_DATE_FORMAT)).getTime();
    }

    public static LocalDateTime parseDefaultLocalDateTime(String dateTime) {
        return LocalDateTime.parse(dateTime, DateTimeFormatter.ofPattern(DEFAULT_XMLLIKE_DATE_FORMAT));
    }

    public static ZonedDateTime parseDefaultZonedDateTime(String dateTime) {
        return DateTime.parseDefaultLocalDateTime(dateTime).atZone(ZoneId.systemDefault());
    }

    public static long parseDefaultMSecWZone(String dateTimeWithZone) {
        return DateTime.parse(dateTimeWithZone, new SimpleDateFormat(DEFAULT_XMLLIKE_DATE_FORMAT_WITH_ZONE)).getTime();
    }

    public static Date parseDefaultDate(String dateTime) {
        return DateTime.parse(dateTime, new SimpleDateFormat(DEFAULT_XMLLIKE_DATE_FORMAT));
    }

    public static Calendar parseDefaultCal(String dateTime) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(DateTime.parseDefaultMSec(dateTime));
        return cal;
    }

    private static Date parse(String str) {
        return DateTime.parse(str, new SimpleDateFormat());
    }

    private static Date parse(String str, String format) {
        SimpleDateFormat sdf;
        try {
            sdf = new SimpleDateFormat(format);
        }
        catch (Exception ex) {
            log.warn("Error in date format '" + str + "': " + ex.getMessage(), (Throwable)ex);
            return null;
        }
        return DateTime.parse(str, sdf);
    }

    private static Date parse(String str, SimpleDateFormat format) {
        Date d;
        try {
            d = format.parse(str);
        }
        catch (ParseException e) {
            log.warn("Error parsing date '" + str + "' according to format '" + format.toPattern() + "': " + e.getMessage(), (Throwable)e);
            return null;
        }
        return d;
    }

    private static Calendar parseGetCal(String str, SimpleDateFormat format) {
        Date d = DateTime.parse(str, format);
        if (d == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(d.getTime());
        return cal;
    }
}

