/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.codegen.compile;

import com.espertech.esper.client.ConfigurationException;
import com.espertech.esper.client.EPException;
import com.espertech.esper.codegen.compile.CodeGenerationUtil;
import com.espertech.esper.codegen.compile.CodegenCompiler;
import com.espertech.esper.codegen.compile.CodegenCompilerException;
import com.espertech.esper.codegen.util.IdentifierUtil;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodegenCompilerJanino
implements CodegenCompiler {
    private static final Logger log = LoggerFactory.getLogger(CodegenCompilerJanino.class);
    private final boolean logging;
    private final boolean includeDebugSymbols;
    private final String packageName;
    private Constructor janinoCompilerCtor;
    private Method janinoCompilerCookMethod;
    private Method janinoCompilerGetClassLoaderMethod;
    private Method janinoCompilerSetDebuggingInformationMethod;
    private Method janinoCompilerSetParentClassLoaderMethod;

    public CodegenCompilerJanino(String engineURI, boolean logging, boolean includeDebugSymbols) {
        this.logging = logging;
        this.includeDebugSymbols = includeDebugSymbols;
        this.setupJanino();
        this.packageName = "com.espertech.esper.generated.uri_" + IdentifierUtil.getIdentifierMayStartNumeric(engineURI);
    }

    @Override
    public String getPackageName() {
        return this.packageName;
    }

    @Override
    public <T> Class<T> compileClass(String code, String fullyQualifiedClassName, ClassLoader classLoader, Supplier<String> debugInformation) throws CodegenCompilerException {
        ClassLoader classLoaderForLoading;
        Object compiler;
        if (log.isDebugEnabled() || this.logging) {
            String origin = debugInformation.get();
            StringWriter writer = new StringWriter();
            PrintWriter printer = new PrintWriter(writer);
            printer.append("Compiling class for ").append(origin).append(" includeDebugSymbols=").append(Boolean.toString(this.includeDebugSymbols)).append(" classloader=").append(classLoader.toString()).append(" code: ");
            printer.println();
            printer.append(CodeGenerationUtil.codeWithLineNum(code));
            String text = writer.toString();
            if (log.isDebugEnabled()) {
                log.debug(text);
            } else if (this.logging) {
                log.info(text);
            }
        }
        try {
            compiler = this.janinoCompilerCtor.newInstance(new Object[0]);
        }
        catch (Exception ex) {
            throw new EPException("Failed to instantiate Janino scanner: " + ex.getMessage(), ex);
        }
        try {
            this.janinoCompilerSetParentClassLoaderMethod.invoke(compiler, classLoader);
        }
        catch (Exception ex) {
            throw new EPException("Failed to invoke Janino getClassLoader: " + ex.getMessage(), ex);
        }
        if (this.includeDebugSymbols) {
            try {
                this.janinoCompilerSetDebuggingInformationMethod.invoke(compiler, true, true, true);
            }
            catch (Exception ex) {
                throw new EPException("Failed to invoke Janino getClassLoader: " + ex.getMessage(), ex);
            }
        }
        try {
            this.janinoCompilerCookMethod.invoke(compiler, new StringReader(code));
        }
        catch (InvocationTargetException ite) {
            throw new CodegenCompilerException("Failed to compile generated code", ite.getTargetException(), code);
        }
        catch (Exception ex) {
            throw new EPException("Failed to invoke Janino compile method: " + ex.getMessage(), ex);
        }
        try {
            classLoaderForLoading = (ClassLoader)this.janinoCompilerGetClassLoaderMethod.invoke(compiler, new Object[0]);
        }
        catch (Exception ex) {
            throw new EPException("Failed to invoke Janino getClassLoader: " + ex.getMessage(), ex);
        }
        try {
            return Class.forName(fullyQualifiedClassName, true, classLoaderForLoading);
        }
        catch (ClassNotFoundException ex) {
            throw new EPException("Failed find compiled class: " + ex.getMessage(), ex);
        }
    }

    private void setupJanino() throws ConfigurationException {
        Class<?> janinoCompilerClass;
        String classnameCompiler = "org.codehaus.janino.SimpleCompiler";
        try {
            janinoCompilerClass = Class.forName("org.codehaus.janino.SimpleCompiler");
        }
        catch (Exception ex) {
            throw new ConfigurationException("Failed to load Janino compiler class '" + classnameCompiler + "': " + ex.getMessage(), ex);
        }
        try {
            this.janinoCompilerCtor = janinoCompilerClass.getConstructor(new Class[0]);
        }
        catch (Exception ex) {
            throw new ConfigurationException("Failed to find Janino compiler constructor taking no parameters: " + ex.getMessage(), ex);
        }
        try {
            this.janinoCompilerCookMethod = janinoCompilerClass.getMethod("cook", Reader.class);
        }
        catch (Exception ex) {
            throw new ConfigurationException("Failed to find Janino compiler cook method taking StringReader as parameter: " + ex.getMessage(), ex);
        }
        try {
            this.janinoCompilerGetClassLoaderMethod = janinoCompilerClass.getMethod("getClassLoader", new Class[0]);
        }
        catch (Exception ex) {
            throw new ConfigurationException("Failed to find Janino compiler 'getClassLoader' method: " + ex.getMessage(), ex);
        }
        try {
            this.janinoCompilerSetDebuggingInformationMethod = janinoCompilerClass.getMethod("setDebuggingInformation", Boolean.TYPE, Boolean.TYPE, Boolean.TYPE);
        }
        catch (Exception ex) {
            throw new ConfigurationException("Failed to find Janino compiler 'setDebuggingInformation' method: " + ex.getMessage(), ex);
        }
        try {
            this.janinoCompilerSetParentClassLoaderMethod = janinoCompilerClass.getMethod("setParentClassLoader", ClassLoader.class);
        }
        catch (Exception ex) {
            throw new ConfigurationException("Failed to find Janino compiler 'janinoCompilerSetParentClassLoaderMethod' method: " + ex.getMessage(), ex);
        }
    }
}

