/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.codegen.compile;

import com.espertech.esper.codegen.compile.CodeGenerationUtil;
import com.espertech.esper.codegen.compile.CodegenCompilerException;
import java.io.StringWriter;
import java.util.function.Supplier;

public class CodegenMessageUtil {
    public static String getFailedCompileLogMessageWithCode(Throwable t, Supplier<String> debugInformationProvider, boolean enableFallback) {
        if (!(t instanceof CodegenCompilerException)) {
            StringWriter message = new StringWriter();
            message.append("Failed to code-generate for ").append(debugInformationProvider.get()).append(": ").append(t.getMessage());
            return message.toString();
        }
        CodegenCompilerException ex = (CodegenCompilerException)t;
        StringWriter message = new StringWriter();
        message.append("Failed to code-generate for ").append(debugInformationProvider.get()).append(" (invalid code follows");
        if (enableFallback) {
            message.append(", falling back to regular evaluation");
        }
        message.append("): ").append(ex.getMessage());
        message.append("\r\ncode-in-error (please provide with issue reports):\r\n").append(CodeGenerationUtil.codeWithLineNum(ex.getCode()));
        return message.toString();
    }
}

