/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.codegen.core;

import com.espertech.esper.codegen.base.CodegenBlock;
import com.espertech.esper.codegen.core.CodeGenerationHelper;
import com.espertech.esper.codegen.core.CodegenIndent;
import com.espertech.esper.codegen.core.CodegenMethodFootprint;
import com.espertech.esper.codegen.core.CodegenNamedParam;
import java.util.Map;
import java.util.Set;

public class CodegenMethod {
    private final String name;
    private final CodegenMethodFootprint footprint;
    private final CodegenBlock block;
    private final boolean isPublic;

    public CodegenMethod(String name, CodegenMethodFootprint footprint, CodegenBlock block, boolean isPublic) {
        this.name = name;
        this.footprint = footprint;
        this.block = block;
        this.isPublic = isPublic;
    }

    public void mergeClasses(Set<Class> classes) {
        this.footprint.mergeClasses(classes);
        this.block.mergeClasses(classes);
    }

    public void render(StringBuilder builder, Map<Class, String> imports, boolean isPublic, boolean isInnerClass, CodegenIndent indent, int additionalIndent) {
        if (this.footprint.getOptionalComment() != null) {
            indent.indent(builder, 1 + additionalIndent);
            builder.append("// ").append(this.footprint.getOptionalComment()).append("\n");
        }
        indent.indent(builder, 1 + additionalIndent);
        if (isPublic) {
            builder.append("public ");
        }
        CodeGenerationHelper.appendClassName(builder, this.footprint.getReturnType(), null, imports);
        builder.append(" ").append(this.name);
        builder.append("(");
        String delimiter = "";
        for (CodegenNamedParam param : this.footprint.getParams()) {
            builder.append(delimiter);
            param.render(builder, imports);
            delimiter = ",";
        }
        builder.append("){\n");
        this.block.render(builder, imports, isInnerClass, 2 + additionalIndent, indent);
        indent.indent(builder, 1 + additionalIndent);
        builder.append("}\n");
    }

    public String getName() {
        return this.name;
    }

    public CodegenMethodFootprint getFootprint() {
        return this.footprint;
    }

    public CodegenBlock getBlock() {
        return this.block;
    }

    public boolean isPublic() {
        return this.isPublic;
    }
}

