/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.codegen.model.expression;

import com.espertech.esper.codegen.base.CodegenBlock;
import com.espertech.esper.codegen.base.CodegenMemberId;
import com.espertech.esper.codegen.base.CodegenMethodNode;
import com.espertech.esper.codegen.core.CodegenNamedParam;
import com.espertech.esper.codegen.model.expression.CodegenExpression;
import com.espertech.esper.codegen.model.expression.CodegenExpressionAndOr;
import com.espertech.esper.codegen.model.expression.CodegenExpressionArrayAtIndex;
import com.espertech.esper.codegen.model.expression.CodegenExpressionArrayLength;
import com.espertech.esper.codegen.model.expression.CodegenExpressionCastExpression;
import com.espertech.esper.codegen.model.expression.CodegenExpressionCastRef;
import com.espertech.esper.codegen.model.expression.CodegenExpressionCastUnderlying;
import com.espertech.esper.codegen.model.expression.CodegenExpressionClass;
import com.espertech.esper.codegen.model.expression.CodegenExpressionConditional;
import com.espertech.esper.codegen.model.expression.CodegenExpressionConstant;
import com.espertech.esper.codegen.model.expression.CodegenExpressionConstantFalse;
import com.espertech.esper.codegen.model.expression.CodegenExpressionConstantNull;
import com.espertech.esper.codegen.model.expression.CodegenExpressionConstantTrue;
import com.espertech.esper.codegen.model.expression.CodegenExpressionEnumOrPublicConstantValue;
import com.espertech.esper.codegen.model.expression.CodegenExpressionEqualsNull;
import com.espertech.esper.codegen.model.expression.CodegenExpressionEqualsReference;
import com.espertech.esper.codegen.model.expression.CodegenExpressionExprDotMethod;
import com.espertech.esper.codegen.model.expression.CodegenExpressionExprDotMethodChain;
import com.espertech.esper.codegen.model.expression.CodegenExpressionExprDotName;
import com.espertech.esper.codegen.model.expression.CodegenExpressionExprDotUnderlying;
import com.espertech.esper.codegen.model.expression.CodegenExpressionIncrementDecrementName;
import com.espertech.esper.codegen.model.expression.CodegenExpressionIncrementDecrementRef;
import com.espertech.esper.codegen.model.expression.CodegenExpressionInstanceOf;
import com.espertech.esper.codegen.model.expression.CodegenExpressionLocalMethod;
import com.espertech.esper.codegen.model.expression.CodegenExpressionMember;
import com.espertech.esper.codegen.model.expression.CodegenExpressionNewAnonymousClass;
import com.espertech.esper.codegen.model.expression.CodegenExpressionNewArrayByLength;
import com.espertech.esper.codegen.model.expression.CodegenExpressionNewArrayWithInit;
import com.espertech.esper.codegen.model.expression.CodegenExpressionNewInstance;
import com.espertech.esper.codegen.model.expression.CodegenExpressionNewInstanceInnerClass;
import com.espertech.esper.codegen.model.expression.CodegenExpressionNoOp;
import com.espertech.esper.codegen.model.expression.CodegenExpressionNot;
import com.espertech.esper.codegen.model.expression.CodegenExpressionOp;
import com.espertech.esper.codegen.model.expression.CodegenExpressionRef;
import com.espertech.esper.codegen.model.expression.CodegenExpressionRefWCol;
import com.espertech.esper.codegen.model.expression.CodegenExpressionRelational;
import com.espertech.esper.codegen.model.expression.CodegenExpressionStaticMethod;
import com.espertech.esper.codegen.model.expression.CodegenLocalMethodBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CodegenExpressionBuilder {
    public static CodegenExpressionRef ref(String ref) {
        return new CodegenExpressionRef(ref);
    }

    public static CodegenExpressionRefWCol refCol(String ref, int column) {
        return new CodegenExpressionRefWCol(ref, column);
    }

    public static CodegenExpressionMember member(CodegenMemberId memberId) {
        return new CodegenExpressionMember(memberId);
    }

    public static CodegenExpression op(CodegenExpression left, String expressionText, CodegenExpression right) {
        return new CodegenExpressionOp(left, expressionText, right);
    }

    public static CodegenExpression and(CodegenExpression first, CodegenExpression second, CodegenExpression ... more) {
        return new CodegenExpressionAndOr(true, first, second, more);
    }

    public static CodegenExpression or(CodegenExpression first, CodegenExpression second, CodegenExpression ... more) {
        return new CodegenExpressionAndOr(false, first, second, more);
    }

    public static CodegenExpressionExprDotName exprDotName(CodegenExpression left, String name) {
        return new CodegenExpressionExprDotName(left, name);
    }

    public static CodegenExpression exprDotMethod(CodegenExpression expression, String method, CodegenExpression ... params) {
        return new CodegenExpressionExprDotMethod(expression, method, params);
    }

    public static CodegenExpression enumValue(Class enumType, String enumValue) {
        return new CodegenExpressionEnumOrPublicConstantValue(enumType, enumValue);
    }

    public static CodegenExpression publicConstValue(Class enumType, String enumValue) {
        return new CodegenExpressionEnumOrPublicConstantValue(enumType, enumValue);
    }

    public static CodegenExpressionExprDotMethodChain exprDotMethodChain(CodegenExpression expression) {
        return new CodegenExpressionExprDotMethodChain(expression);
    }

    public static CodegenExpression exprDotUnderlying(CodegenExpression expression) {
        return new CodegenExpressionExprDotUnderlying(expression);
    }

    public static CodegenLocalMethodBuilder localMethodBuild(CodegenMethodNode methodNode) {
        return new CodegenLocalMethodBuilder(methodNode);
    }

    public static CodegenExpressionLocalMethod localMethod(CodegenMethodNode methodNode, CodegenExpression ... parameters) {
        return new CodegenExpressionLocalMethod(methodNode, Arrays.asList(parameters));
    }

    public static CodegenExpression constantTrue() {
        return CodegenExpressionConstantTrue.INSTANCE;
    }

    public static CodegenExpression constantFalse() {
        return CodegenExpressionConstantFalse.INSTANCE;
    }

    public static CodegenExpression constantNull() {
        return CodegenExpressionConstantNull.INSTANCE;
    }

    public static CodegenExpression constant(Object constant) {
        return new CodegenExpressionConstant(constant);
    }

    public static CodegenExpressionNewAnonymousClass newAnonymousClass(CodegenBlock parentBlock, Class interfaceClass, Class returnType, String methodName, List<CodegenNamedParam> params) {
        return new CodegenExpressionNewAnonymousClass(parentBlock, interfaceClass, returnType, methodName, params);
    }

    public static CodegenExpression noop() {
        return CodegenExpressionNoOp.INSTANCE;
    }

    public static CodegenExpression castUnderlying(Class clazz, CodegenExpression expression) {
        return new CodegenExpressionCastUnderlying(clazz, expression);
    }

    public static CodegenExpression instanceOf(CodegenExpression lhs, Class clazz) {
        return new CodegenExpressionInstanceOf(lhs, clazz, false);
    }

    public static CodegenExpression notInstanceOf(CodegenExpression lhs, Class clazz) {
        return new CodegenExpressionInstanceOf(lhs, clazz, true);
    }

    public static CodegenExpression castRef(Class clazz, String ref) {
        return new CodegenExpressionCastRef(clazz, ref);
    }

    public static CodegenExpression increment(String ref) {
        return new CodegenExpressionIncrementDecrementName(ref, true);
    }

    public static CodegenExpression increment(CodegenExpressionRef ref) {
        return new CodegenExpressionIncrementDecrementRef(ref, true);
    }

    public static CodegenExpression decrement(String ref) {
        return new CodegenExpressionIncrementDecrementName(ref, false);
    }

    public static CodegenExpression decrement(CodegenExpressionRef ref) {
        return new CodegenExpressionIncrementDecrementRef(ref, false);
    }

    public static CodegenExpression conditional(CodegenExpression condition, CodegenExpression expressionTrue, CodegenExpression expressionFalse) {
        return new CodegenExpressionConditional(condition, expressionTrue, expressionFalse);
    }

    public static CodegenExpression not(CodegenExpression expression) {
        return new CodegenExpressionNot(true, expression);
    }

    public static CodegenExpression notOptional(boolean isNot, CodegenExpression expression) {
        return new CodegenExpressionNot(isNot, expression);
    }

    public static CodegenExpression cast(Class clazz, CodegenExpression expression) {
        return new CodegenExpressionCastExpression(clazz, expression);
    }

    public static CodegenExpression cast(String typeName, CodegenExpression expression) {
        return new CodegenExpressionCastExpression(typeName, expression);
    }

    public static CodegenExpression notEqualsNull(CodegenExpression lhs) {
        return new CodegenExpressionEqualsNull(lhs, true);
    }

    public static CodegenExpression equalsNull(CodegenExpression lhs) {
        return new CodegenExpressionEqualsNull(lhs, false);
    }

    public static CodegenExpression equalsIdentity(CodegenExpression lhs, CodegenExpression rhs) {
        return new CodegenExpressionEqualsReference(lhs, rhs, false);
    }

    public static CodegenExpression staticMethod(Class clazz, String method, CodegenExpression ... params) {
        return new CodegenExpressionStaticMethod(clazz, method, params);
    }

    public static CodegenExpression clazz(Class clazz) {
        return new CodegenExpressionClass(clazz);
    }

    public static CodegenExpression arrayAtIndex(CodegenExpression expression, CodegenExpression index) {
        return new CodegenExpressionArrayAtIndex(expression, index);
    }

    public static CodegenExpression arrayLength(CodegenExpression expression) {
        return new CodegenExpressionArrayLength(expression);
    }

    public static CodegenExpression newInstance(Class clazz, CodegenExpression ... params) {
        return new CodegenExpressionNewInstance(clazz, params);
    }

    public static CodegenExpression newInstanceInnerClass(String name, CodegenExpression ... params) {
        return new CodegenExpressionNewInstanceInnerClass(name, params);
    }

    public static CodegenExpression relational(CodegenExpression lhs, CodegenExpressionRelational.CodegenRelational op, CodegenExpression rhs) {
        return new CodegenExpressionRelational(lhs, op, rhs);
    }

    public static CodegenExpression newArrayByLength(Class component, CodegenExpression expression) {
        return new CodegenExpressionNewArrayByLength(component, expression);
    }

    public static CodegenExpression newArrayWithInit(Class component, CodegenExpression ... expressions) {
        return new CodegenExpressionNewArrayWithInit(component, expressions);
    }

    public static void renderExpressions(StringBuilder builder, CodegenExpression[] expressions, Map<Class, String> imports, boolean isInnerClass) {
        String delimiter = "";
        for (CodegenExpression expression : expressions) {
            builder.append(delimiter);
            expression.render(builder, imports, isInnerClass);
            delimiter = ",";
        }
    }

    public static void mergeClassesExpressions(Set<Class> classes, CodegenExpression[] expressions) {
        for (CodegenExpression expression : expressions) {
            expression.mergeClasses(classes);
        }
    }
}

