/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.codegen.model.expression;

import com.espertech.esper.codegen.base.CodegenMethodNode;
import com.espertech.esper.codegen.model.expression.CodegenExpression;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CodegenExpressionLocalMethod
implements CodegenExpression {
    private final CodegenMethodNode methodNode;
    private final List<CodegenExpression> parameters;

    public CodegenExpressionLocalMethod(CodegenMethodNode methodNode, List<CodegenExpression> parameters) {
        this.methodNode = methodNode;
        this.parameters = parameters;
    }

    @Override
    public void render(StringBuilder builder, Map<Class, String> imports, boolean isInnerClass) {
        if (this.methodNode.getAssignedMethod() == null) {
            throw new IllegalStateException("Method has no assignment for " + this.methodNode.getAdditionalDebugInfo());
        }
        builder.append(this.methodNode.getAssignedMethod().getName()).append("(");
        String delimiter = "";
        for (CodegenExpression expression : this.parameters) {
            builder.append(delimiter);
            expression.render(builder, imports, isInnerClass);
            delimiter = ",";
        }
        if (this.methodNode.getOptionalSymbolProvider() == null) {
            for (String name : this.methodNode.getDeepParameters()) {
                builder.append(delimiter);
                builder.append(name);
                delimiter = ",";
            }
        }
        builder.append(")");
    }

    @Override
    public void mergeClasses(Set<Class> classes) {
        this.methodNode.mergeClasses(classes);
    }
}

