/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.codegen.model.expression;

import com.espertech.esper.codegen.core.CodeGenerationHelper;
import java.lang.reflect.Array;
import java.util.Map;

public class CodegenExpressionUtil {
    public static void renderConstant(StringBuilder builder, Object constant, Map<Class, String> imports) {
        if (constant instanceof String) {
            builder.append('\"');
            String seq = (String)constant;
            if (seq.indexOf(34) == -1) {
                builder.append(constant);
            } else {
                CodegenExpressionUtil.appendSequenceEscapeDQ(builder, seq);
            }
            builder.append('\"');
        } else if (constant instanceof CharSequence) {
            CodegenExpressionUtil.appendSequenceEscapeDQ(builder, (CharSequence)constant);
        } else if (constant instanceof Character) {
            Character c = (Character)constant;
            if (c.charValue() == '\'') {
                builder.append('\'');
                builder.append('\\');
                builder.append('\'');
                builder.append('\'');
            } else if (c.charValue() == '\\') {
                builder.append('\'');
                builder.append('\\');
                builder.append('\\');
                builder.append('\'');
            } else {
                builder.append('\'');
                builder.append(c);
                builder.append('\'');
            }
        } else if (constant == null) {
            builder.append("null");
        } else if (constant instanceof Long) {
            builder.append(constant).append("L");
        } else if (constant instanceof Float) {
            builder.append(constant).append("F");
        } else if (constant instanceof Byte) {
            builder.append("(byte)").append(constant);
        } else if (constant.getClass().isArray()) {
            builder.append("new ");
            CodeGenerationHelper.appendClassName(builder, constant.getClass().getComponentType(), null, imports);
            builder.append("[] {");
            String delimiter = "";
            for (int i = 0; i < Array.getLength(constant); ++i) {
                builder.append(delimiter);
                CodegenExpressionUtil.renderConstant(builder, Array.get(constant, i), imports);
                delimiter = ",";
            }
            builder.append("}");
        } else {
            builder.append(constant);
        }
    }

    private static void appendSequenceEscapeDQ(StringBuilder builder, CharSequence seq) {
        for (int i = 0; i < seq.length(); ++i) {
            char c = seq.charAt(i);
            if (c == '\"') {
                builder.append('\\');
                builder.append(c);
                continue;
            }
            builder.append(c);
        }
    }
}

