/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.context.mgr;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.context.ContextPartitionIdentifier;
import com.espertech.esper.client.context.ContextPartitionIdentifierHash;
import com.espertech.esper.client.context.ContextPartitionSelector;
import com.espertech.esper.client.context.ContextPartitionSelectorAll;
import com.espertech.esper.client.context.ContextPartitionSelectorById;
import com.espertech.esper.client.context.ContextPartitionSelectorFiltered;
import com.espertech.esper.client.context.ContextPartitionSelectorHash;
import com.espertech.esper.client.context.ContextPartitionState;
import com.espertech.esper.core.context.mgr.AgentInstanceSelector;
import com.espertech.esper.core.context.mgr.ContextController;
import com.espertech.esper.core.context.mgr.ContextControllerFactory;
import com.espertech.esper.core.context.mgr.ContextControllerFactoryContext;
import com.espertech.esper.core.context.mgr.ContextControllerHashFactoryImpl;
import com.espertech.esper.core.context.mgr.ContextControllerHashedFilterCallback;
import com.espertech.esper.core.context.mgr.ContextControllerHashedInstanceCallback;
import com.espertech.esper.core.context.mgr.ContextControllerInstanceHandle;
import com.espertech.esper.core.context.mgr.ContextControllerLifecycleCallback;
import com.espertech.esper.core.context.mgr.ContextControllerState;
import com.espertech.esper.core.context.mgr.ContextControllerStateUtil;
import com.espertech.esper.core.context.mgr.ContextInternalFilterAddendum;
import com.espertech.esper.core.context.mgr.ContextPartitionVisitor;
import com.espertech.esper.core.context.mgr.ContextPropertyEventType;
import com.espertech.esper.core.context.mgr.ContextStatePathKey;
import com.espertech.esper.core.context.mgr.ContextStatePathValue;
import com.espertech.esper.core.context.util.ContextControllerSelectorUtil;
import com.espertech.esper.core.context.util.StatementAgentInstanceUtil;
import com.espertech.esper.epl.spec.ContextDetailHashItem;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;

public class ContextControllerHash
implements ContextController,
ContextControllerHashedInstanceCallback {
    protected final int pathId;
    protected final ContextControllerLifecycleCallback activationCallback;
    protected final ContextControllerHashFactoryImpl factory;
    protected final List<ContextControllerHashedFilterCallback> filterCallbacks = new ArrayList<ContextControllerHashedFilterCallback>();
    protected final Map<Integer, ContextControllerInstanceHandle> partitionKeys = new LinkedHashMap<Integer, ContextControllerInstanceHandle>();
    protected ContextInternalFilterAddendum activationFilterAddendum;
    protected int currentSubpathId;

    public ContextControllerHash(int pathId, ContextControllerLifecycleCallback activationCallback, ContextControllerHashFactoryImpl factory) {
        this.pathId = pathId;
        this.activationCallback = activationCallback;
        this.factory = factory;
    }

    @Override
    public void importContextPartitions(ContextControllerState state, int pathIdToUse, ContextInternalFilterAddendum filterAddendum, AgentInstanceSelector agentInstanceSelector) {
        this.initializeFromState(null, null, state, pathIdToUse, agentInstanceSelector, true);
    }

    @Override
    public void deletePath(ContextPartitionIdentifier identifier) {
        ContextPartitionIdentifierHash hash = (ContextPartitionIdentifierHash)identifier;
        this.partitionKeys.remove(hash.getHash());
    }

    @Override
    public void visitSelectedPartitions(ContextPartitionSelector contextPartitionSelector, ContextPartitionVisitor visitor) {
        int nestingLevel = this.factory.getFactoryContext().getNestingLevel();
        if (contextPartitionSelector instanceof ContextPartitionSelectorHash) {
            ContextPartitionSelectorHash hash = (ContextPartitionSelectorHash)contextPartitionSelector;
            if (hash.getHashes() == null || hash.getHashes().isEmpty()) {
                return;
            }
            for (int hashCode : hash.getHashes()) {
                ContextControllerInstanceHandle handle = this.partitionKeys.get(hashCode);
                if (handle == null) continue;
                visitor.visit(nestingLevel, this.pathId, this.factory.getBinding(), hashCode, this, handle);
            }
            return;
        }
        if (contextPartitionSelector instanceof ContextPartitionSelectorFiltered) {
            ContextPartitionSelectorFiltered filter = (ContextPartitionSelectorFiltered)contextPartitionSelector;
            ContextPartitionIdentifierHash identifierHash = new ContextPartitionIdentifierHash();
            for (Map.Entry<Integer, ContextControllerInstanceHandle> entry : this.partitionKeys.entrySet()) {
                identifierHash.setHash(entry.getKey());
                identifierHash.setContextPartitionId(entry.getValue().getContextPartitionOrPathId());
                if (!filter.filter(identifierHash)) continue;
                visitor.visit(nestingLevel, this.pathId, this.factory.getBinding(), entry.getKey(), this, entry.getValue());
            }
            return;
        }
        if (contextPartitionSelector instanceof ContextPartitionSelectorAll) {
            for (Map.Entry<Integer, ContextControllerInstanceHandle> entry : this.partitionKeys.entrySet()) {
                visitor.visit(nestingLevel, this.pathId, this.factory.getBinding(), entry.getKey(), this, entry.getValue());
            }
            return;
        }
        if (contextPartitionSelector instanceof ContextPartitionSelectorById) {
            ContextPartitionSelectorById byId = (ContextPartitionSelectorById)contextPartitionSelector;
            for (Map.Entry<Integer, ContextControllerInstanceHandle> entry : this.partitionKeys.entrySet()) {
                int cpid = entry.getValue().getContextPartitionOrPathId();
                if (!byId.getContextPartitionIds().contains(cpid)) continue;
                visitor.visit(nestingLevel, this.pathId, this.factory.getBinding(), entry.getKey(), this, entry.getValue());
            }
            return;
        }
        throw ContextControllerSelectorUtil.getInvalidSelector(new Class[]{ContextPartitionSelectorHash.class}, contextPartitionSelector);
    }

    @Override
    public void activate(EventBean optionalTriggeringEvent, Map<String, Object> optionalTriggeringPattern, ContextControllerState controllerState, ContextInternalFilterAddendum activationFilterAddendum, Integer importPathId) {
        ContextControllerFactoryContext factoryContext = this.factory.getFactoryContext();
        this.activationFilterAddendum = activationFilterAddendum;
        if (factoryContext.getNestingLevel() == 1) {
            controllerState = ContextControllerStateUtil.getRecoveryStates(this.factory.getFactoryContext().getStateCache(), factoryContext.getOutermostContextName());
        }
        if (controllerState == null) {
            if (this.factory.getHashedSpec().isPreallocate()) {
                for (int i = 0; i < this.factory.getHashedSpec().getGranularity(); ++i) {
                    Map<String, Object> properties = ContextPropertyEventType.getHashBean(factoryContext.getContextName(), i);
                    ++this.currentSubpathId;
                    ContextInternalFilterAddendum filterAddendumToUse = activationFilterAddendum;
                    if (this.factory.hasFiltersSpecsNestedContexts()) {
                        filterAddendumToUse = activationFilterAddendum != null ? activationFilterAddendum.deepCopy() : new ContextInternalFilterAddendum();
                        this.factory.populateContextInternalFilterAddendums(filterAddendumToUse, i);
                    }
                    int hash = i;
                    ContextControllerInstanceHandle handle = this.activationCallback.contextPartitionInstantiate(null, this.currentSubpathId, null, this, optionalTriggeringEvent, null, i, properties, controllerState, filterAddendumToUse, this.factory.getFactoryContext().isRecoveringResilient(), ContextPartitionState.STARTED, () -> new ContextPartitionIdentifierHash(hash));
                    this.partitionKeys.put(i, handle);
                    this.factory.getFactoryContext().getStateCache().addContextPath(this.factory.getFactoryContext().getOutermostContextName(), this.factory.getFactoryContext().getNestingLevel(), this.pathId, this.currentSubpathId, handle.getContextPartitionOrPathId(), i, this.factory.getBinding());
                }
                return;
            }
            this.activateFilters(optionalTriggeringEvent);
            return;
        }
        int pathIdToUse = importPathId != null ? importPathId : this.pathId;
        this.initializeFromState(optionalTriggeringEvent, optionalTriggeringPattern, controllerState, pathIdToUse, null, false);
        if (!this.factory.getHashedSpec().isPreallocate()) {
            this.activateFilters(null);
        }
    }

    protected void activateFilters(EventBean optionalTriggeringEvent) {
        ContextControllerFactoryContext factoryContext = this.factory.getFactoryContext();
        for (ContextDetailHashItem item : this.factory.getHashedSpec().getItems()) {
            boolean match;
            ContextControllerHashedFilterCallback callback = new ContextControllerHashedFilterCallback(factoryContext.getServicesContext(), factoryContext.getAgentInstanceContextCreate(), item, this, this.activationFilterAddendum);
            this.filterCallbacks.add(callback);
            if (optionalTriggeringEvent == null || !(match = StatementAgentInstanceUtil.evaluateFilterForStatement(factoryContext.getServicesContext(), optionalTriggeringEvent, factoryContext.getAgentInstanceContextCreate(), callback.getFilterHandle()))) continue;
            callback.matchFound(optionalTriggeringEvent, null);
        }
    }

    @Override
    public synchronized void create(int id, EventBean theEvent) {
        ContextControllerFactoryContext factoryContext = this.factory.getFactoryContext();
        if (this.partitionKeys.containsKey(id)) {
            return;
        }
        Map<String, Object> properties = ContextPropertyEventType.getHashBean(factoryContext.getContextName(), id);
        ++this.currentSubpathId;
        ContextInternalFilterAddendum filterAddendumToUse = this.activationFilterAddendum;
        if (this.factory.hasFiltersSpecsNestedContexts()) {
            filterAddendumToUse = this.activationFilterAddendum != null ? this.activationFilterAddendum.deepCopy() : new ContextInternalFilterAddendum();
            this.factory.populateContextInternalFilterAddendums(filterAddendumToUse, id);
        }
        ContextControllerInstanceHandle handle = this.activationCallback.contextPartitionInstantiate(null, this.currentSubpathId, null, this, theEvent, null, id, properties, null, filterAddendumToUse, this.factory.getFactoryContext().isRecoveringResilient(), ContextPartitionState.STARTED, () -> new ContextPartitionIdentifierHash(id));
        this.partitionKeys.put(id, handle);
        this.factory.getFactoryContext().getStateCache().addContextPath(factoryContext.getOutermostContextName(), factoryContext.getNestingLevel(), this.pathId, this.currentSubpathId, handle.getContextPartitionOrPathId(), id, this.factory.getBinding());
        long filterVersion = factoryContext.getServicesContext().getFilterService().getFiltersVersion();
        this.factory.getFactoryContext().getAgentInstanceContextCreate().getEpStatementAgentInstanceHandle().getStatementFilterVersion().setStmtFilterVersion(filterVersion);
    }

    @Override
    public ContextControllerFactory getFactory() {
        return this.factory;
    }

    @Override
    public int getPathId() {
        return this.pathId;
    }

    @Override
    public void deactivate() {
        ContextControllerFactoryContext factoryContext = this.factory.getFactoryContext();
        for (ContextControllerHashedFilterCallback callback : this.filterCallbacks) {
            callback.destroy(factoryContext.getServicesContext().getFilterService());
        }
        this.partitionKeys.clear();
        this.filterCallbacks.clear();
        this.factory.getFactoryContext().getStateCache().removeContextParentPath(factoryContext.getOutermostContextName(), factoryContext.getNestingLevel(), this.pathId);
    }

    private void initializeFromState(EventBean optionalTriggeringEvent, Map<String, Object> optionalTriggeringPattern, ContextControllerState controllerState, int pathIdToUse, AgentInstanceSelector agentInstanceSelector, boolean loadingExistingState) {
        ContextControllerFactoryContext factoryContext = this.factory.getFactoryContext();
        TreeMap<ContextStatePathKey, ContextStatePathValue> states = controllerState.getStates();
        NavigableMap<ContextStatePathKey, ContextStatePathValue> childContexts = ContextControllerStateUtil.getChildContexts(factoryContext, pathIdToUse, states);
        int maxSubpathId = Integer.MIN_VALUE;
        for (Map.Entry entry : childContexts.entrySet()) {
            int n;
            ContextControllerInstanceHandle existingHandle;
            Integer hashAlgoGeneratedId = (Integer)this.factory.getBinding().byteArrayToObject(((ContextStatePathValue)entry.getValue()).getBlob(), null);
            ContextInternalFilterAddendum filterAddendumToUse = this.activationFilterAddendum;
            if (this.factory.hasFiltersSpecsNestedContexts()) {
                filterAddendumToUse = this.activationFilterAddendum != null ? this.activationFilterAddendum.deepCopy() : new ContextInternalFilterAddendum();
                this.factory.populateContextInternalFilterAddendums(filterAddendumToUse, hashAlgoGeneratedId);
            }
            if (controllerState.isImported() && (existingHandle = this.partitionKeys.get(hashAlgoGeneratedId)) != null) {
                this.activationCallback.contextPartitionNavigate(existingHandle, this, controllerState, ((ContextStatePathValue)entry.getValue()).getOptionalContextPartitionId(), filterAddendumToUse, agentInstanceSelector, ((ContextStatePathValue)entry.getValue()).getBlob(), loadingExistingState);
                continue;
            }
            Map<String, Object> properties = ContextPropertyEventType.getHashBean(factoryContext.getContextName(), hashAlgoGeneratedId);
            if (!controllerState.isImported()) {
                n = ((ContextStatePathKey)entry.getKey()).getSubPath();
            } else {
                n = this.currentSubpathId + 1;
                this.currentSubpathId = this.currentSubpathId;
            }
            int assignedSubPathId = n;
            ContextControllerInstanceHandle handle = this.activationCallback.contextPartitionInstantiate(((ContextStatePathValue)entry.getValue()).getOptionalContextPartitionId(), assignedSubPathId, ((ContextStatePathKey)entry.getKey()).getSubPath(), this, optionalTriggeringEvent, optionalTriggeringPattern, hashAlgoGeneratedId, properties, controllerState, filterAddendumToUse, loadingExistingState || factoryContext.isRecoveringResilient(), ((ContextStatePathValue)entry.getValue()).getState(), () -> new ContextPartitionIdentifierHash(hashAlgoGeneratedId));
            this.partitionKeys.put(hashAlgoGeneratedId, handle);
            if (((ContextStatePathKey)entry.getKey()).getSubPath() <= maxSubpathId) continue;
            maxSubpathId = assignedSubPathId;
        }
        if (!controllerState.isImported()) {
            this.currentSubpathId = maxSubpathId != Integer.MIN_VALUE ? maxSubpathId : 0;
        }
    }
}

