/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.context.mgr;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventPropertyGetter;
import com.espertech.esper.client.PropertyAccessException;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import java.util.zip.CRC32;

public class ContextControllerHashedGetterCRC32Single
implements EventPropertyGetter {
    private final ExprEvaluator eval;
    private final int granularity;

    public ContextControllerHashedGetterCRC32Single(ExprEvaluator eval, int granularity) {
        this.eval = eval;
        this.granularity = granularity;
    }

    @Override
    public Object get(EventBean eventBean) throws PropertyAccessException {
        long value;
        EventBean[] events = new EventBean[]{eventBean};
        String code = (String)this.eval.evaluate(events, true, null);
        if (code == null) {
            value = 0L;
        } else {
            CRC32 crc = new CRC32();
            crc.update(code.getBytes());
            value = crc.getValue() % (long)this.granularity;
        }
        int result = (int)value;
        if (result >= 0) {
            return result;
        }
        return -result;
    }

    @Override
    public boolean isExistsProperty(EventBean eventBean) {
        return false;
    }

    @Override
    public Object getFragment(EventBean eventBean) throws PropertyAccessException {
        return null;
    }
}

