/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.context.mgr;

import com.espertech.esper.client.EventType;
import com.espertech.esper.client.context.ContextPartitionIdentifier;
import com.espertech.esper.client.context.ContextPartitionIdentifierInitiatedTerminated;
import com.espertech.esper.core.context.mgr.ContextControllerFactory;
import com.espertech.esper.core.context.mgr.ContextControllerFactoryBase;
import com.espertech.esper.core.context.mgr.ContextControllerFactoryContext;
import com.espertech.esper.core.context.mgr.ContextControllerInitTermState;
import com.espertech.esper.core.context.mgr.ContextControllerStatementBase;
import com.espertech.esper.core.context.mgr.ContextControllerStatementCtxCache;
import com.espertech.esper.core.context.mgr.ContextControllerStatementDesc;
import com.espertech.esper.core.context.mgr.ContextPropertyEventType;
import com.espertech.esper.core.context.stmt.AIRegistryAggregationMultiPerm;
import com.espertech.esper.core.context.stmt.AIRegistryAggregationSingle;
import com.espertech.esper.core.context.stmt.AIRegistryExprMultiPerm;
import com.espertech.esper.core.context.stmt.AIRegistryExprSingle;
import com.espertech.esper.core.context.stmt.StatementAIResourceRegistry;
import com.espertech.esper.core.context.stmt.StatementAIResourceRegistryFactory;
import com.espertech.esper.core.service.EPStatementHandle;
import com.espertech.esper.core.service.StatementContext;
import com.espertech.esper.epl.expression.core.ExprFilterSpecLookupable;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.spec.ContextDetailInitiatedTerminated;
import com.espertech.esper.epl.spec.ContextDetailPartitionItem;
import com.espertech.esper.filterspec.FilterSpecCompiled;
import com.espertech.esper.filterspec.FilterValueSetParam;
import com.espertech.esper.filterspec.MatchedEventMapMeta;
import com.espertech.esper.schedule.SchedulingService;
import com.espertech.esper.schedule.TimeProvider;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

public abstract class ContextControllerInitTermFactoryBase
extends ContextControllerFactoryBase
implements ContextControllerFactory {
    private final ContextDetailInitiatedTerminated detail;
    private Map<String, Object> contextBuiltinProps;
    private MatchedEventMapMeta matchedEventMapMeta;

    public ContextControllerInitTermFactoryBase(ContextControllerFactoryContext factoryContext, ContextDetailInitiatedTerminated detail) {
        super(factoryContext);
        this.detail = detail;
    }

    @Override
    public void validateFactory() throws ExprValidationException {
        this.contextBuiltinProps = ContextPropertyEventType.getInitiatedTerminatedType();
        LinkedHashSet<String> allTags = new LinkedHashSet<String>();
        ContextPropertyEventType.addEndpointTypes(this.factoryContext.getContextName(), this.detail.getStart(), this.contextBuiltinProps, allTags);
        ContextPropertyEventType.addEndpointTypes(this.factoryContext.getContextName(), this.detail.getEnd(), this.contextBuiltinProps, allTags);
        this.matchedEventMapMeta = new MatchedEventMapMeta(allTags, false);
    }

    @Override
    public Map<String, Object> getContextBuiltinProps() {
        return this.contextBuiltinProps;
    }

    public MatchedEventMapMeta getMatchedEventMapMeta() {
        return this.matchedEventMapMeta;
    }

    @Override
    public ContextControllerStatementCtxCache validateStatement(ContextControllerStatementBase statement) {
        return null;
    }

    @Override
    public void populateFilterAddendums(IdentityHashMap<FilterSpecCompiled, FilterValueSetParam[][]> filterAddendum, ContextControllerStatementDesc statement, Object key, int contextId) {
    }

    @Override
    public ExprFilterSpecLookupable getFilterLookupable(EventType eventType) {
        return null;
    }

    @Override
    public ContextDetailInitiatedTerminated getContextDetail() {
        return this.detail;
    }

    @Override
    public List<ContextDetailPartitionItem> getContextDetailPartitionItems() {
        return Collections.emptyList();
    }

    @Override
    public boolean isSingleInstanceContext() {
        return !this.detail.isOverlapping();
    }

    public long allocateSlot() {
        return this.factoryContext.getAgentInstanceContextCreate().getStatementContext().getScheduleBucket().allocateSlot();
    }

    public TimeProvider getTimeProvider() {
        return this.factoryContext.getAgentInstanceContextCreate().getStatementContext().getTimeProvider();
    }

    public SchedulingService getSchedulingService() {
        return this.factoryContext.getAgentInstanceContextCreate().getStatementContext().getSchedulingService();
    }

    public EPStatementHandle getEpStatementHandle() {
        return this.factoryContext.getAgentInstanceContextCreate().getStatementContext().getEpStatementHandle();
    }

    public StatementContext getStatementContext() {
        return this.factoryContext.getAgentInstanceContextCreate().getStatementContext();
    }

    @Override
    public ContextPartitionIdentifier keyPayloadToIdentifier(Object payload) {
        ContextControllerInitTermState state = (ContextControllerInitTermState)payload;
        return new ContextPartitionIdentifierInitiatedTerminated(state == null ? null : state.getPatternData(), state == null ? 0L : state.getStartTime(), null);
    }

    @Override
    public StatementAIResourceRegistryFactory getStatementAIResourceRegistryFactory() {
        if (this.getContextDetail().isOverlapping()) {
            return new StatementAIResourceRegistryFactory(){

                @Override
                public StatementAIResourceRegistry make() {
                    return new StatementAIResourceRegistry(new AIRegistryAggregationMultiPerm(), new AIRegistryExprMultiPerm());
                }
            };
        }
        return new StatementAIResourceRegistryFactory(){

            @Override
            public StatementAIResourceRegistry make() {
                return new StatementAIResourceRegistry(new AIRegistryAggregationSingle(), new AIRegistryExprSingle());
            }
        };
    }
}

