/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.context.mgr;

import com.espertech.esper.client.EventType;
import com.espertech.esper.core.context.util.ContextPropertyRegistry;
import com.espertech.esper.epl.spec.ContextDetailPartitionItem;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

public class ContextPropertyRegistryImpl
implements ContextPropertyRegistry {
    public static final ContextPropertyRegistry EMPTY_REGISTRY = new ContextPropertyRegistryImpl(null);
    private final List<ContextDetailPartitionItem> partitionProperties;
    private final EventType contextEventType;

    public ContextPropertyRegistryImpl(List<ContextDetailPartitionItem> partitionProperties, EventType contextEventType) {
        this.partitionProperties = partitionProperties;
        this.contextEventType = contextEventType;
    }

    public ContextPropertyRegistryImpl(EventType contextEventType) {
        this.partitionProperties = Collections.emptyList();
        this.contextEventType = contextEventType;
    }

    @Override
    public boolean isPartitionProperty(EventType fromType, String propertyName) {
        String name = this.getPartitionContextPropertyName(fromType, propertyName);
        return name != null;
    }

    @Override
    public String getPartitionContextPropertyName(EventType fromType, String propertyName) {
        for (ContextDetailPartitionItem item : this.partitionProperties) {
            if (item.getFilterSpecCompiled().getFilterForEventType() != fromType) continue;
            for (int i = 0; i < item.getPropertyNames().size(); ++i) {
                if (!item.getPropertyNames().get(i).equals(propertyName)) continue;
                return "key" + (i + 1);
            }
        }
        return null;
    }

    @Override
    public boolean isContextPropertyPrefix(String prefixName) {
        return prefixName != null && prefixName.toLowerCase(Locale.ENGLISH).equals("context");
    }

    @Override
    public EventType getContextEventType() {
        return this.contextEventType;
    }
}

