/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.service;

import com.espertech.esper.client.ConfigurationEngineDefaults;
import com.espertech.esper.client.ConfigurationEventTypeAvro;
import com.espertech.esper.client.ConfigurationEventTypeLegacy;
import com.espertech.esper.client.ConfigurationEventTypeMap;
import com.espertech.esper.client.ConfigurationEventTypeObjectArray;
import com.espertech.esper.client.ConfigurationEventTypeWithSupertype;
import com.espertech.esper.client.ConfigurationEventTypeXMLDOM;
import com.espertech.esper.client.ConfigurationException;
import com.espertech.esper.client.ConfigurationInformation;
import com.espertech.esper.client.ConfigurationPlugInAggregationFunction;
import com.espertech.esper.client.ConfigurationPlugInAggregationMultiFunction;
import com.espertech.esper.client.ConfigurationPlugInEventRepresentation;
import com.espertech.esper.client.ConfigurationPlugInEventType;
import com.espertech.esper.client.ConfigurationPlugInSingleRowFunction;
import com.espertech.esper.client.ConfigurationVariable;
import com.espertech.esper.client.EPServiceProvider;
import com.espertech.esper.client.hook.ConditionHandler;
import com.espertech.esper.client.hook.ConditionHandlerFactory;
import com.espertech.esper.client.hook.ConditionHandlerFactoryContext;
import com.espertech.esper.client.hook.ExceptionHandler;
import com.espertech.esper.client.hook.ExceptionHandlerFactory;
import com.espertech.esper.client.hook.ExceptionHandlerFactoryContext;
import com.espertech.esper.client.hook.VirtualDataWindowFactory;
import com.espertech.esper.codegen.compile.CodegenCompilerJanino;
import com.espertech.esper.collection.Pair;
import com.espertech.esper.core.context.activator.ViewableActivatorFactoryDefault;
import com.espertech.esper.core.context.mgr.ContextControllerFactoryFactorySvcImpl;
import com.espertech.esper.core.context.mgr.ContextManagementServiceImpl;
import com.espertech.esper.core.context.mgr.ContextManagerFactoryServiceImpl;
import com.espertech.esper.core.deploy.DeploymentStateServiceImpl;
import com.espertech.esper.core.service.EPRuntimeIsolatedFactoryImpl;
import com.espertech.esper.core.service.EPServicesContext;
import com.espertech.esper.core.service.EPServicesContextFactory;
import com.espertech.esper.core.service.EPStatementFactoryDefault;
import com.espertech.esper.core.service.EngineEnvContext;
import com.espertech.esper.core.service.ExceptionHandlingService;
import com.espertech.esper.core.service.InternalEventRouterImpl;
import com.espertech.esper.core.service.StatementContextFactoryDefault;
import com.espertech.esper.core.service.StatementEventTypeRefImpl;
import com.espertech.esper.core.service.StatementIsolationServiceImpl;
import com.espertech.esper.core.service.StatementLifecycleSvcImpl;
import com.espertech.esper.core.service.StatementLockFactoryImpl;
import com.espertech.esper.core.service.StatementMetadataFactory;
import com.espertech.esper.core.service.StatementMetadataFactoryDefault;
import com.espertech.esper.core.service.StatementVariableRefImpl;
import com.espertech.esper.core.service.multimatch.MultiMatchHandlerFactoryImpl;
import com.espertech.esper.core.thread.ThreadingServiceImpl;
import com.espertech.esper.dataflow.core.DataFlowConfigurationStateServiceImpl;
import com.espertech.esper.dataflow.core.DataFlowServiceImpl;
import com.espertech.esper.epl.agg.factory.AggregationFactoryFactory;
import com.espertech.esper.epl.agg.factory.AggregationFactoryFactoryDefault;
import com.espertech.esper.epl.core.engineimport.EngineImportException;
import com.espertech.esper.epl.core.engineimport.EngineImportService;
import com.espertech.esper.epl.core.engineimport.EngineImportServiceImpl;
import com.espertech.esper.epl.core.engineimport.EngineSettingsService;
import com.espertech.esper.epl.core.resultset.core.ResultSetProcessorHelperFactoryImpl;
import com.espertech.esper.epl.db.DataCacheFactory;
import com.espertech.esper.epl.db.DatabaseConfigService;
import com.espertech.esper.epl.db.DatabaseConfigServiceImpl;
import com.espertech.esper.epl.declexpr.ExprDeclaredServiceImpl;
import com.espertech.esper.epl.expression.time.TimeAbacus;
import com.espertech.esper.epl.expression.time.TimeAbacusMicroseconds;
import com.espertech.esper.epl.expression.time.TimeAbacusMilliseconds;
import com.espertech.esper.epl.lookup.EventTableIndexServiceImpl;
import com.espertech.esper.epl.metric.MetricReportingServiceImpl;
import com.espertech.esper.epl.named.NamedWindowConsumerMgmtServiceImpl;
import com.espertech.esper.epl.named.NamedWindowDispatchServiceImpl;
import com.espertech.esper.epl.named.NamedWindowMgmtServiceImpl;
import com.espertech.esper.epl.spec.PluggableObjectCollection;
import com.espertech.esper.epl.table.mgmt.TableServiceImpl;
import com.espertech.esper.epl.variable.VariableExistsException;
import com.espertech.esper.epl.variable.VariableService;
import com.espertech.esper.epl.variable.VariableServiceImpl;
import com.espertech.esper.epl.variable.VariableTypeException;
import com.espertech.esper.event.EventAdapterException;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.event.EventAdapterServiceImpl;
import com.espertech.esper.event.EventTypeIdGenerator;
import com.espertech.esper.event.EventTypeIdGeneratorContext;
import com.espertech.esper.event.EventTypeIdGeneratorFactory;
import com.espertech.esper.event.EventTypeIdGeneratorImpl;
import com.espertech.esper.event.EventTypeUtility;
import com.espertech.esper.event.avro.EventAdapterAvroHandler;
import com.espertech.esper.event.avro.EventAdapterAvroHandlerUnsupported;
import com.espertech.esper.event.vaevent.ValueAddEventServiceImpl;
import com.espertech.esper.event.xml.SchemaModel;
import com.espertech.esper.event.xml.XSDSchemaMapper;
import com.espertech.esper.filter.FilterBooleanExpressionFactoryImpl;
import com.espertech.esper.filter.FilterNonPropertyRegisteryServiceImpl;
import com.espertech.esper.filter.FilterServiceProvider;
import com.espertech.esper.filter.FilterServiceSPI;
import com.espertech.esper.pattern.PatternNodeFactoryImpl;
import com.espertech.esper.pattern.pool.PatternSubexpressionPoolEngineSvc;
import com.espertech.esper.plugin.PlugInEventRepresentation;
import com.espertech.esper.plugin.PlugInEventRepresentationContext;
import com.espertech.esper.rowregex.MatchRecognizeStatePoolEngineSvc;
import com.espertech.esper.rowregex.RegexHandlerFactoryDefault;
import com.espertech.esper.schedule.ScheduleBucket;
import com.espertech.esper.schedule.SchedulingMgmtService;
import com.espertech.esper.schedule.SchedulingMgmtServiceImpl;
import com.espertech.esper.schedule.SchedulingService;
import com.espertech.esper.schedule.SchedulingServiceProvider;
import com.espertech.esper.schedule.SchedulingServiceSPI;
import com.espertech.esper.timer.TimeSourceService;
import com.espertech.esper.timer.TimeSourceServiceImpl;
import com.espertech.esper.timer.TimerServiceImpl;
import com.espertech.esper.util.GraphCircularDependencyException;
import com.espertech.esper.util.GraphUtil;
import com.espertech.esper.util.JavaClassHelper;
import com.espertech.esper.util.ManagedReadWriteLock;
import com.espertech.esper.view.ViewServicePreviousFactoryImpl;
import com.espertech.esper.view.stream.StreamFactoryService;
import com.espertech.esper.view.stream.StreamFactoryServiceProvider;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EPServicesContextFactoryDefault
implements EPServicesContextFactory {
    private static final Logger log = LoggerFactory.getLogger(EPServicesContextFactoryDefault.class);

    @Override
    public EPServicesContext createServicesContext(EPServiceProvider epServiceProvider, ConfigurationInformation configSnapshot) {
        EventTypeIdGenerator eventTypeIdGenerator;
        EngineEnvContext jndiContext = new EngineEnvContext();
        EngineImportService engineImportService = EPServicesContextFactoryDefault.makeEngineImportService(configSnapshot, AggregationFactoryFactoryDefault.INSTANCE, epServiceProvider.getURI());
        if (configSnapshot.getEngineDefaults().getAlternativeContext() == null || configSnapshot.getEngineDefaults().getAlternativeContext().getEventTypeIdGeneratorFactory() == null) {
            eventTypeIdGenerator = new EventTypeIdGeneratorImpl();
        } else {
            EventTypeIdGeneratorFactory eventTypeIdGeneratorFactory = (EventTypeIdGeneratorFactory)JavaClassHelper.instantiate(EventTypeIdGeneratorFactory.class, configSnapshot.getEngineDefaults().getAlternativeContext().getEventTypeIdGeneratorFactory(), engineImportService.getClassForNameProvider());
            eventTypeIdGenerator = eventTypeIdGeneratorFactory.create(new EventTypeIdGeneratorContext(epServiceProvider.getURI()));
        }
        EventAdapterAvroHandler avroHandler = EventAdapterAvroHandlerUnsupported.INSTANCE;
        if (configSnapshot.getEngineDefaults().getEventMeta().getAvroSettings().isEnableAvro()) {
            try {
                avroHandler = (EventAdapterAvroHandler)JavaClassHelper.instantiate(EventAdapterAvroHandler.class, "com.espertech.esper.avro.core.EventAdapterAvroHandlerImpl", engineImportService.getClassForNameProvider());
            }
            catch (Throwable t) {
                log.debug("Avro provider {} not instantiated, not enabling Avro support: {}", (Object)"com.espertech.esper.avro.core.EventAdapterAvroHandlerImpl", (Object)t.getMessage());
            }
            try {
                avroHandler.init(configSnapshot.getEngineDefaults().getEventMeta().getAvroSettings(), engineImportService);
            }
            catch (Throwable t) {
                throw new ConfigurationException("Failed to initialize Esper-Avro: " + t.getMessage(), t);
            }
        }
        EventAdapterServiceImpl eventAdapterService = new EventAdapterServiceImpl(eventTypeIdGenerator, configSnapshot.getEngineDefaults().getEventMeta().getAnonymousCacheSize(), avroHandler, engineImportService);
        EPServicesContextFactoryDefault.init(eventAdapterService, configSnapshot, engineImportService);
        ManagedReadWriteLock eventProcessingRWLock = new ManagedReadWriteLock("EventProcLock", false);
        TimeSourceService timeSourceService = EPServicesContextFactoryDefault.makeTimeSource(configSnapshot);
        SchedulingServiceSPI schedulingService = SchedulingServiceProvider.newService(timeSourceService);
        SchedulingMgmtServiceImpl schedulingMgmtService = new SchedulingMgmtServiceImpl();
        EngineSettingsService engineSettingsService = new EngineSettingsService(configSnapshot.getEngineDefaults(), configSnapshot.getPlugInEventTypeResolutionURIs());
        DatabaseConfigService databaseConfigService = EPServicesContextFactoryDefault.makeDatabaseRefService(configSnapshot, schedulingService, schedulingMgmtService, engineImportService);
        PluggableObjectCollection plugInViews = new PluggableObjectCollection();
        plugInViews.addViews(configSnapshot.getPlugInViews(), configSnapshot.getPlugInVirtualDataWindows(), engineImportService);
        PluggableObjectCollection plugInPatternObj = new PluggableObjectCollection();
        plugInPatternObj.addPatternObjects(configSnapshot.getPlugInPatternObjects(), engineImportService);
        ExceptionHandlingService exceptionHandlingService = EPServicesContextFactoryDefault.initExceptionHandling(epServiceProvider.getURI(), configSnapshot.getEngineDefaults().getExceptionHandling(), configSnapshot.getEngineDefaults().getConditionHandling(), engineImportService);
        Class systemVirtualDWViewFactory = null;
        if (configSnapshot.getEngineDefaults().getAlternativeContext().getVirtualDataWindowViewFactory() != null) {
            try {
                systemVirtualDWViewFactory = engineImportService.getClassForNameProvider().classForName(configSnapshot.getEngineDefaults().getAlternativeContext().getVirtualDataWindowViewFactory());
                if (!JavaClassHelper.isImplementsInterface(systemVirtualDWViewFactory, VirtualDataWindowFactory.class)) {
                    throw new ConfigurationException("Class " + systemVirtualDWViewFactory.getName() + " does not implement the interface " + VirtualDataWindowFactory.class.getName());
                }
            }
            catch (ClassNotFoundException e) {
                throw new ConfigurationException("Failed to look up class " + systemVirtualDWViewFactory);
            }
        }
        StatementContextFactoryDefault statementContextFactory = new StatementContextFactoryDefault(plugInViews, plugInPatternObj, systemVirtualDWViewFactory);
        long msecTimerResolution = configSnapshot.getEngineDefaults().getThreading().getInternalTimerMsecResolution();
        if (msecTimerResolution <= 0L) {
            throw new ConfigurationException("Timer resolution configuration not set to a valid value, expecting a non-zero value");
        }
        TimerServiceImpl timerService = new TimerServiceImpl(epServiceProvider.getURI(), msecTimerResolution);
        VariableServiceImpl variableService = new VariableServiceImpl(configSnapshot.getEngineDefaults().getVariables().getMsecVersionRelease(), schedulingService, eventAdapterService, null);
        EPServicesContextFactoryDefault.initVariables(variableService, configSnapshot.getVariables(), engineImportService);
        TableServiceImpl tableService = new TableServiceImpl();
        StatementLockFactoryImpl statementLockFactory = new StatementLockFactoryImpl(configSnapshot.getEngineDefaults().getExecution().isFairlock(), configSnapshot.getEngineDefaults().getExecution().isDisableLocking());
        StreamFactoryService streamFactoryService = StreamFactoryServiceProvider.newService(epServiceProvider.getURI(), configSnapshot.getEngineDefaults().getViewResources().isShareViews());
        FilterServiceSPI filterService = FilterServiceProvider.newService(configSnapshot.getEngineDefaults().getExecution().getFilterServiceProfile(), configSnapshot.getEngineDefaults().getExecution().isAllowIsolatedService());
        MetricReportingServiceImpl metricsReporting = new MetricReportingServiceImpl(configSnapshot.getEngineDefaults().getMetricsReporting(), epServiceProvider.getURI());
        NamedWindowMgmtServiceImpl namedWindowMgmtService = new NamedWindowMgmtServiceImpl(configSnapshot.getEngineDefaults().getLogging().isEnableQueryPlan(), metricsReporting);
        NamedWindowDispatchServiceImpl namedWindowDispatchService = new NamedWindowDispatchServiceImpl(schedulingService, variableService, tableService, engineSettingsService.getEngineSettings().getExecution().isPrioritized(), eventProcessingRWLock, exceptionHandlingService, metricsReporting);
        ValueAddEventServiceImpl valueAddEventService = new ValueAddEventServiceImpl();
        valueAddEventService.init(configSnapshot.getRevisionEventTypes(), configSnapshot.getVariantStreams(), eventAdapterService, eventTypeIdGenerator);
        StatementEventTypeRefImpl statementEventTypeRef = new StatementEventTypeRefImpl();
        StatementVariableRefImpl statementVariableRef = new StatementVariableRefImpl(variableService, tableService, namedWindowMgmtService);
        ThreadingServiceImpl threadingService = new ThreadingServiceImpl(configSnapshot.getEngineDefaults().getThreading());
        InternalEventRouterImpl internalEventRouterImpl = new InternalEventRouterImpl(epServiceProvider.getURI(), engineImportService);
        StatementIsolationServiceImpl statementIsolationService = new StatementIsolationServiceImpl();
        DeploymentStateServiceImpl deploymentStateService = new DeploymentStateServiceImpl();
        StatementMetadataFactory stmtMetadataFactory = configSnapshot.getEngineDefaults().getAlternativeContext().getStatementMetadataFactory() == null ? new StatementMetadataFactoryDefault() : (StatementMetadataFactory)JavaClassHelper.instantiate(StatementMetadataFactory.class, configSnapshot.getEngineDefaults().getAlternativeContext().getStatementMetadataFactory(), engineImportService.getClassForNameProvider());
        ContextManagementServiceImpl contextManagementService = new ContextManagementServiceImpl(engineImportService.getEngineURI());
        PatternSubexpressionPoolEngineSvc patternSubexpressionPoolSvc = null;
        if (configSnapshot.getEngineDefaults().getPatterns().getMaxSubexpressions() != null) {
            patternSubexpressionPoolSvc = new PatternSubexpressionPoolEngineSvc(configSnapshot.getEngineDefaults().getPatterns().getMaxSubexpressions(), configSnapshot.getEngineDefaults().getPatterns().isMaxSubexpressionPreventStart());
        }
        MatchRecognizeStatePoolEngineSvc matchRecognizeStatePoolEngineSvc = null;
        if (configSnapshot.getEngineDefaults().getMatchRecognize().getMaxStates() != null) {
            matchRecognizeStatePoolEngineSvc = new MatchRecognizeStatePoolEngineSvc(configSnapshot.getEngineDefaults().getMatchRecognize().getMaxStates(), configSnapshot.getEngineDefaults().getMatchRecognize().isMaxStatesPreventStart());
        }
        EPServicesContext services = new EPServicesContext(epServiceProvider.getURI(), schedulingService, eventAdapterService, engineImportService, engineSettingsService, databaseConfigService, plugInViews, statementLockFactory, eventProcessingRWLock, null, jndiContext, statementContextFactory, plugInPatternObj, timerService, filterService, streamFactoryService, namedWindowMgmtService, namedWindowDispatchService, variableService, tableService, timeSourceService, valueAddEventService, metricsReporting, statementEventTypeRef, statementVariableRef, configSnapshot, threadingService, internalEventRouterImpl, statementIsolationService, schedulingMgmtService, deploymentStateService, exceptionHandlingService, new PatternNodeFactoryImpl(), eventTypeIdGenerator, stmtMetadataFactory, contextManagementService, patternSubexpressionPoolSvc, matchRecognizeStatePoolEngineSvc, new DataFlowServiceImpl(epServiceProvider, new DataFlowConfigurationStateServiceImpl()), new ExprDeclaredServiceImpl(), new ContextControllerFactoryFactorySvcImpl(), new ContextManagerFactoryServiceImpl(), new EPStatementFactoryDefault(), new RegexHandlerFactoryDefault(), new ViewableActivatorFactoryDefault(), new FilterNonPropertyRegisteryServiceImpl(), new ResultSetProcessorHelperFactoryImpl(), new ViewServicePreviousFactoryImpl(), new EventTableIndexServiceImpl(), new EPRuntimeIsolatedFactoryImpl(), new FilterBooleanExpressionFactoryImpl(), new DataCacheFactory(), new MultiMatchHandlerFactoryImpl(), NamedWindowConsumerMgmtServiceImpl.INSTANCE, AggregationFactoryFactoryDefault.INSTANCE);
        statementContextFactory.setStmtEngineServices(services);
        StatementLifecycleSvcImpl statementLifecycleSvc = new StatementLifecycleSvcImpl(epServiceProvider, services);
        services.setStatementLifecycleSvc(statementLifecycleSvc);
        statementLifecycleSvc.addObserver(metricsReporting);
        statementIsolationService.setEpServicesContext(services);
        return services;
    }

    protected static ExceptionHandlingService initExceptionHandling(String engineURI, ConfigurationEngineDefaults.ExceptionHandling exceptionHandling, ConfigurationEngineDefaults.ConditionHandling conditionHandling, EngineImportService engineImportService) throws ConfigurationException {
        List<ConditionHandler> conditionHandlers;
        List<ExceptionHandler> exceptionHandlers;
        if (exceptionHandling.getHandlerFactories() == null || exceptionHandling.getHandlerFactories().isEmpty()) {
            exceptionHandlers = Collections.emptyList();
        } else {
            exceptionHandlers = new ArrayList();
            ExceptionHandlerFactoryContext context = new ExceptionHandlerFactoryContext(engineURI);
            for (String className : exceptionHandling.getHandlerFactories()) {
                try {
                    ExceptionHandlerFactory factory = (ExceptionHandlerFactory)JavaClassHelper.instantiate(ExceptionHandlerFactory.class, className, engineImportService.getClassForNameProvider());
                    ExceptionHandler handler = factory.getHandler(context);
                    if (handler == null) {
                        log.warn("Exception handler factory '" + className + "' returned a null handler, skipping factory");
                        continue;
                    }
                    exceptionHandlers.add(handler);
                }
                catch (RuntimeException ex) {
                    throw new ConfigurationException("Exception initializing exception handler from exception handler factory '" + className + "': " + ex.getMessage(), ex);
                }
            }
        }
        if (conditionHandling.getHandlerFactories() == null || conditionHandling.getHandlerFactories().isEmpty()) {
            conditionHandlers = Collections.emptyList();
        } else {
            conditionHandlers = new ArrayList();
            ConditionHandlerFactoryContext context = new ConditionHandlerFactoryContext(engineURI);
            for (String className : conditionHandling.getHandlerFactories()) {
                try {
                    ConditionHandlerFactory factory = (ConditionHandlerFactory)JavaClassHelper.instantiate(ConditionHandlerFactory.class, className, engineImportService.getClassForNameProvider());
                    ConditionHandler handler = factory.getHandler(context);
                    if (handler == null) {
                        log.warn("Condition handler factory '" + className + "' returned a null handler, skipping factory");
                        continue;
                    }
                    conditionHandlers.add(handler);
                }
                catch (RuntimeException ex) {
                    throw new ConfigurationException("Exception initializing exception handler from exception handler factory '" + className + "': " + ex.getMessage(), ex);
                }
            }
        }
        return new ExceptionHandlingService(engineURI, exceptionHandlers, conditionHandlers);
    }

    protected static TimeSourceService makeTimeSource(ConfigurationInformation configSnapshot) {
        if (configSnapshot.getEngineDefaults().getTimeSource().getTimeSourceType() == ConfigurationEngineDefaults.TimeSourceType.NANO) {
            TimeSourceServiceImpl.isSystemCurrentTime = false;
        }
        return new TimeSourceServiceImpl();
    }

    protected static void initVariables(VariableService variableService, Map<String, ConfigurationVariable> variables, EngineImportService engineImportService) {
        for (Map.Entry<String, ConfigurationVariable> entry : variables.entrySet()) {
            try {
                Pair<String, Boolean> arrayType = JavaClassHelper.isGetArrayType(entry.getValue().getType());
                variableService.createNewVariable(null, entry.getKey(), arrayType.getFirst(), entry.getValue().isConstant(), arrayType.getSecond(), false, entry.getValue().getInitializationValue(), engineImportService);
                variableService.allocateVariableState(entry.getKey(), -1, null, false);
            }
            catch (VariableExistsException e) {
                throw new ConfigurationException("Error configuring variables: " + e.getMessage(), e);
            }
            catch (VariableTypeException e) {
                throw new ConfigurationException("Error configuring variables: " + e.getMessage(), e);
            }
        }
    }

    protected static void init(EventAdapterService eventAdapterService, ConfigurationInformation configSnapshot, EngineImportService engineImportService) {
        Set<String> dependentObjectArrayOrder;
        Set<String> set;
        HashMap<String, ConfigurationEventTypeLegacy> classLegacyInfo = new HashMap<String, ConfigurationEventTypeLegacy>();
        for (Map.Entry<String, String> entry : configSnapshot.getEventTypeNames().entrySet()) {
            String string = entry.getKey();
            String string2 = entry.getValue();
            ConfigurationEventTypeLegacy configurationEventTypeLegacy = configSnapshot.getEventTypesLegacy().get(string);
            if (configurationEventTypeLegacy == null) continue;
            classLegacyInfo.put(string2, configurationEventTypeLegacy);
        }
        eventAdapterService.setClassLegacyConfigs(classLegacyInfo);
        eventAdapterService.setDefaultPropertyResolutionStyle(configSnapshot.getEngineDefaults().getEventMeta().getClassPropertyResolutionStyle());
        eventAdapterService.setDefaultAccessorStyle(configSnapshot.getEngineDefaults().getEventMeta().getDefaultAccessorStyle());
        for (String string : configSnapshot.getEventTypeAutoNamePackages()) {
            eventAdapterService.addAutoNamePackage(string);
        }
        Map<String, String> javaClassNames = configSnapshot.getEventTypeNames();
        for (Map.Entry<String, String> entry : javaClassNames.entrySet()) {
            try {
                String string = entry.getKey();
                eventAdapterService.addBeanType(string, entry.getValue(), false, true, true, true);
            }
            catch (EventAdapterException eventAdapterException) {
                throw new ConfigurationException("Error configuring engine: " + eventAdapterException.getMessage(), eventAdapterException);
            }
        }
        Map<String, ConfigurationEventTypeAvro> map = configSnapshot.getEventTypesAvro();
        for (Map.Entry<String, ConfigurationEventTypeAvro> entry : map.entrySet()) {
            try {
                eventAdapterService.addAvroType(entry.getKey(), entry.getValue(), true, true, true, false, false);
            }
            catch (EventAdapterException eventAdapterException) {
                throw new ConfigurationException("Error configuring engine: " + eventAdapterException.getMessage(), eventAdapterException);
            }
        }
        Map<String, ConfigurationEventTypeXMLDOM> map2 = configSnapshot.getEventTypesXMLDOM();
        for (Map.Entry<String, ConfigurationEventTypeXMLDOM> entry : map2.entrySet()) {
            SchemaModel schemaModel = null;
            if (entry.getValue().getSchemaResource() != null || entry.getValue().getSchemaText() != null) {
                try {
                    schemaModel = XSDSchemaMapper.loadAndMap(entry.getValue().getSchemaResource(), entry.getValue().getSchemaText(), engineImportService);
                }
                catch (Exception ex) {
                    throw new ConfigurationException(ex.getMessage(), ex);
                }
            }
            try {
                eventAdapterService.addXMLDOMType(entry.getKey(), entry.getValue(), schemaModel, true);
            }
            catch (EventAdapterException ex) {
                throw new ConfigurationException("Error configuring engine: " + ex.getMessage(), ex);
            }
        }
        try {
            Map<String, Set<String>> map3 = EPServicesContextFactoryDefault.toTypesReferences(configSnapshot.getMapTypeConfigurations());
            set = GraphUtil.getTopDownOrder(map3);
        }
        catch (GraphCircularDependencyException graphCircularDependencyException) {
            throw new ConfigurationException("Error configuring engine, dependency graph between map type names is circular: " + graphCircularDependencyException.getMessage(), graphCircularDependencyException);
        }
        Map<String, Properties> map4 = configSnapshot.getEventTypesMapEvents();
        Map<String, Map<String, Object>> nestableMapNames = configSnapshot.getEventTypesNestableMapEvents();
        set.addAll(map4.keySet());
        set.addAll(nestableMapNames.keySet());
        try {
            for (String mapName : set) {
                Map<String, Object> map5;
                ConfigurationEventTypeMap mapConfig = configSnapshot.getMapTypeConfigurations().get(mapName);
                Properties properties = map4.get(mapName);
                if (properties != null) {
                    Map<String, Object> map6 = EPServicesContextFactoryDefault.createPropertyTypes(properties, engineImportService);
                    Map<String, Object> propertyTypesCompiled = EventTypeUtility.compileMapTypeProperties(map6, eventAdapterService);
                    eventAdapterService.addNestableMapType(mapName, propertyTypesCompiled, mapConfig, true, true, true, false, false);
                }
                if ((map5 = nestableMapNames.get(mapName)) == null) continue;
                Map<String, Object> propertiesNestableCompiled = EventTypeUtility.compileMapTypeProperties(map5, eventAdapterService);
                eventAdapterService.addNestableMapType(mapName, propertiesNestableCompiled, mapConfig, true, true, true, false, false);
            }
        }
        catch (EventAdapterException ex) {
            throw new ConfigurationException("Error configuring engine: " + ex.getMessage(), ex);
        }
        try {
            Map<String, Set<String>> typesReferences = EPServicesContextFactoryDefault.toTypesReferences(configSnapshot.getObjectArrayTypeConfigurations());
            dependentObjectArrayOrder = GraphUtil.getTopDownOrder(typesReferences);
        }
        catch (GraphCircularDependencyException e) {
            throw new ConfigurationException("Error configuring engine, dependency graph between object array type names is circular: " + e.getMessage(), e);
        }
        Map<String, Map<String, Object>> nestableObjectArrayNames = configSnapshot.getEventTypesNestableObjectArrayEvents();
        dependentObjectArrayOrder.addAll(nestableObjectArrayNames.keySet());
        try {
            for (String string : dependentObjectArrayOrder) {
                ConfigurationEventTypeObjectArray configurationEventTypeObjectArray = configSnapshot.getObjectArrayTypeConfigurations().get(string);
                Map<String, Object> propertyTypes = nestableObjectArrayNames.get(string);
                propertyTypes = EPServicesContextFactoryDefault.resolveClassesForStringPropertyTypes(propertyTypes, engineImportService);
                Map<String, Object> propertyTypesCompiled = EventTypeUtility.compileMapTypeProperties(propertyTypes, eventAdapterService);
                eventAdapterService.addNestableObjectArrayType(string, propertyTypesCompiled, configurationEventTypeObjectArray, true, true, true, false, false, false, null);
            }
        }
        catch (EventAdapterException ex) {
            throw new ConfigurationException("Error configuring engine: " + ex.getMessage(), ex);
        }
        Map<URI, ConfigurationPlugInEventRepresentation> plugInReps = configSnapshot.getPlugInEventRepresentation();
        for (Map.Entry<URI, ConfigurationPlugInEventRepresentation> entry : plugInReps.entrySet()) {
            Object pluginEventRepObj;
            Class eventRepClass;
            String className = entry.getValue().getEventRepresentationClassName();
            try {
                eventRepClass = engineImportService.getClassForNameProvider().classForName(className);
            }
            catch (ClassNotFoundException ex) {
                throw new ConfigurationException("Failed to load plug-in event representation class '" + className + "'", ex);
            }
            try {
                pluginEventRepObj = eventRepClass.newInstance();
            }
            catch (InstantiationException ex) {
                throw new ConfigurationException("Failed to instantiate plug-in event representation class '" + className + "' via default constructor", ex);
            }
            catch (IllegalAccessException ex) {
                throw new ConfigurationException("Illegal access to instantiate plug-in event representation class '" + className + "' via default constructor", ex);
            }
            if (!(pluginEventRepObj instanceof PlugInEventRepresentation)) {
                throw new ConfigurationException("Plug-in event representation class '" + className + "' does not implement the required interface " + PlugInEventRepresentation.class.getName());
            }
            URI eventRepURI = entry.getKey();
            PlugInEventRepresentation pluginEventRep = (PlugInEventRepresentation)pluginEventRepObj;
            Serializable initializer = entry.getValue().getInitializer();
            PlugInEventRepresentationContext context = new PlugInEventRepresentationContext(eventAdapterService, eventRepURI, initializer);
            try {
                pluginEventRep.init(context);
                eventAdapterService.addEventRepresentation(eventRepURI, pluginEventRep);
            }
            catch (Throwable t) {
                throw new ConfigurationException("Plug-in event representation class '" + className + "' and URI '" + eventRepURI + "' did not initialize correctly : " + t.getMessage(), t);
            }
        }
        Map<String, ConfigurationPlugInEventType> map7 = configSnapshot.getPlugInEventTypes();
        for (Map.Entry<String, ConfigurationPlugInEventType> entry : map7.entrySet()) {
            String name = entry.getKey();
            ConfigurationPlugInEventType config = entry.getValue();
            eventAdapterService.addPlugInEventType(name, config.getEventRepresentationResolutionURIs(), config.getInitializer());
        }
    }

    private static Map<String, Set<String>> toTypesReferences(Map<String, ? extends ConfigurationEventTypeWithSupertype> mapTypeConfigurations) {
        LinkedHashMap<String, Set<String>> result = new LinkedHashMap<String, Set<String>>();
        for (Map.Entry<String, ? extends ConfigurationEventTypeWithSupertype> entry : mapTypeConfigurations.entrySet()) {
            result.put(entry.getKey(), entry.getValue().getSuperTypes());
        }
        return result;
    }

    protected static EngineImportService makeEngineImportService(ConfigurationInformation configSnapshot, AggregationFactoryFactory aggregationFactoryFactory, String engineURI) {
        TimeAbacus timeAbacus;
        TimeUnit timeUnit = configSnapshot.getEngineDefaults().getTimeSource().getTimeUnit();
        if (timeUnit == TimeUnit.MILLISECONDS) {
            timeAbacus = TimeAbacusMilliseconds.INSTANCE;
        } else if (timeUnit == TimeUnit.MICROSECONDS) {
            timeAbacus = TimeAbacusMicroseconds.INSTANCE;
        } else {
            throw new ConfigurationException("Invalid time-source time unit of " + (Object)((Object)timeUnit) + ", expected millis or micros");
        }
        CodegenCompilerJanino codegenCompiler = null;
        if (configSnapshot.getEngineDefaults().getByteCodeGeneration().isEnabledAny()) {
            codegenCompiler = new CodegenCompilerJanino(engineURI, configSnapshot.getEngineDefaults().getLogging().isEnableCode(), configSnapshot.getEngineDefaults().getByteCodeGeneration().isIncludeDebugSymbols());
        }
        ConfigurationEngineDefaults.Expression expression = configSnapshot.getEngineDefaults().getExpression();
        EngineImportServiceImpl engineImportService = new EngineImportServiceImpl(expression.isExtendedAggregation(), expression.isUdfCache(), expression.isDuckTyping(), configSnapshot.getEngineDefaults().getLanguage().isSortUsingCollator(), configSnapshot.getEngineDefaults().getExpression().getMathContext(), configSnapshot.getEngineDefaults().getExpression().getTimeZone(), timeAbacus, configSnapshot.getEngineDefaults().getExecution().getThreadingProfile(), configSnapshot.getTransientConfiguration(), aggregationFactoryFactory, configSnapshot.getEngineDefaults().getByteCodeGeneration(), engineURI, codegenCompiler);
        engineImportService.addMethodRefs(configSnapshot.getMethodInvocationReferences());
        try {
            for (String string : configSnapshot.getImports()) {
                engineImportService.addImport(string);
            }
            for (String string : configSnapshot.getAnnotationImports()) {
                engineImportService.addAnnotationImport(string);
            }
            for (ConfigurationPlugInAggregationFunction configurationPlugInAggregationFunction : configSnapshot.getPlugInAggregationFunctions()) {
                engineImportService.addAggregation(configurationPlugInAggregationFunction.getName(), configurationPlugInAggregationFunction);
            }
            for (ConfigurationPlugInAggregationMultiFunction configurationPlugInAggregationMultiFunction : configSnapshot.getPlugInAggregationMultiFunctions()) {
                engineImportService.addAggregationMultiFunction(configurationPlugInAggregationMultiFunction);
            }
            for (ConfigurationPlugInSingleRowFunction configurationPlugInSingleRowFunction : configSnapshot.getPlugInSingleRowFunctions()) {
                engineImportService.addSingleRow(configurationPlugInSingleRowFunction.getName(), configurationPlugInSingleRowFunction.getFunctionClassName(), configurationPlugInSingleRowFunction.getFunctionMethodName(), configurationPlugInSingleRowFunction.getValueCache(), configurationPlugInSingleRowFunction.getFilterOptimizable(), configurationPlugInSingleRowFunction.isRethrowExceptions(), configurationPlugInSingleRowFunction.getEventTypeName());
            }
        }
        catch (EngineImportException ex) {
            throw new ConfigurationException("Error configuring engine: " + ex.getMessage(), ex);
        }
        return engineImportService;
    }

    protected static DatabaseConfigService makeDatabaseRefService(ConfigurationInformation configSnapshot, SchedulingService schedulingService, SchedulingMgmtService schedulingMgmtService, EngineImportService engineImportService) {
        DatabaseConfigServiceImpl databaseConfigService;
        try {
            ScheduleBucket allStatementsBucket = schedulingMgmtService.allocateBucket();
            databaseConfigService = new DatabaseConfigServiceImpl(configSnapshot.getDatabaseReferences(), schedulingService, allStatementsBucket, engineImportService);
        }
        catch (IllegalArgumentException ex) {
            throw new ConfigurationException("Error configuring engine: " + ex.getMessage(), ex);
        }
        return databaseConfigService;
    }

    private static Map<String, Object> createPropertyTypes(Properties properties, EngineImportService engineImportService) {
        LinkedHashMap<String, Object> propertyTypes = new LinkedHashMap<String, Object>();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String property = (String)entry.getKey();
            String className = (String)entry.getValue();
            Class clazz = EPServicesContextFactoryDefault.resolveClassForTypeName(className, engineImportService);
            if (clazz == null) continue;
            propertyTypes.put(property, clazz);
        }
        return propertyTypes;
    }

    private static Map<String, Object> resolveClassesForStringPropertyTypes(Map<String, Object> properties, EngineImportService engineImportService) {
        LinkedHashMap<String, Object> propertyTypes = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            String className;
            Class clazz;
            String property = entry.getKey();
            propertyTypes.put(property, entry.getValue());
            if (!(entry.getValue() instanceof String) || (clazz = EPServicesContextFactoryDefault.resolveClassForTypeName(className = (String)entry.getValue(), engineImportService)) == null) continue;
            propertyTypes.put(property, clazz);
        }
        return propertyTypes;
    }

    private static Class resolveClassForTypeName(String type, EngineImportService engineImportService) {
        boolean isArray = false;
        if (type != null && EventTypeUtility.isPropertyArray(type)) {
            isArray = true;
            type = EventTypeUtility.getPropertyRemoveArray(type);
        }
        if (type == null) {
            throw new ConfigurationException("A null value has been provided for the type");
        }
        Class<?> clazz = JavaClassHelper.getClassForSimpleName(type, engineImportService.getClassForNameProvider());
        if (clazz == null) {
            throw new ConfigurationException("The type '" + type + "' is not a recognized type");
        }
        if (isArray) {
            clazz = Array.newInstance(clazz, 0).getClass();
        }
        return clazz;
    }
}

