/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.service;

import com.espertech.esper.client.EPException;
import com.espertech.esper.client.EPStatement;
import com.espertech.esper.client.EPSubscriberException;
import com.espertech.esper.core.service.DeliveryConvertor;
import com.espertech.esper.core.service.DeliveryConvertorMap;
import com.espertech.esper.core.service.DeliveryConvertorMapWStatement;
import com.espertech.esper.core.service.DeliveryConvertorNull;
import com.espertech.esper.core.service.DeliveryConvertorNullWStatement;
import com.espertech.esper.core.service.DeliveryConvertorObjectArr;
import com.espertech.esper.core.service.DeliveryConvertorObjectArrWStatement;
import com.espertech.esper.core.service.DeliveryConvertorWidener;
import com.espertech.esper.core.service.DeliveryConvertorWidenerWStatement;
import com.espertech.esper.core.service.ResultDeliveryStrategy;
import com.espertech.esper.core.service.ResultDeliveryStrategyImpl;
import com.espertech.esper.core.service.ResultDeliveryStrategyMap;
import com.espertech.esper.core.service.ResultDeliveryStrategyMapWStmt;
import com.espertech.esper.core.service.ResultDeliveryStrategyObjectArr;
import com.espertech.esper.core.service.ResultDeliveryStrategyObjectArrWStmt;
import com.espertech.esper.core.service.ResultDeliveryStrategyTypeArr;
import com.espertech.esper.core.service.ResultDeliveryStrategyTypeArrWStmt;
import com.espertech.esper.epl.core.engineimport.EngineImportService;
import com.espertech.esper.util.JavaClassHelper;
import com.espertech.esper.util.TypeWidener;
import com.espertech.esper.util.TypeWidenerException;
import com.espertech.esper.util.TypeWidenerFactory;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ResultDeliveryStrategyFactory {
    private static final Comparator<? super Method> METHOD_PREFERECE_COMPARATOR = new Comparator<Method>(){

        @Override
        public int compare(Method o1, Method o2) {
            int v2;
            int v1 = this.value(o1);
            return v1 > (v2 = this.value(o2)) ? 1 : (v1 == v2 ? 0 : -1);
        }

        private int value(Method m) {
            return ResultDeliveryStrategyFactory.isFirstParameterEPStatement(m) ? 0 : 1;
        }
    };

    /*
     * WARNING - void declaration
     */
    public static ResultDeliveryStrategy create(EPStatement statement, Object subscriber, String methodName, Class[] selectClauseTypes, String[] selectClauseColumns, String engineURI, EngineImportService engineImportService) throws EPSubscriberException {
        void var17_35;
        DeliveryConvertor convertor;
        Class boxedExpressionType;
        int i;
        boolean fits;
        if (selectClauseTypes == null) {
            selectClauseTypes = new Class[]{};
            selectClauseColumns = new String[]{};
        }
        if (methodName == null) {
            methodName = "update";
        }
        List<Method> sorted = Arrays.asList(subscriber.getClass().getMethods());
        Collections.sort(sorted, METHOD_PREFERECE_COMPARATOR);
        Method subscriptionMethod = null;
        LinkedHashMap<Method, Class[]> updateMethods = new LinkedHashMap<Method, Class[]>();
        for (Method method : sorted) {
            if (!method.getName().equals(methodName) || !Modifier.isPublic(method.getModifiers())) continue;
            Class[] normalizedParameters = ResultDeliveryStrategyFactory.getMethodParameterTypesWithoutEPStatement(method);
            updateMethods.put(method, normalizedParameters);
        }
        if (updateMethods.size() == 0) {
            String message = "Subscriber object does not provide a public method by name 'update'";
            throw new EPSubscriberException(message);
        }
        boolean isMapArrayDelivery = false;
        boolean isObjectArrayDelivery = false;
        boolean isSingleRowMap = false;
        boolean isSingleRowObjectArr = false;
        boolean isTypeArrayDelivery = false;
        for (Map.Entry methodNormParameterEntry : updateMethods.entrySet()) {
            Class[] classArray = (Class[])methodNormParameterEntry.getValue();
            if (classArray.length != selectClauseTypes.length) continue;
            fits = true;
            for (i = 0; i < classArray.length; ++i) {
                if (selectClauseTypes[i] == null || selectClauseTypes[i] == classArray[i]) continue;
                fits = false;
                break;
            }
            if (!fits) continue;
            subscriptionMethod = (Method)methodNormParameterEntry.getKey();
            break;
        }
        if (subscriptionMethod == null) {
            for (Map.Entry methodNormParameterEntry : updateMethods.entrySet()) {
                Class[] classArray = (Class[])methodNormParameterEntry.getValue();
                if (classArray.length != selectClauseTypes.length) continue;
                fits = true;
                for (i = 0; i < classArray.length; ++i) {
                    boxedExpressionType = JavaClassHelper.getBoxedType(selectClauseTypes[i]);
                    Class boxedParameterType = JavaClassHelper.getBoxedType(classArray[i]);
                    if (boxedExpressionType == null || boxedExpressionType == boxedParameterType) continue;
                    fits = false;
                    break;
                }
                if (!fits) continue;
                subscriptionMethod = (Method)methodNormParameterEntry.getKey();
                break;
            }
        }
        boolean checkWidening = false;
        if (subscriptionMethod == null) {
            for (Map.Entry entry : updateMethods.entrySet()) {
                Class[] normalized2 = (Class[])entry.getValue();
                if (normalized2.length != selectClauseTypes.length) continue;
                boolean fits2 = true;
                for (int i2 = 0; i2 < normalized2.length; ++i2) {
                    Class boxedExpressionType2 = JavaClassHelper.getBoxedType(selectClauseTypes[i2]);
                    Class boxedParameterType2 = JavaClassHelper.getBoxedType(normalized2[i2]);
                    if (boxedExpressionType2 == null || JavaClassHelper.isAssignmentCompatible(boxedExpressionType2, boxedParameterType2)) continue;
                    fits2 = false;
                    break;
                }
                if (!fits2) continue;
                subscriptionMethod = (Method)entry.getKey();
                checkWidening = true;
                break;
            }
        }
        if (subscriptionMethod == null) {
            for (Map.Entry entry : updateMethods.entrySet()) {
                Class<?> componentType;
                Class[] normalized3 = (Class[])entry.getValue();
                if (normalized3.length == 1 && normalized3[0] == Map.class) {
                    isSingleRowMap = true;
                    subscriptionMethod = (Method)entry.getKey();
                    break;
                }
                if (normalized3.length == 1 && normalized3[0] == Object[].class) {
                    isSingleRowObjectArr = true;
                    subscriptionMethod = (Method)entry.getKey();
                    break;
                }
                if (normalized3.length == 2 && normalized3[0] == Map[].class && normalized3[1] == Map[].class) {
                    subscriptionMethod = (Method)entry.getKey();
                    isMapArrayDelivery = true;
                    break;
                }
                if (normalized3.length == 2 && normalized3[0] == Object[][].class && normalized3[1] == Object[][].class) {
                    subscriptionMethod = (Method)entry.getKey();
                    isObjectArrayDelivery = true;
                    break;
                }
                if (normalized3.length == 2 && normalized3[0].equals(normalized3[1]) && normalized3[0].isArray() && selectClauseTypes.length == 1 && JavaClassHelper.isAssignmentCompatible(selectClauseTypes[0], componentType = normalized3[0].getComponentType())) {
                    subscriptionMethod = (Method)entry.getKey();
                    isTypeArrayDelivery = true;
                    break;
                }
                if (normalized3.length != 0 || selectClauseTypes.length != 1 || selectClauseTypes[0] != null) continue;
                subscriptionMethod = (Method)entry.getKey();
            }
        }
        if (subscriptionMethod == null) {
            if (updateMethods.size() > 1) {
                String parametersDesc = JavaClassHelper.getParameterAsString(selectClauseTypes);
                String string = "No suitable subscriber method named 'update' found, expecting a method that takes " + selectClauseTypes.length + " parameter of type " + parametersDesc;
                throw new EPSubscriberException(string);
            }
            Map.Entry firstUpdateMethod = updateMethods.entrySet().iterator().next();
            Class[] classArray = (Class[])firstUpdateMethod.getValue();
            String parametersDescNormalized = JavaClassHelper.getParameterAsString(selectClauseTypes);
            if (classArray.length != selectClauseTypes.length) {
                if (selectClauseTypes.length > 0) {
                    String message = "No suitable subscriber method named 'update' found, expecting a method that takes " + selectClauseTypes.length + " parameter of type " + parametersDescNormalized;
                    throw new EPSubscriberException(message);
                }
                String message = "No suitable subscriber method named 'update' found, expecting a method that takes no parameters";
                throw new EPSubscriberException(message);
            }
            for (int i3 = 0; i3 < classArray.length; ++i3) {
                boxedExpressionType = JavaClassHelper.getBoxedType(selectClauseTypes[i3]);
                Class boxedParameterType3 = JavaClassHelper.getBoxedType(classArray[i3]);
                if (boxedExpressionType == null || JavaClassHelper.isAssignmentCompatible(boxedExpressionType, boxedParameterType3)) continue;
                String message = "Subscriber method named 'update' for parameter number " + (i3 + 1) + " is not assignable, expecting type '" + JavaClassHelper.getParameterAsString(selectClauseTypes[i3]) + "' but found type '" + JavaClassHelper.getParameterAsString(classArray[i3]) + "'";
                throw new EPSubscriberException(message);
            }
        }
        boolean firstParameterIsEPStatement = ResultDeliveryStrategyFactory.isFirstParameterEPStatement(subscriptionMethod);
        if (isMapArrayDelivery) {
            return firstParameterIsEPStatement ? new ResultDeliveryStrategyMapWStmt(statement, subscriber, subscriptionMethod, selectClauseColumns, engineImportService) : new ResultDeliveryStrategyMap(statement, subscriber, subscriptionMethod, selectClauseColumns, engineImportService);
        }
        if (isObjectArrayDelivery) {
            return firstParameterIsEPStatement ? new ResultDeliveryStrategyObjectArrWStmt(statement, subscriber, subscriptionMethod, engineImportService) : new ResultDeliveryStrategyObjectArr(statement, subscriber, subscriptionMethod, engineImportService);
        }
        if (isTypeArrayDelivery) {
            return firstParameterIsEPStatement ? new ResultDeliveryStrategyTypeArrWStmt(statement, subscriber, subscriptionMethod, subscriptionMethod.getParameterTypes()[1].getComponentType(), engineImportService) : new ResultDeliveryStrategyTypeArr(statement, subscriber, subscriptionMethod, subscriptionMethod.getParameterTypes()[0].getComponentType(), engineImportService);
        }
        Object var17_32 = null;
        Method endMethod = null;
        Method rStreamMethod = null;
        try {
            Method method = subscriber.getClass().getMethod("updateStart", EPStatement.class, Integer.TYPE, Integer.TYPE);
        }
        catch (NoSuchMethodException e) {
            try {
                Method method = subscriber.getClass().getMethod("updateStart", Integer.TYPE, Integer.TYPE);
            }
            catch (NoSuchMethodException boxedParameterType3) {
                // empty catch block
            }
        }
        try {
            endMethod = subscriber.getClass().getMethod("updateEnd", EPStatement.class);
        }
        catch (NoSuchMethodException e) {
            try {
                endMethod = subscriber.getClass().getMethod("updateEnd", new Class[0]);
            }
            catch (NoSuchMethodException boxedParameterType3) {
                // empty catch block
            }
        }
        try {
            rStreamMethod = subscriber.getClass().getMethod("updateRStream", subscriptionMethod.getParameterTypes());
        }
        catch (NoSuchMethodException e) {
            Class[] classes;
            if (ResultDeliveryStrategyFactory.isFirstParameterEPStatement(subscriptionMethod)) {
                classes = (Class[])updateMethods.get(subscriptionMethod);
                ResultDeliveryStrategyFactory.validateNonMatchUpdateRStream(subscriber, classes);
            }
            classes = new Class[subscriptionMethod.getParameterTypes().length + 1];
            classes[0] = EPStatement.class;
            System.arraycopy(subscriptionMethod.getParameterTypes(), 0, classes, 1, subscriptionMethod.getParameterTypes().length);
            ResultDeliveryStrategyFactory.validateNonMatchUpdateRStream(subscriber, classes);
        }
        if (isSingleRowMap) {
            convertor = firstParameterIsEPStatement ? new DeliveryConvertorMapWStatement(selectClauseColumns, statement) : new DeliveryConvertorMap(selectClauseColumns);
        } else if (isSingleRowObjectArr) {
            convertor = firstParameterIsEPStatement ? new DeliveryConvertorObjectArrWStatement(statement) : DeliveryConvertorObjectArr.INSTANCE;
        } else if (checkWidening) {
            Class[] normalizedParameters = (Class[])updateMethods.get(subscriptionMethod);
            convertor = ResultDeliveryStrategyFactory.determineWideningDeliveryConvertor(firstParameterIsEPStatement, statement, selectClauseTypes, normalizedParameters, subscriptionMethod, engineURI);
        } else {
            convertor = firstParameterIsEPStatement ? new DeliveryConvertorNullWStatement(statement) : DeliveryConvertorNull.INSTANCE;
        }
        return new ResultDeliveryStrategyImpl(statement, subscriber, convertor, subscriptionMethod, (Method)var17_35, endMethod, rStreamMethod, engineImportService);
    }

    private static DeliveryConvertor determineWideningDeliveryConvertor(boolean firstParameterIsEPStatement, EPStatement statement, Class[] selectClauseTypes, Class[] parameterTypes, Method method, String engineURI) {
        boolean needWidener = false;
        for (int i = 0; i < selectClauseTypes.length; ++i) {
            TypeWidener optionalWidener = ResultDeliveryStrategyFactory.getWidener(i, selectClauseTypes[i], parameterTypes[i], method, statement.getName(), engineURI);
            if (optionalWidener == null) continue;
            needWidener = true;
            break;
        }
        if (!needWidener) {
            return firstParameterIsEPStatement ? new DeliveryConvertorNullWStatement(statement) : DeliveryConvertorNull.INSTANCE;
        }
        TypeWidener[] wideners = new TypeWidener[selectClauseTypes.length];
        for (int i = 0; i < selectClauseTypes.length; ++i) {
            wideners[i] = ResultDeliveryStrategyFactory.getWidener(i, selectClauseTypes[i], parameterTypes[i], method, statement.getName(), engineURI);
        }
        return firstParameterIsEPStatement ? new DeliveryConvertorWidenerWStatement(wideners, statement) : new DeliveryConvertorWidener(wideners);
    }

    private static TypeWidener getWidener(int columnNum, Class selectClauseType, Class parameterType, Method method, String statementName, String engineURI) {
        if (selectClauseType == null || parameterType == null) {
            return null;
        }
        if (selectClauseType == parameterType) {
            return null;
        }
        try {
            return TypeWidenerFactory.getCheckPropertyAssignType("Select-Clause Column " + columnNum, selectClauseType, parameterType, "Method Parameter " + columnNum, false, null, statementName, engineURI);
        }
        catch (TypeWidenerException e) {
            throw new EPException("Unexpected exception assigning select clause columns to subscriber method " + method + ": " + e.getMessage(), e);
        }
    }

    private static void validateNonMatchUpdateRStream(Object subscriber, Class[] classes) {
        try {
            Method m = subscriber.getClass().getMethod("updateRStream", classes);
            if (m != null) {
                throw new EPSubscriberException("Subscriber 'updateRStream' method footprint must match 'update' method footprint");
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    private static Class[] getMethodParameterTypesWithoutEPStatement(Method method) {
        Class[] parameterTypes = method.getParameterTypes();
        if (parameterTypes.length == 0 || parameterTypes[0] != EPStatement.class) {
            return parameterTypes;
        }
        Class[] normalized = new Class[parameterTypes.length - 1];
        System.arraycopy(parameterTypes, 1, normalized, 0, parameterTypes.length - 1);
        return normalized;
    }

    private static boolean isFirstParameterEPStatement(Method method) {
        return method.getParameterTypes().length > 0 && method.getParameterTypes()[0] == EPStatement.class;
    }
}

