/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.service;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.StatementAwareUpdateListener;
import com.espertech.esper.client.UpdateListener;
import com.espertech.esper.collection.MultiKeyUntyped;
import com.espertech.esper.collection.UniformPair;
import com.espertech.esper.core.service.EPServiceProviderSPI;
import com.espertech.esper.core.service.EPStatementListenerSet;
import com.espertech.esper.core.service.EPStatementSPI;
import com.espertech.esper.core.service.ResultDeliveryStrategy;
import com.espertech.esper.core.service.ResultDeliveryStrategyFactory;
import com.espertech.esper.core.service.StatementLifecycleSvc;
import com.espertech.esper.core.service.StatementResultListener;
import com.espertech.esper.core.service.StatementResultService;
import com.espertech.esper.core.thread.OutboundUnitRunnable;
import com.espertech.esper.core.thread.ThreadingOption;
import com.espertech.esper.core.thread.ThreadingService;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.metric.MetricReportingPath;
import com.espertech.esper.epl.metric.MetricReportingService;
import com.espertech.esper.epl.metric.MetricReportingServiceSPI;
import com.espertech.esper.epl.metric.StatementMetricHandle;
import com.espertech.esper.event.EventBeanUtility;
import com.espertech.esper.event.NaturalEventBean;
import com.espertech.esper.util.AuditPath;
import com.espertech.esper.util.ExecutionPathDebugLog;
import com.espertech.esper.view.ViewSupport;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatementResultServiceImpl
implements StatementResultService {
    private static final Logger log = LoggerFactory.getLogger(StatementResultServiceImpl.class);
    private final String statementName;
    private final StatementLifecycleSvc statementLifecycleSvc;
    private final MetricReportingService metricReportingService;
    private final ThreadingService threadingService;
    private EPStatementSPI epStatement;
    private EPServiceProviderSPI epServiceProvider;
    private boolean isInsertInto;
    private boolean isPattern;
    private boolean isDistinct;
    private boolean isForClause;
    private StatementMetricHandle statementMetricHandle;
    private boolean forClauseDelivery = false;
    private ExprEvaluator[] groupDeliveryExpressions;
    private ExprEvaluatorContext exprEvaluatorContext;
    private Class[] selectClauseTypes;
    private String[] selectClauseColumnNames;
    private EPStatementListenerSet statementListenerSet;
    private boolean isMakeNatural;
    private boolean isMakeSynthetic;
    private ResultDeliveryStrategy statementResultNaturalStrategy;
    private Set<StatementResultListener> statementOutputHooks;
    protected ThreadLocal<ArrayDeque<UniformPair<EventBean[]>>> lastResults = new ThreadLocal<ArrayDeque<UniformPair<EventBean[]>>>(){

        @Override
        protected synchronized ArrayDeque<UniformPair<EventBean[]>> initialValue() {
            return new ArrayDeque<UniformPair<EventBean[]>>();
        }
    };

    public StatementResultServiceImpl(String statementName, StatementLifecycleSvc statementLifecycleSvc, MetricReportingServiceSPI metricReportingService, ThreadingService threadingService) {
        log.debug(".ctor");
        this.statementName = statementName;
        this.statementLifecycleSvc = statementLifecycleSvc;
        this.metricReportingService = metricReportingService;
        this.statementOutputHooks = metricReportingService != null ? metricReportingService.getStatementOutputHooks() : Collections.EMPTY_SET;
        this.threadingService = threadingService;
    }

    @Override
    public void setContext(EPStatementSPI epStatement, EPServiceProviderSPI epServiceProvider, boolean isInsertInto, boolean isPattern, boolean isDistinct, boolean isForClause, StatementMetricHandle statementMetricHandle) {
        this.epStatement = epStatement;
        this.epServiceProvider = epServiceProvider;
        this.isInsertInto = isInsertInto;
        this.isPattern = isPattern;
        this.isDistinct = isDistinct;
        this.isForClause = isForClause;
        this.isMakeSynthetic = isInsertInto || isPattern || isDistinct || isForClause;
        this.statementMetricHandle = statementMetricHandle;
    }

    @Override
    public void setSelectClause(Class[] selectClauseTypes, String[] selectClauseColumnNames, boolean forClauseDelivery, ExprEvaluator[] groupDeliveryExpressions, ExprEvaluatorContext exprEvaluatorContext) {
        if (selectClauseTypes == null || selectClauseTypes.length == 0) {
            throw new IllegalArgumentException("Invalid null or zero-element list of select clause expression types");
        }
        if (selectClauseColumnNames == null || selectClauseColumnNames.length == 0) {
            throw new IllegalArgumentException("Invalid null or zero-element list of select clause column names");
        }
        this.selectClauseTypes = selectClauseTypes;
        this.selectClauseColumnNames = selectClauseColumnNames;
        this.forClauseDelivery = forClauseDelivery;
        this.exprEvaluatorContext = exprEvaluatorContext;
        this.groupDeliveryExpressions = groupDeliveryExpressions;
    }

    @Override
    public int getStatementId() {
        return this.epStatement.getStatementId();
    }

    @Override
    public boolean isMakeSynthetic() {
        return this.isMakeSynthetic;
    }

    @Override
    public boolean isMakeNatural() {
        return this.isMakeNatural;
    }

    @Override
    public String getStatementName() {
        return this.statementName;
    }

    @Override
    public EPStatementListenerSet getStatementListenerSet() {
        return this.statementListenerSet;
    }

    @Override
    public void setUpdateListeners(EPStatementListenerSet updateListeners, boolean isRecovery) {
        if (this.epStatement != null) {
            this.statementLifecycleSvc.updatedListeners(this.epStatement, updateListeners, isRecovery);
        }
        this.statementListenerSet = updateListeners;
        this.isMakeNatural = this.statementListenerSet.getSubscriber() != null;
        boolean bl = this.isMakeSynthetic = this.statementListenerSet.getListeners().length != 0 || this.statementListenerSet.getStmtAwareListeners().length != 0 || this.isPattern || this.isInsertInto || this.isDistinct | this.isForClause;
        if (this.statementListenerSet.getSubscriber() == null) {
            this.statementResultNaturalStrategy = null;
            this.isMakeNatural = false;
            return;
        }
        this.statementResultNaturalStrategy = ResultDeliveryStrategyFactory.create(this.epStatement, this.statementListenerSet.getSubscriber(), this.statementListenerSet.getSubscriberMethodName(), this.selectClauseTypes, this.selectClauseColumnNames, this.epServiceProvider.getURI(), this.epServiceProvider.getEngineImportService());
        this.isMakeNatural = true;
    }

    @Override
    public void indicate(UniformPair<EventBean[]> results) {
        if (results != null) {
            if (MetricReportingPath.isMetricsEnabled && this.statementMetricHandle.isEnabled()) {
                int numIStream = results.getFirst() != null ? results.getFirst().length : 0;
                int numRStream = results.getSecond() != null ? results.getSecond().length : 0;
                this.metricReportingService.accountOutput(this.statementMetricHandle, numIStream, numRStream);
            }
            if (results.getFirst() != null && results.getFirst().length != 0) {
                this.lastResults.get().add(results);
            } else if (results.getSecond() != null && results.getSecond().length != 0) {
                this.lastResults.get().add(results);
            }
        }
    }

    @Override
    public void execute() {
        ArrayDeque<UniformPair<EventBean[]>> dispatches = this.lastResults.get();
        UniformPair<EventBean[]> events = EventBeanUtility.flattenList(dispatches);
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            ViewSupport.dumpUpdateParams(".execute", events);
        }
        if (ThreadingOption.isThreadingEnabled && this.threadingService.isOutboundThreading()) {
            this.threadingService.submitOutbound(new OutboundUnitRunnable(events, this));
        } else {
            this.processDispatch(events);
        }
        dispatches.clear();
    }

    public void processDispatch(UniformPair<EventBean[]> events) {
        Map<Object, UniformPair<EventBean[]>> groups;
        if (!this.forClauseDelivery) {
            this.dispatchInternal(events);
            return;
        }
        if (this.groupDeliveryExpressions == null || this.groupDeliveryExpressions.length == 0) {
            UniformPair<Object> todeliver = new UniformPair<Object>(null, null);
            if (events != null) {
                if (events.getFirst() != null) {
                    for (EventBean theEvent : events.getFirst()) {
                        todeliver.setFirst(new EventBean[]{theEvent});
                        this.dispatchInternal(todeliver);
                    }
                    todeliver.setFirst(null);
                }
                if (events.getSecond() != null) {
                    for (EventBean theEvent : events.getSecond()) {
                        todeliver.setSecond(new EventBean[]{theEvent});
                        this.dispatchInternal(todeliver);
                    }
                    todeliver.setSecond(null);
                }
            }
            return;
        }
        try {
            groups = this.getGroupedResults(events);
        }
        catch (RuntimeException ex) {
            log.error("Unexpected exception evaluating grouped-delivery expressions: " + ex.getMessage() + ", delivering ungrouped", (Throwable)ex);
            this.dispatchInternal(events);
            return;
        }
        for (Map.Entry<Object, UniformPair<EventBean[]>> group : groups.entrySet()) {
            this.dispatchInternal(group.getValue());
        }
    }

    private Map<Object, UniformPair<EventBean[]>> getGroupedResults(UniformPair<EventBean[]> events) {
        if (events == null) {
            return Collections.emptyMap();
        }
        LinkedHashMap<Object, UniformPair<EventBean[]>> groups = new LinkedHashMap<Object, UniformPair<EventBean[]>>();
        EventBean[] eventsPerStream = new EventBean[1];
        this.getGroupedResults(groups, events.getFirst(), true, eventsPerStream);
        this.getGroupedResults(groups, events.getSecond(), false, eventsPerStream);
        return groups;
    }

    private void getGroupedResults(Map<Object, UniformPair<EventBean[]>> groups, EventBean[] events, boolean insertStream, EventBean[] eventsPerStream) {
        if (events == null) {
            return;
        }
        for (EventBean theEvent : events) {
            Object key;
            EventBean evalEvent = theEvent;
            if (evalEvent instanceof NaturalEventBean) {
                evalEvent = ((NaturalEventBean)evalEvent).getOptionalSynthetic();
            }
            eventsPerStream[0] = evalEvent;
            if (this.groupDeliveryExpressions.length == 1) {
                key = this.groupDeliveryExpressions[0].evaluate(eventsPerStream, true, this.exprEvaluatorContext);
            } else {
                Object[] keys = new Object[this.groupDeliveryExpressions.length];
                for (int i = 0; i < this.groupDeliveryExpressions.length; ++i) {
                    keys[i] = this.groupDeliveryExpressions[i].evaluate(eventsPerStream, true, this.exprEvaluatorContext);
                }
                key = new MultiKeyUntyped(keys);
            }
            UniformPair<Object> groupEntry = groups.get(key);
            if (groupEntry == null) {
                groupEntry = insertStream ? new UniformPair<Object>(new EventBean[]{theEvent}, null) : new UniformPair<EventBean[]>(null, new EventBean[]{theEvent});
                groups.put(key, groupEntry);
                continue;
            }
            if (insertStream) {
                if (groupEntry.getFirst() == null) {
                    groupEntry.setFirst(new EventBean[]{theEvent});
                    continue;
                }
                groupEntry.setFirst(EventBeanUtility.addToArray(groupEntry.getFirst(), theEvent));
                continue;
            }
            if (groupEntry.getSecond() == null) {
                groupEntry.setSecond(new EventBean[]{theEvent});
                continue;
            }
            groupEntry.setSecond(EventBeanUtility.addToArray(groupEntry.getSecond(), theEvent));
        }
    }

    private void dispatchInternal(UniformPair<EventBean[]> events) {
        String message;
        if (this.statementResultNaturalStrategy != null) {
            this.statementResultNaturalStrategy.execute(events);
        }
        EventBean[] newEventArr = events != null ? events.getFirst() : null;
        EventBean[] oldEventArr = events != null ? events.getSecond() : null;
        for (UpdateListener updateListener : this.statementListenerSet.getListeners()) {
            try {
                updateListener.update(newEventArr, oldEventArr);
            }
            catch (Throwable t) {
                message = "Unexpected exception invoking listener update method on listener class '" + updateListener.getClass().getSimpleName() + "' : " + t.getClass().getSimpleName() + " : " + t.getMessage();
                log.error(message, t);
            }
        }
        if (this.statementListenerSet.getStmtAwareListeners().length > 0) {
            for (StatementAwareUpdateListener statementAwareUpdateListener : this.statementListenerSet.getStmtAwareListeners()) {
                try {
                    statementAwareUpdateListener.update(newEventArr, oldEventArr, this.epStatement, this.epServiceProvider);
                }
                catch (Throwable t) {
                    message = "Unexpected exception invoking listener update method on listener class '" + statementAwareUpdateListener.getClass().getSimpleName() + "' : " + t.getClass().getSimpleName() + " : " + t.getMessage();
                    log.error(message, t);
                }
            }
        }
        if (AuditPath.isAuditEnabled && !this.statementOutputHooks.isEmpty()) {
            for (StatementResultListener listener : this.statementOutputHooks) {
                listener.update(newEventArr, oldEventArr, this.epStatement.getName(), this.epStatement, this.epServiceProvider);
            }
        }
    }

    @Override
    public void dispatchOnStop() {
        ArrayDeque<UniformPair<EventBean[]>> dispatches = this.lastResults.get();
        if (dispatches.isEmpty()) {
            return;
        }
        this.execute();
        this.lastResults = new ThreadLocal<ArrayDeque<UniformPair<EventBean[]>>>(){

            @Override
            protected synchronized ArrayDeque<UniformPair<EventBean[]>> initialValue() {
                return new ArrayDeque<UniformPair<EventBean[]>>();
            }
        };
    }
}

