/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.service;

import com.espertech.esper.epl.table.mgmt.TableMetadata;
import com.espertech.esper.epl.virtualdw.VirtualDWViewProviderForAgentInstance;
import com.espertech.esper.view.ViewFactoryChain;
import com.espertech.esper.view.ViewServiceHelper;
import java.lang.annotation.Annotation;
import java.util.Set;

public class StreamJoinAnalysisResult {
    private final int numStreams;
    private boolean[] isUnidirectionalInd;
    private boolean[] isUnidirectionalNonDriving;
    private boolean isPureSelfJoin;
    private boolean[] hasChildViews;
    private boolean[] isNamedWindow;
    private VirtualDWViewProviderForAgentInstance[] viewExternal;
    private String[][][] uniqueKeys;
    private TableMetadata[] tablesPerStream;

    public StreamJoinAnalysisResult(int numStreams) {
        this.numStreams = numStreams;
        this.isPureSelfJoin = false;
        this.isUnidirectionalInd = new boolean[numStreams];
        this.isUnidirectionalNonDriving = new boolean[numStreams];
        this.hasChildViews = new boolean[numStreams];
        this.isNamedWindow = new boolean[numStreams];
        this.viewExternal = new VirtualDWViewProviderForAgentInstance[numStreams];
        this.uniqueKeys = new String[numStreams][][];
        this.tablesPerStream = new TableMetadata[numStreams];
    }

    public void setUnidirectionalInd(int index) {
        this.isUnidirectionalInd[index] = true;
    }

    public void setUnidirectionalNonDriving(int index) {
        this.isUnidirectionalNonDriving[index] = true;
    }

    public void setPureSelfJoin(boolean pureSelfJoin) {
        this.isPureSelfJoin = pureSelfJoin;
    }

    public void setHasChildViews(int index) {
        this.hasChildViews[index] = true;
    }

    public boolean[] getUnidirectionalInd() {
        return this.isUnidirectionalInd;
    }

    public boolean[] getUnidirectionalNonDriving() {
        return this.isUnidirectionalNonDriving;
    }

    public boolean isPureSelfJoin() {
        return this.isPureSelfJoin;
    }

    public boolean[] getHasChildViews() {
        return this.hasChildViews;
    }

    public boolean[] getNamedWindow() {
        return this.isNamedWindow;
    }

    public void setNamedWindow(int index) {
        this.isNamedWindow[index] = true;
    }

    public int getNumStreams() {
        return this.numStreams;
    }

    public VirtualDWViewProviderForAgentInstance[] getViewExternal() {
        return this.viewExternal;
    }

    public String[][][] getUniqueKeys() {
        return this.uniqueKeys;
    }

    public void setTablesForStream(int streamNum, TableMetadata metadata) {
        this.tablesPerStream[streamNum] = metadata;
    }

    public TableMetadata[] getTablesPerStream() {
        return this.tablesPerStream;
    }

    public void addUniquenessInfo(ViewFactoryChain[] unmaterializedViewChain, Annotation[] annotations) {
        for (int i = 0; i < unmaterializedViewChain.length; ++i) {
            Set<String> uniquenessProps;
            if (unmaterializedViewChain[i].getDataWindowViewFactoryCount() <= 0 || (uniquenessProps = ViewServiceHelper.getUniqueCandidateProperties(unmaterializedViewChain[i].getViewFactoryChain(), annotations)) == null) continue;
            this.uniqueKeys[i] = new String[1][];
            this.uniqueKeys[i][0] = uniquenessProps.toArray(new String[uniquenessProps.size()]);
        }
    }

    public boolean isUnidirectional() {
        for (boolean ind : this.isUnidirectionalInd) {
            if (!ind) continue;
            return true;
        }
        return false;
    }

    public int getUnidirectionalStreamNumberFirst() {
        for (int i = 0; i < this.isUnidirectionalInd.length; ++i) {
            if (!this.isUnidirectionalInd[i]) continue;
            return i;
        }
        throw new IllegalStateException();
    }

    public boolean isUnidirectionalAll() {
        for (boolean ind : this.isUnidirectionalInd) {
            if (ind) continue;
            return false;
        }
        return true;
    }

    public int getUnidirectionalCount() {
        int count = 0;
        for (boolean ind : this.isUnidirectionalInd) {
            count += ind ? 1 : 0;
        }
        return count;
    }
}

