/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.start;

import com.espertech.esper.client.EventType;
import com.espertech.esper.core.context.factory.StatementAgentInstanceFactoryCreateVariable;
import com.espertech.esper.core.context.factory.StatementAgentInstanceFactoryCreateVariableResult;
import com.espertech.esper.core.context.mgr.ContextManagedStatementCreateVariableDesc;
import com.espertech.esper.core.context.mgr.ContextManagementService;
import com.espertech.esper.core.context.util.ContextMergeView;
import com.espertech.esper.core.service.EPServicesContext;
import com.espertech.esper.core.service.ExprEvaluatorContextStatement;
import com.espertech.esper.core.service.StatementContext;
import com.espertech.esper.core.service.resource.StatementResourceHolder;
import com.espertech.esper.core.service.speccompiled.StatementSpecCompiled;
import com.espertech.esper.core.start.EPStatementDestroyCallbackList;
import com.espertech.esper.core.start.EPStatementStartMethodBase;
import com.espertech.esper.core.start.EPStatementStartResult;
import com.espertech.esper.core.start.EPStatementStopMethod;
import com.espertech.esper.epl.core.streamtype.StreamTypeServiceImpl;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprNodeOrigin;
import com.espertech.esper.epl.expression.core.ExprValidationContext;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.spec.CreateVariableDesc;
import com.espertech.esper.epl.util.ExprNodeUtilityRich;
import com.espertech.esper.epl.variable.CreateVariableView;
import com.espertech.esper.epl.variable.VariableDeclarationException;
import com.espertech.esper.epl.variable.VariableExistsException;
import com.espertech.esper.epl.variable.VariableMetaData;
import com.espertech.esper.epl.variable.VariableServiceUtil;
import com.espertech.esper.util.DestroyCallback;
import com.espertech.esper.view.ViewProcessingException;
import com.espertech.esper.view.Viewable;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EPStatementStartMethodCreateVariable
extends EPStatementStartMethodBase {
    private static final Logger log = LoggerFactory.getLogger(EPStatementStartMethodCreateVariable.class);

    public EPStatementStartMethodCreateVariable(StatementSpecCompiled statementSpec) {
        super(statementSpec);
    }

    @Override
    public EPStatementStartResult startInternal(EPServicesContext services, final StatementContext statementContext, boolean isNewStatement, boolean isRecoveringStatement, boolean isRecoveringResilient) throws ExprValidationException, ViewProcessingException {
        Viewable outputView;
        CreateVariableDesc createDesc = this.statementSpec.getCreateVariableDesc();
        VariableServiceUtil.checkAlreadyDeclaredTable(createDesc.getVariableName(), services.getTableService());
        Object value = null;
        if (createDesc.getAssignment() != null) {
            StreamTypeServiceImpl typeService = new StreamTypeServiceImpl(new EventType[0], new String[0], new boolean[0], services.getEngineURI(), false, false);
            ExprEvaluatorContextStatement evaluatorContextStmt = new ExprEvaluatorContextStatement(statementContext, false);
            ExprValidationContext validationContext = new ExprValidationContext(typeService, statementContext.getEngineImportService(), statementContext.getStatementExtensionServicesContext(), null, statementContext.getSchedulingService(), statementContext.getVariableService(), statementContext.getTableService(), evaluatorContextStmt, statementContext.getEventAdapterService(), statementContext.getStatementName(), statementContext.getStatementId(), statementContext.getAnnotations(), statementContext.getContextDescriptor(), false, false, false, false, null, false);
            ExprNode validated = ExprNodeUtilityRich.getValidatedSubtree(ExprNodeOrigin.VARIABLEASSIGN, createDesc.getAssignment(), validationContext);
            value = validated.getForge().getExprEvaluator().evaluate(null, true, evaluatorContextStmt);
        }
        try {
            services.getVariableService().createNewVariable(this.statementSpec.getOptionalContextName(), createDesc.getVariableName(), createDesc.getVariableType(), createDesc.isConstant(), createDesc.isArray(), createDesc.isArrayOfPrimitive(), value, services.getEngineImportService());
        }
        catch (VariableExistsException ex) {
            if (isNewStatement) {
                throw new ExprValidationException("Cannot create variable: " + ex.getMessage(), ex);
            }
        }
        catch (VariableDeclarationException ex) {
            throw new ExprValidationException("Cannot create variable: " + ex.getMessage(), ex);
        }
        EPStatementDestroyCallbackList destroyMethod = new EPStatementDestroyCallbackList();
        EPStatementStopMethod stopMethod = new EPStatementStopMethod(){

            @Override
            public void stop() {
            }
        };
        VariableMetaData variableMetaData = services.getVariableService().getVariableMetaData(createDesc.getVariableName());
        EventType eventType = CreateVariableView.getEventType(statementContext.getStatementId(), services.getEventAdapterService(), variableMetaData);
        StatementAgentInstanceFactoryCreateVariable contextFactory = new StatementAgentInstanceFactoryCreateVariable(createDesc, this.statementSpec, statementContext, services, variableMetaData, eventType);
        statementContext.setStatementAgentInstanceFactory(contextFactory);
        if (this.statementSpec.getOptionalContextName() != null) {
            ContextMergeView mergeView;
            outputView = mergeView = new ContextMergeView(eventType);
            ContextManagedStatementCreateVariableDesc statement = new ContextManagedStatementCreateVariableDesc(this.statementSpec, statementContext, mergeView, contextFactory);
            services.getContextManagementService().addStatement(this.statementSpec.getOptionalContextName(), statement, isRecoveringResilient);
            final ContextManagementService contextManagementService = services.getContextManagementService();
            destroyMethod.addCallback(new DestroyCallback(){

                @Override
                public void destroy() {
                    contextManagementService.destroyedStatement(EPStatementStartMethodCreateVariable.this.statementSpec.getOptionalContextName(), statementContext.getStatementName(), statementContext.getStatementId());
                }
            });
        } else {
            StatementAgentInstanceFactoryCreateVariableResult resultOfStart = (StatementAgentInstanceFactoryCreateVariableResult)contextFactory.newContext(this.getDefaultAgentInstanceContext(statementContext), isRecoveringResilient);
            outputView = resultOfStart.getFinalView();
            if (statementContext.getStatementExtensionServicesContext() != null && statementContext.getStatementExtensionServicesContext().getStmtResources() != null) {
                StatementResourceHolder holder = statementContext.getStatementExtensionServicesContext().extractStatementResourceHolder(resultOfStart);
                statementContext.getStatementExtensionServicesContext().getStmtResources().setUnpartitioned(holder);
                statementContext.getStatementExtensionServicesContext().postProcessStart(resultOfStart, isRecoveringResilient);
            }
        }
        services.getStatementVariableRefService().addReferences(statementContext.getStatementName(), Collections.singleton(createDesc.getVariableName()), null);
        return new EPStatementStartResult(outputView, stopMethod, destroyMethod);
    }
}

