/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.thread;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.core.service.EPRuntimeImpl;
import com.espertech.esper.core.service.EPServicesContext;
import com.espertech.esper.core.thread.InboundUnitRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InboundUnitSendAvro
implements InboundUnitRunnable {
    private static final Logger log = LoggerFactory.getLogger(InboundUnitSendAvro.class);
    private final Object genericRecordDotData;
    private final String eventTypeName;
    private final EPServicesContext services;
    private final EPRuntimeImpl runtime;

    public InboundUnitSendAvro(Object genericRecordDotData, String eventTypeName, EPServicesContext services, EPRuntimeImpl runtime) {
        this.eventTypeName = eventTypeName;
        this.genericRecordDotData = genericRecordDotData;
        this.services = services;
        this.runtime = runtime;
    }

    @Override
    public void run() {
        try {
            EventBean eventBean = this.services.getEventAdapterService().adapterForAvro(this.genericRecordDotData, this.eventTypeName);
            this.runtime.processWrappedEvent(eventBean);
        }
        catch (RuntimeException e) {
            log.error("Unexpected error processing Object-array event: " + e.getMessage(), (Throwable)e);
        }
    }
}

