/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.thread;

import com.espertech.esper.core.service.EPRuntimeImpl;
import com.espertech.esper.core.service.EPServicesContext;
import com.espertech.esper.core.service.EPStatementHandleCallback;
import com.espertech.esper.core.thread.TimerUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimerUnitSingle
implements TimerUnit {
    private static final Logger log = LoggerFactory.getLogger(TimerUnitSingle.class);
    private final EPServicesContext services;
    private final EPRuntimeImpl runtime;
    private final EPStatementHandleCallback handleCallback;

    public TimerUnitSingle(EPServicesContext services, EPRuntimeImpl runtime, EPStatementHandleCallback handleCallback) {
        this.services = services;
        this.runtime = runtime;
        this.handleCallback = handleCallback;
    }

    @Override
    public void run() {
        try {
            EPRuntimeImpl.processStatementScheduleSingle(this.handleCallback, this.services);
            this.runtime.dispatch();
            this.runtime.processThreadWorkQueue();
        }
        catch (RuntimeException e) {
            log.error("Unexpected error processing timer execution: " + e.getMessage(), (Throwable)e);
        }
    }
}

