/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.agg.access;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.codegen.base.CodegenMember;
import com.espertech.esper.codegen.model.expression.CodegenExpression;
import com.espertech.esper.codegen.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.epl.agg.access.AggregationAccessor;
import com.espertech.esper.epl.agg.access.AggregationAccessorForge;
import com.espertech.esper.epl.agg.access.AggregationAccessorForgeGetCodegenContext;
import com.espertech.esper.epl.agg.access.AggregationState;
import com.espertech.esper.epl.agg.access.AggregationStateSorted;
import com.espertech.esper.epl.agg.factory.AggregationStateSortedForge;
import com.espertech.esper.epl.core.engineimport.EngineImportService;
import com.espertech.esper.epl.expression.codegen.ExprForgeCodegenNames;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.table.mgmt.TableMetadata;
import com.espertech.esper.epl.table.mgmt.TableMetadataInternalEventToPublic;
import com.espertech.esper.plugin.PlugInAggregationMultiFunctionCodegenType;
import com.espertech.esper.util.JavaClassHelper;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;

public class AggregationAccessorSortedTable
implements AggregationAccessor,
AggregationAccessorForge {
    private final boolean max;
    private final Class componentType;
    private final TableMetadata tableMetadata;

    public AggregationAccessorSortedTable(boolean max, Class componentType, TableMetadata tableMetadata) {
        this.max = max;
        this.componentType = componentType;
        this.tableMetadata = tableMetadata;
    }

    @Override
    public PlugInAggregationMultiFunctionCodegenType getPluginCodegenType() {
        return PlugInAggregationMultiFunctionCodegenType.CODEGEN_ALL;
    }

    @Override
    public Object getValue(AggregationState state, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        AggregationStateSorted sorted = (AggregationStateSorted)((Object)state);
        if (sorted.size() == 0) {
            return null;
        }
        Object array = Array.newInstance(this.componentType, sorted.size());
        Iterator<EventBean> it = this.max ? sorted.getReverseIterator() : sorted.iterator();
        int count = 0;
        while (it.hasNext()) {
            EventBean bean = it.next();
            Object[] und = this.tableMetadata.getEventToPublic().convertToUnd(bean, eventsPerStream, isNewData, exprEvaluatorContext);
            Array.set(array, count++, und);
        }
        return array;
    }

    @Override
    public void getValueCodegen(AggregationAccessorForgeGetCodegenContext context) {
        CodegenMember eventToPublic = context.getClassScope().makeAddMember(TableMetadataInternalEventToPublic.class, this.tableMetadata.getEventToPublic());
        AggregationStateSortedForge sorted = (AggregationStateSortedForge)context.getAccessStateForge();
        CodegenExpression size = sorted.sizeCodegen(context.getColumn());
        CodegenExpression iterator = this.max ? sorted.getReverseIteratorCodegen(context.getColumn()) : sorted.iteratorCodegen(context.getColumn());
        context.getMethod().getBlock().ifCondition(CodegenExpressionBuilder.equalsIdentity(size, CodegenExpressionBuilder.constant(0))).blockReturn(CodegenExpressionBuilder.constantNull()).declareVar(JavaClassHelper.getArrayType(this.componentType), "array", CodegenExpressionBuilder.newArrayByLength(this.componentType, size)).declareVar(Integer.TYPE, "count", CodegenExpressionBuilder.constant(0)).declareVar(Iterator.class, "it", iterator).whileLoop(CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("it"), "hasNext", new CodegenExpression[0])).declareVar(EventBean.class, "bean", CodegenExpressionBuilder.cast(EventBean.class, CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("it"), "next", new CodegenExpression[0]))).assignArrayElement(CodegenExpressionBuilder.ref("array"), (CodegenExpression)CodegenExpressionBuilder.ref("count"), CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.member(eventToPublic.getMemberId()), "convertToUnd", CodegenExpressionBuilder.ref("bean"), ExprForgeCodegenNames.REF_EPS, ExprForgeCodegenNames.REF_ISNEWDATA, ExprForgeCodegenNames.REF_EXPREVALCONTEXT)).increment("count").blockEnd().methodReturn(CodegenExpressionBuilder.ref("array"));
    }

    @Override
    public Collection<EventBean> getEnumerableEvents(AggregationState state, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        return ((AggregationStateSorted)((Object)state)).collectionReadOnly();
    }

    @Override
    public void getEnumerableEventsCodegen(AggregationAccessorForgeGetCodegenContext context) {
        AggregationStateSortedForge sorted = (AggregationStateSortedForge)context.getAccessStateForge();
        context.getMethod().getBlock().methodReturn(sorted.collectionReadOnlyCodegen(context.getColumn()));
    }

    @Override
    public Collection<Object> getEnumerableScalar(AggregationState state, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        return null;
    }

    @Override
    public void getEnumerableScalarCodegen(AggregationAccessorForgeGetCodegenContext context) {
        context.getMethod().getBlock().methodReturn(CodegenExpressionBuilder.constantNull());
    }

    @Override
    public EventBean getEnumerableEvent(AggregationState state, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        return null;
    }

    @Override
    public void getEnumerableEventCodegen(AggregationAccessorForgeGetCodegenContext context) {
        context.getMethod().getBlock().methodReturn(CodegenExpressionBuilder.constantNull());
    }

    @Override
    public AggregationAccessor getAccessor(EngineImportService engineImportService, boolean isFireAndForget, String statementName) {
        return this;
    }
}

