/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.agg.aggregator;

import com.espertech.esper.codegen.base.CodegenClassScope;
import com.espertech.esper.codegen.base.CodegenMembersColumnized;
import com.espertech.esper.codegen.base.CodegenMethodNode;
import com.espertech.esper.codegen.core.CodegenCtor;
import com.espertech.esper.codegen.model.expression.CodegenExpression;
import com.espertech.esper.codegen.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.codegen.model.expression.CodegenExpressionRefWCol;
import com.espertech.esper.codegen.model.expression.CodegenExpressionTypePair;
import com.espertech.esper.collection.RefCountedSet;
import com.espertech.esper.collection.SortedDoubleVector;
import com.espertech.esper.epl.agg.aggregator.AggregationMethod;
import com.espertech.esper.epl.agg.aggregator.AggregatorCodegenUtil;
import com.espertech.esper.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.epl.expression.core.ExprForge;
import com.espertech.esper.util.SimpleNumberCoercerFactory;

public class AggregatorMedian
implements AggregationMethod {
    protected SortedDoubleVector vector = new SortedDoubleVector();

    public static void rowMemberCodegen(boolean distinct, int column, CodegenCtor ctor, CodegenMembersColumnized membersColumnized) {
        membersColumnized.addMember(column, SortedDoubleVector.class, "vector");
        ctor.getBlock().assignRef(CodegenExpressionBuilder.refCol("vector", column), CodegenExpressionBuilder.newInstance(SortedDoubleVector.class, new CodegenExpression[0]));
        if (distinct) {
            membersColumnized.addMember(column, RefCountedSet.class, "distinctSet");
            ctor.getBlock().assignRef(CodegenExpressionBuilder.refCol("distinctSet", column), CodegenExpressionBuilder.newInstance(RefCountedSet.class, new CodegenExpression[0]));
        }
    }

    @Override
    public void enter(Object object) {
        if (object == null) {
            return;
        }
        double value = ((Number)object).doubleValue();
        this.vector.add(value);
    }

    public static void applyEnterCodegen(boolean distinct, boolean hasFilter, int column, CodegenMethodNode method, ExprForgeCodegenSymbol symbols, ExprForge[] forges, CodegenClassScope classScope) {
        CodegenExpressionTypePair value = AggregatorCodegenUtil.prefixWithFilterNullDistinctChecks(true, distinct, hasFilter, forges, column, method, symbols, classScope);
        CodegenExpressionRefWCol vector = CodegenExpressionBuilder.refCol("vector", column);
        method.getBlock().exprDotMethod(vector, "add", SimpleNumberCoercerFactory.SimpleNumberCoercerDouble.codegenDouble(value.getExpression(), value.getType()));
    }

    @Override
    public void leave(Object object) {
        if (object == null) {
            return;
        }
        double value = ((Number)object).doubleValue();
        this.vector.remove(value);
    }

    public static void applyLeaveCodegen(boolean distinct, boolean hasFilter, int column, CodegenMethodNode method, ExprForgeCodegenSymbol symbols, ExprForge[] forges, CodegenClassScope classScope) {
        CodegenExpressionTypePair value = AggregatorCodegenUtil.prefixWithFilterNullDistinctChecks(false, distinct, hasFilter, forges, column, method, symbols, classScope);
        CodegenExpressionRefWCol vector = CodegenExpressionBuilder.refCol("vector", column);
        method.getBlock().exprDotMethod(vector, "remove", SimpleNumberCoercerFactory.SimpleNumberCoercerDouble.codegenDouble(value.getExpression(), value.getType()));
    }

    @Override
    public void clear() {
        this.vector.clear();
    }

    public static void clearCodegen(boolean distinct, int column, CodegenMethodNode method) {
        method.getBlock().exprDotMethod(CodegenExpressionBuilder.refCol("vector", column), "clear", new CodegenExpression[0]).applyConditional(distinct, block -> block.exprDotMethod(CodegenExpressionBuilder.refCol("distinctSet", column), "clear", new CodegenExpression[0]));
    }

    @Override
    public Object getValue() {
        return AggregatorMedian.medianCompute(this.vector);
    }

    public static void getValueCodegen(int column, CodegenMethodNode method) {
        method.getBlock().methodReturn(CodegenExpressionBuilder.staticMethod(AggregatorMedian.class, "medianCompute", CodegenExpressionBuilder.refCol("vector", column)));
    }

    public static Object medianCompute(SortedDoubleVector vector) {
        if (vector.size() == 0) {
            return null;
        }
        if (vector.size() == 1) {
            return vector.getValue(0);
        }
        int middle = vector.size() >> 1;
        if (vector.size() % 2 == 0) {
            return (vector.getValue(middle - 1) + vector.getValue(middle)) / 2.0;
        }
        return vector.getValue(middle);
    }
}

