/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.agg.aggregator;

import com.espertech.esper.codegen.base.CodegenClassScope;
import com.espertech.esper.codegen.base.CodegenMember;
import com.espertech.esper.codegen.base.CodegenMembersColumnized;
import com.espertech.esper.codegen.base.CodegenMethodNode;
import com.espertech.esper.codegen.core.CodegenCtor;
import com.espertech.esper.codegen.model.expression.CodegenExpression;
import com.espertech.esper.codegen.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.codegen.model.expression.CodegenExpressionRefWCol;
import com.espertech.esper.epl.agg.aggregator.AggregationMethod;
import com.espertech.esper.epl.agg.aggregator.AggregatorCodegenUtil;
import com.espertech.esper.epl.agg.factory.AggregationMethodFactoryRate;
import com.espertech.esper.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.epl.expression.core.ExprForge;
import com.espertech.esper.schedule.TimeProvider;
import java.util.ArrayDeque;

public class AggregatorRateEver
implements AggregationMethod {
    protected final long interval;
    protected final long oneSecondTime;
    protected final ArrayDeque<Long> points;
    protected boolean hasLeave = false;
    protected final TimeProvider timeProvider;

    public AggregatorRateEver(long interval, long oneSecondTime, TimeProvider timeProvider) {
        this.interval = interval;
        this.oneSecondTime = oneSecondTime;
        this.timeProvider = timeProvider;
        this.points = new ArrayDeque();
    }

    public static void rowMemberCodegen(int column, CodegenCtor ctor, CodegenMembersColumnized membersColumnized) {
        membersColumnized.addMember(column, Boolean.TYPE, "hasLeave");
        membersColumnized.addMember(column, ArrayDeque.class, "points");
        ctor.getBlock().assignRef(CodegenExpressionBuilder.refCol("points", column), CodegenExpressionBuilder.newInstance(ArrayDeque.class, new CodegenExpression[0]));
    }

    @Override
    public void enter(Object object) {
        long timestamp = this.timeProvider.getTime();
        this.points.add(timestamp);
        boolean leave = AggregatorRateEver.removeFromHead(this.points, timestamp, this.interval);
        this.hasLeave |= leave;
    }

    public static void applyEnterCodegen(AggregationMethodFactoryRate forge, int column, CodegenMethodNode method, ExprForgeCodegenSymbol symbols, ExprForge[] forges, CodegenClassScope classScope) {
        if (forge.getParent().getOptionalFilter() != null) {
            AggregatorCodegenUtil.prefixWithFilterCheck(forge.getParent().getOptionalFilter().getForge(), method, symbols, classScope);
        }
        CodegenMember timeProvider = classScope.makeAddMember(TimeProvider.class, forge.getTimeProvider());
        CodegenExpressionRefWCol points = CodegenExpressionBuilder.refCol("points", column);
        method.getBlock().declareVar(Long.TYPE, "timestamp", CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.member(timeProvider.getMemberId()), "getTime", new CodegenExpression[0])).exprDotMethod(points, "add", CodegenExpressionBuilder.ref("timestamp")).declareVar(Boolean.TYPE, "leave", CodegenExpressionBuilder.staticMethod(AggregatorRateEver.class, "removeFromHead", points, CodegenExpressionBuilder.ref("timestamp"), CodegenExpressionBuilder.constant(forge.getIntervalTime()))).assignCompound(CodegenExpressionBuilder.refCol("hasLeave", column), "|", (CodegenExpression)CodegenExpressionBuilder.ref("leave"));
    }

    @Override
    public void leave(Object object) {
    }

    @Override
    public void clear() {
        this.points.clear();
    }

    public static void clearCodegen(int column, CodegenMethodNode method) {
        method.getBlock().exprDotMethod(CodegenExpressionBuilder.refCol("points", column), "clear", new CodegenExpression[0]);
    }

    @Override
    public Object getValue() {
        if (!this.points.isEmpty()) {
            long newest = this.points.getLast();
            boolean leave = AggregatorRateEver.removeFromHead(this.points, newest, this.interval);
            this.hasLeave |= leave;
        }
        if (!this.hasLeave) {
            return null;
        }
        if (this.points.isEmpty()) {
            return 0.0;
        }
        return (double)((long)this.points.size() * this.oneSecondTime) * 1.0 / (double)this.interval;
    }

    public static void getValueCodegen(AggregationMethodFactoryRate forge, int column, CodegenMethodNode method) {
        CodegenExpressionRefWCol points = CodegenExpressionBuilder.refCol("points", column);
        CodegenExpressionRefWCol hasLeave = CodegenExpressionBuilder.refCol("hasLeave", column);
        method.getBlock().ifCondition(CodegenExpressionBuilder.not(CodegenExpressionBuilder.exprDotMethod(points, "isEmpty", new CodegenExpression[0]))).declareVar(Long.TYPE, "newest", CodegenExpressionBuilder.cast(Long.class, CodegenExpressionBuilder.exprDotMethod(points, "getLast", new CodegenExpression[0]))).declareVar(Boolean.TYPE, "leave", CodegenExpressionBuilder.staticMethod(AggregatorRateEver.class, "removeFromHead", points, CodegenExpressionBuilder.ref("newest"), CodegenExpressionBuilder.constant(forge.getIntervalTime()))).assignCompound(CodegenExpressionBuilder.refCol("hasLeave", column), "|", (CodegenExpression)CodegenExpressionBuilder.ref("leave")).blockEnd().ifCondition(CodegenExpressionBuilder.not(hasLeave)).blockReturn(CodegenExpressionBuilder.constantNull()).ifCondition(CodegenExpressionBuilder.exprDotMethod(points, "isEmpty", new CodegenExpression[0])).blockReturn(CodegenExpressionBuilder.constant(0.0)).methodReturn(CodegenExpressionBuilder.op(CodegenExpressionBuilder.op(CodegenExpressionBuilder.op(CodegenExpressionBuilder.exprDotMethod(points, "size", new CodegenExpression[0]), "*", CodegenExpressionBuilder.constant(forge.getTimeAbacus().getOneSecond())), "*", CodegenExpressionBuilder.constant(1.0)), "/", CodegenExpressionBuilder.constant(forge.getIntervalTime())));
    }

    public long getInterval() {
        return this.interval;
    }

    public long getOneSecondTime() {
        return this.oneSecondTime;
    }

    public ArrayDeque<Long> getPoints() {
        return this.points;
    }

    public boolean isHasLeave() {
        return this.hasLeave;
    }

    public void setHasLeave(boolean hasLeave) {
        this.hasLeave = hasLeave;
    }

    public TimeProvider getTimeProvider() {
        return this.timeProvider;
    }

    public static boolean removeFromHead(ArrayDeque<Long> points, long timestamp, long interval) {
        boolean hasLeave = false;
        if (points.size() > 1) {
            long first;
            long delta;
            while ((delta = timestamp - (first = points.getFirst().longValue())) >= interval) {
                points.remove();
                hasLeave = true;
                if (!points.isEmpty()) continue;
                break;
            }
        }
        return hasLeave;
    }
}

