/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.agg.factory;

import com.espertech.esper.client.EventType;
import com.espertech.esper.codegen.base.CodegenClassScope;
import com.espertech.esper.codegen.base.CodegenMembersColumnized;
import com.espertech.esper.codegen.base.CodegenMethodNode;
import com.espertech.esper.codegen.core.CodegenCtor;
import com.espertech.esper.epl.agg.access.AggregationAccessorForge;
import com.espertech.esper.epl.agg.access.AggregationAgentForge;
import com.espertech.esper.epl.agg.access.AggregationStateKey;
import com.espertech.esper.epl.agg.aggregator.AggregationMethod;
import com.espertech.esper.epl.agg.aggregator.AggregatorAvg;
import com.espertech.esper.epl.agg.aggregator.AggregatorAvgBigDecimal;
import com.espertech.esper.epl.agg.aggregator.AggregatorAvgBigDecimalFilter;
import com.espertech.esper.epl.agg.aggregator.AggregatorAvgFilter;
import com.espertech.esper.epl.agg.aggregator.AggregatorCodegenUtil;
import com.espertech.esper.epl.agg.factory.AggregationMethodFactoryUtil;
import com.espertech.esper.epl.agg.service.common.AggregationMethodFactory;
import com.espertech.esper.epl.agg.service.common.AggregationStateFactoryForge;
import com.espertech.esper.epl.agg.service.common.AggregationValidationUtil;
import com.espertech.esper.epl.core.engineimport.EngineImportService;
import com.espertech.esper.epl.expression.baseagg.ExprAggregateNodeBase;
import com.espertech.esper.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.epl.expression.core.ExprForge;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.expression.methodagg.ExprAvgNode;
import com.espertech.esper.epl.expression.methodagg.ExprMethodAggUtil;
import com.espertech.esper.util.SimpleNumberCoercerFactory;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;

public class AggregationMethodFactoryAvg
implements AggregationMethodFactory {
    protected final ExprAvgNode parent;
    protected final Class childType;
    protected final Class resultType;
    protected final MathContext optionalMathContext;

    public AggregationMethodFactoryAvg(ExprAvgNode parent, Class childType, MathContext optionalMathContext) {
        this.parent = parent;
        this.childType = childType;
        this.resultType = this.getAvgAggregatorType(childType);
        this.optionalMathContext = optionalMathContext;
    }

    @Override
    public boolean isAccessAggregation() {
        return false;
    }

    @Override
    public Class getResultType() {
        return this.resultType;
    }

    @Override
    public AggregationStateKey getAggregationStateKey(boolean isMatchRecognize) {
        throw new IllegalStateException("Not an access aggregation function");
    }

    @Override
    public AggregationStateFactoryForge getAggregationStateFactory(boolean isMatchRecognize) {
        throw new IllegalStateException("Not an access aggregation function");
    }

    @Override
    public AggregationAccessorForge getAccessorForge() {
        throw new IllegalStateException("Not an access aggregation function");
    }

    @Override
    public AggregationMethod make() {
        AggregationMethod method = this.makeAvgAggregator(this.childType, this.parent.isHasFilter(), this.optionalMathContext);
        if (!this.parent.isDistinct()) {
            return method;
        }
        return AggregationMethodFactoryUtil.makeDistinctAggregator(method, this.parent.isHasFilter());
    }

    @Override
    public ExprAggregateNodeBase getAggregationExpression() {
        return this.parent;
    }

    @Override
    public void validateIntoTableCompatible(AggregationMethodFactory intoTableAgg) throws ExprValidationException {
        AggregationValidationUtil.validateAggregationType(this, intoTableAgg);
        AggregationMethodFactoryAvg that = (AggregationMethodFactoryAvg)intoTableAgg;
        AggregationValidationUtil.validateAggregationInputType(this.childType, that.childType);
        AggregationValidationUtil.validateAggregationFilter(this.parent.isHasFilter(), that.parent.isHasFilter());
    }

    @Override
    public AggregationAgentForge getAggregationStateAgent(EngineImportService engineImportService, String statementName) {
        return null;
    }

    @Override
    public ExprForge[] getMethodAggregationForge(boolean join, EventType[] typesPerStream) throws ExprValidationException {
        return ExprMethodAggUtil.getDefaultForges(this.parent.getPositionalParams(), join, typesPerStream);
    }

    @Override
    public void rowMemberCodegen(int column, CodegenCtor ctor, CodegenMembersColumnized membersColumnized, ExprForge[] forges, CodegenClassScope classScope) {
        if (this.childType == BigDecimal.class || this.childType == BigInteger.class) {
            AggregatorAvgBigDecimal.rowMemberCodegen(this.parent.isDistinct(), column, ctor, membersColumnized);
        } else {
            AggregatorCodegenUtil.rowMemberSumAndCnt(this.parent.isDistinct(), column, ctor, membersColumnized, Double.TYPE);
        }
    }

    @Override
    public void applyEnterCodegen(int column, CodegenMethodNode method, ExprForgeCodegenSymbol symbols, ExprForge[] forges, CodegenClassScope classScope) {
        if (this.childType == BigDecimal.class || this.childType == BigInteger.class) {
            AggregatorAvgBigDecimal.applyEnterCodegen(this.parent.isDistinct(), this.parent.isHasFilter(), column, method, symbols, forges, classScope);
        } else {
            AggregatorCodegenUtil.sumAndCountApplyEnterCodegen(this.parent.isDistinct(), this.parent.isHasFilter(), column, method, symbols, forges, classScope, SimpleNumberCoercerFactory.SimpleNumberCoercerDouble.INSTANCE);
        }
    }

    @Override
    public void applyLeaveCodegen(int column, CodegenMethodNode method, ExprForgeCodegenSymbol symbols, ExprForge[] forges, CodegenClassScope classScope) {
        if (this.childType == BigDecimal.class || this.childType == BigInteger.class) {
            AggregatorAvgBigDecimal.applyLeaveCodegen(this.parent.isDistinct(), this.parent.isHasFilter(), column, method, symbols, forges, classScope);
        } else {
            AggregatorCodegenUtil.sumAndCountApplyLeaveCodegen(this.parent.isDistinct(), this.parent.isHasFilter(), column, method, symbols, forges, classScope, SimpleNumberCoercerFactory.SimpleNumberCoercerDouble.INSTANCE);
        }
    }

    @Override
    public void clearCodegen(int column, CodegenMethodNode method, CodegenClassScope classScope) {
        if (this.childType == BigDecimal.class || this.childType == BigInteger.class) {
            AggregatorAvgBigDecimal.clearCodegen(this.parent.isDistinct(), column, method);
        } else {
            AggregatorCodegenUtil.sumAndCountClearCodegen(this.parent.isDistinct(), column, method);
        }
    }

    @Override
    public void getValueCodegen(int column, CodegenMethodNode method, CodegenClassScope classScope) {
        if (this.childType == BigDecimal.class || this.childType == BigInteger.class) {
            AggregatorAvgBigDecimal.getValueCodegen(this, column, method, classScope);
        } else {
            AggregatorAvg.getValueCodegen(column, method);
        }
    }

    public MathContext getOptionalMathContext() {
        return this.optionalMathContext;
    }

    private Class getAvgAggregatorType(Class type) {
        if (type == BigDecimal.class || type == BigInteger.class) {
            return BigDecimal.class;
        }
        return Double.class;
    }

    private AggregationMethod makeAvgAggregator(Class type, boolean hasFilter, MathContext optionalMathContext) {
        if (hasFilter) {
            if (type == BigDecimal.class || type == BigInteger.class) {
                return new AggregatorAvgBigDecimalFilter(optionalMathContext);
            }
            return new AggregatorAvgFilter();
        }
        if (type == BigDecimal.class || type == BigInteger.class) {
            return new AggregatorAvgBigDecimal(optionalMathContext);
        }
        return new AggregatorAvg();
    }
}

