/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.agg.factory;

import com.espertech.esper.client.EventType;
import com.espertech.esper.codegen.base.CodegenClassScope;
import com.espertech.esper.codegen.base.CodegenMembersColumnized;
import com.espertech.esper.codegen.base.CodegenMethodNode;
import com.espertech.esper.codegen.core.CodegenCtor;
import com.espertech.esper.epl.agg.access.AggregationAccessorForge;
import com.espertech.esper.epl.agg.access.AggregationAgentForge;
import com.espertech.esper.epl.agg.access.AggregationStateKey;
import com.espertech.esper.epl.agg.aggregator.AggregationMethod;
import com.espertech.esper.epl.agg.aggregator.AggregatorRate;
import com.espertech.esper.epl.agg.aggregator.AggregatorRateEver;
import com.espertech.esper.epl.agg.aggregator.AggregatorRateEverFilter;
import com.espertech.esper.epl.agg.aggregator.AggregatorRateFilter;
import com.espertech.esper.epl.agg.service.common.AggregationMethodFactory;
import com.espertech.esper.epl.agg.service.common.AggregationStateFactoryForge;
import com.espertech.esper.epl.agg.service.common.AggregationValidationUtil;
import com.espertech.esper.epl.core.engineimport.EngineImportService;
import com.espertech.esper.epl.expression.baseagg.ExprAggregateNodeBase;
import com.espertech.esper.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.epl.expression.core.ExprForge;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.expression.methodagg.ExprMethodAggUtil;
import com.espertech.esper.epl.expression.methodagg.ExprRateAggNode;
import com.espertech.esper.epl.expression.time.TimeAbacus;
import com.espertech.esper.schedule.TimeProvider;

public class AggregationMethodFactoryRate
implements AggregationMethodFactory {
    protected final ExprRateAggNode parent;
    protected final boolean isEver;
    protected final long intervalTime;
    protected final TimeProvider timeProvider;
    protected final TimeAbacus timeAbacus;

    public AggregationMethodFactoryRate(ExprRateAggNode parent, boolean isEver, long intervalTime, TimeProvider timeProvider, TimeAbacus timeAbacus) {
        this.parent = parent;
        this.isEver = isEver;
        this.intervalTime = intervalTime;
        this.timeProvider = timeProvider;
        this.timeAbacus = timeAbacus;
    }

    @Override
    public boolean isAccessAggregation() {
        return false;
    }

    @Override
    public Class getResultType() {
        return Double.class;
    }

    @Override
    public AggregationStateKey getAggregationStateKey(boolean isMatchRecognize) {
        throw new IllegalStateException("Not an access aggregation function");
    }

    @Override
    public AggregationStateFactoryForge getAggregationStateFactory(boolean isMatchRecognize) {
        throw new IllegalStateException("Not an access aggregation function");
    }

    @Override
    public AggregationAccessorForge getAccessorForge() {
        throw new IllegalStateException("Not an access aggregation function");
    }

    @Override
    public AggregationMethod make() {
        if (this.isEver) {
            if (this.parent.getPositionalParams().length == 0) {
                return new AggregatorRateEver(this.intervalTime, this.timeAbacus.getOneSecond(), this.timeProvider);
            }
            return new AggregatorRateEverFilter(this.intervalTime, this.timeAbacus.getOneSecond(), this.timeProvider);
        }
        if (this.parent.getOptionalFilter() != null) {
            return new AggregatorRateFilter(this.timeAbacus.getOneSecond());
        }
        return new AggregatorRate(this.timeAbacus.getOneSecond());
    }

    @Override
    public ExprAggregateNodeBase getAggregationExpression() {
        return this.parent;
    }

    @Override
    public void validateIntoTableCompatible(AggregationMethodFactory intoTableAgg) throws ExprValidationException {
        AggregationValidationUtil.validateAggregationType(this, intoTableAgg);
        AggregationMethodFactoryRate that = (AggregationMethodFactoryRate)intoTableAgg;
        if (this.intervalTime != that.intervalTime) {
            throw new ExprValidationException("The size is " + this.intervalTime + " and provided is " + that.intervalTime);
        }
        AggregationValidationUtil.validateAggregationUnbound(!this.isEver, !that.isEver);
    }

    @Override
    public AggregationAgentForge getAggregationStateAgent(EngineImportService engineImportService, String statementName) {
        return null;
    }

    @Override
    public ExprForge[] getMethodAggregationForge(boolean join, EventType[] typesPerStream) throws ExprValidationException {
        return ExprMethodAggUtil.getDefaultForges(this.parent.getPositionalParams(), join, typesPerStream);
    }

    @Override
    public void rowMemberCodegen(int column, CodegenCtor ctor, CodegenMembersColumnized membersColumnized, ExprForge[] forges, CodegenClassScope classScope) {
        if (this.isEver) {
            AggregatorRateEver.rowMemberCodegen(column, ctor, membersColumnized);
        } else {
            AggregatorRate.rowMemberCodegen(column, ctor, membersColumnized);
        }
    }

    @Override
    public void applyEnterCodegen(int column, CodegenMethodNode method, ExprForgeCodegenSymbol symbols, ExprForge[] forges, CodegenClassScope classScope) {
        if (this.isEver) {
            AggregatorRateEver.applyEnterCodegen(this, column, method, symbols, forges, classScope);
        } else {
            AggregatorRate.applyEnterCodegen(this, column, method, symbols, forges, classScope);
        }
    }

    @Override
    public void applyLeaveCodegen(int column, CodegenMethodNode method, ExprForgeCodegenSymbol symbols, ExprForge[] forges, CodegenClassScope classScope) {
        if (!this.isEver) {
            AggregatorRate.applyLeaveCodegen(this, column, method, symbols, forges, classScope);
        }
    }

    @Override
    public void clearCodegen(int column, CodegenMethodNode method, CodegenClassScope classScope) {
        if (this.isEver) {
            AggregatorRateEver.clearCodegen(column, method);
        } else {
            AggregatorRate.clearCodegen(column, method);
        }
    }

    @Override
    public void getValueCodegen(int column, CodegenMethodNode method, CodegenClassScope classScope) {
        if (this.isEver) {
            AggregatorRateEver.getValueCodegen(this, column, method);
        } else {
            AggregatorRate.getValueCodegen(this, column, method);
        }
    }

    public ExprRateAggNode getParent() {
        return this.parent;
    }

    public boolean isEver() {
        return this.isEver;
    }

    public long getIntervalTime() {
        return this.intervalTime;
    }

    public TimeProvider getTimeProvider() {
        return this.timeProvider;
    }

    public TimeAbacus getTimeAbacus() {
        return this.timeAbacus;
    }
}

