/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.agg.factory;

import com.espertech.esper.client.EventType;
import com.espertech.esper.codegen.base.CodegenClassScope;
import com.espertech.esper.codegen.base.CodegenMembersColumnized;
import com.espertech.esper.codegen.base.CodegenMethodNode;
import com.espertech.esper.codegen.core.CodegenCtor;
import com.espertech.esper.epl.agg.access.AggregationAccessorForge;
import com.espertech.esper.epl.agg.access.AggregationAgentForge;
import com.espertech.esper.epl.agg.access.AggregationStateKey;
import com.espertech.esper.epl.agg.aggregator.AggregationMethod;
import com.espertech.esper.epl.agg.aggregator.AggregatorCodegenUtil;
import com.espertech.esper.epl.agg.aggregator.AggregatorSumBigDecimal;
import com.espertech.esper.epl.agg.aggregator.AggregatorSumBigDecimalFilter;
import com.espertech.esper.epl.agg.aggregator.AggregatorSumBigInteger;
import com.espertech.esper.epl.agg.aggregator.AggregatorSumBigIntegerFilter;
import com.espertech.esper.epl.agg.aggregator.AggregatorSumDouble;
import com.espertech.esper.epl.agg.aggregator.AggregatorSumDoubleFilter;
import com.espertech.esper.epl.agg.aggregator.AggregatorSumFloat;
import com.espertech.esper.epl.agg.aggregator.AggregatorSumFloatFilter;
import com.espertech.esper.epl.agg.aggregator.AggregatorSumInteger;
import com.espertech.esper.epl.agg.aggregator.AggregatorSumIntegerFilter;
import com.espertech.esper.epl.agg.aggregator.AggregatorSumLong;
import com.espertech.esper.epl.agg.aggregator.AggregatorSumLongFilter;
import com.espertech.esper.epl.agg.aggregator.AggregatorSumNumInteger;
import com.espertech.esper.epl.agg.aggregator.AggregatorSumNumIntegerFilter;
import com.espertech.esper.epl.agg.factory.AggregationMethodFactoryUtil;
import com.espertech.esper.epl.agg.service.common.AggregationMethodFactory;
import com.espertech.esper.epl.agg.service.common.AggregationStateFactoryForge;
import com.espertech.esper.epl.agg.service.common.AggregationValidationUtil;
import com.espertech.esper.epl.core.engineimport.EngineImportService;
import com.espertech.esper.epl.expression.baseagg.ExprAggregateNodeBase;
import com.espertech.esper.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.epl.expression.core.ExprForge;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.expression.methodagg.ExprMethodAggUtil;
import com.espertech.esper.epl.expression.methodagg.ExprSumNode;
import com.espertech.esper.util.SimpleNumberCoercer;
import com.espertech.esper.util.SimpleNumberCoercerFactory;
import java.math.BigDecimal;
import java.math.BigInteger;

public class AggregationMethodFactorySum
implements AggregationMethodFactory {
    protected final ExprSumNode parent;
    protected final Class resultType;
    protected final Class inputValueType;

    public AggregationMethodFactorySum(ExprSumNode parent, Class inputValueType) {
        this.parent = parent;
        this.inputValueType = inputValueType;
        this.resultType = this.getSumAggregatorType(inputValueType);
    }

    @Override
    public boolean isAccessAggregation() {
        return false;
    }

    @Override
    public AggregationStateKey getAggregationStateKey(boolean isMatchRecognize) {
        throw new IllegalStateException("Not an access aggregation function");
    }

    @Override
    public AggregationStateFactoryForge getAggregationStateFactory(boolean isMatchRecognize) {
        throw new IllegalStateException("Not an access aggregation function");
    }

    @Override
    public AggregationAccessorForge getAccessorForge() {
        throw new IllegalStateException("Not an access aggregation function");
    }

    @Override
    public Class getResultType() {
        return this.resultType;
    }

    @Override
    public AggregationMethod make() {
        AggregationMethod method = this.makeSumAggregator(this.inputValueType, this.parent.isHasFilter());
        if (!this.parent.isDistinct()) {
            return method;
        }
        return AggregationMethodFactoryUtil.makeDistinctAggregator(method, this.parent.isHasFilter());
    }

    @Override
    public ExprAggregateNodeBase getAggregationExpression() {
        return this.parent;
    }

    @Override
    public void validateIntoTableCompatible(AggregationMethodFactory intoTableAgg) throws ExprValidationException {
        AggregationValidationUtil.validateAggregationType(this, intoTableAgg);
        AggregationMethodFactorySum that = (AggregationMethodFactorySum)intoTableAgg;
        AggregationValidationUtil.validateAggregationInputType(this.inputValueType, that.inputValueType);
        AggregationValidationUtil.validateAggregationFilter(this.parent.isHasFilter(), that.parent.isHasFilter());
    }

    @Override
    public AggregationAgentForge getAggregationStateAgent(EngineImportService engineImportService, String statementName) {
        return null;
    }

    @Override
    public ExprForge[] getMethodAggregationForge(boolean join, EventType[] typesPerStream) throws ExprValidationException {
        return ExprMethodAggUtil.getDefaultForges(this.parent.getPositionalParams(), join, typesPerStream);
    }

    private Class getSumAggregatorType(Class type) {
        if (type == BigInteger.class) {
            return BigInteger.class;
        }
        if (type == BigDecimal.class) {
            return BigDecimal.class;
        }
        if (type == Long.class || type == Long.TYPE) {
            return Long.class;
        }
        if (type == Integer.class || type == Integer.TYPE) {
            return Integer.class;
        }
        if (type == Double.class || type == Double.TYPE) {
            return Double.class;
        }
        if (type == Float.class || type == Float.TYPE) {
            return Float.class;
        }
        return Integer.class;
    }

    @Override
    public void rowMemberCodegen(int column, CodegenCtor ctor, CodegenMembersColumnized membersColumnized, ExprForge[] forges, CodegenClassScope classScope) {
        if (this.inputValueType == BigInteger.class) {
            AggregatorSumBigInteger.rowMemberCodegen(this.parent.isDistinct(), column, ctor, membersColumnized);
            return;
        }
        if (this.inputValueType == BigDecimal.class) {
            AggregatorSumBigDecimal.rowMemberCodegen(this.parent.isDistinct(), column, ctor, membersColumnized);
            return;
        }
        Class<Number> type = this.inputValueType == Long.class || this.inputValueType == Long.TYPE ? Long.TYPE : (this.inputValueType == Integer.class || this.inputValueType == Integer.TYPE ? Integer.TYPE : (this.inputValueType == Double.class || this.inputValueType == Double.TYPE ? Double.TYPE : (this.inputValueType == Float.class || this.inputValueType == Float.TYPE ? Float.TYPE : Integer.TYPE)));
        AggregatorCodegenUtil.rowMemberSumAndCnt(this.parent.isDistinct(), column, ctor, membersColumnized, type);
    }

    @Override
    public void applyEnterCodegen(int column, CodegenMethodNode method, ExprForgeCodegenSymbol symbols, ExprForge[] forges, CodegenClassScope classScope) {
        if (this.inputValueType == BigInteger.class) {
            AggregatorSumBigInteger.applyEnterCodegen(this.parent.isDistinct(), this.parent.isHasFilter(), column, method, symbols, forges, classScope);
        } else if (this.inputValueType == BigDecimal.class) {
            AggregatorSumBigDecimal.applyEnterCodegen(this.parent.isDistinct(), this.parent.isHasFilter(), column, method, symbols, forges, classScope);
        } else {
            SimpleNumberCoercer coercer = this.getCoercerNonBigIntDec(this.inputValueType);
            AggregatorCodegenUtil.sumAndCountApplyEnterCodegen(this.parent.isDistinct(), this.parent.isHasFilter(), column, method, symbols, forges, classScope, coercer);
        }
    }

    @Override
    public void applyLeaveCodegen(int column, CodegenMethodNode method, ExprForgeCodegenSymbol symbols, ExprForge[] forges, CodegenClassScope classScope) {
        if (this.inputValueType == BigInteger.class) {
            AggregatorSumBigInteger.applyLeaveCodegen(this.parent.isDistinct(), this.parent.isHasFilter(), column, method, symbols, forges, classScope);
        } else if (this.inputValueType == BigDecimal.class) {
            AggregatorSumBigDecimal.applyLeaveCodegen(this.parent.isDistinct(), this.parent.isHasFilter(), column, method, symbols, forges, classScope);
        } else {
            SimpleNumberCoercer coercer = this.getCoercerNonBigIntDec(this.inputValueType);
            AggregatorCodegenUtil.sumAndCountApplyLeaveCodegen(this.parent.isDistinct(), this.parent.isHasFilter(), column, method, symbols, forges, classScope, coercer);
        }
    }

    @Override
    public void clearCodegen(int column, CodegenMethodNode method, CodegenClassScope classScope) {
        if (this.inputValueType == BigInteger.class) {
            AggregatorSumBigInteger.clearCodegen(this.parent.isDistinct(), column, method);
        } else if (this.inputValueType == BigDecimal.class) {
            AggregatorSumBigDecimal.clearCodegen(this.parent.isDistinct(), column, method);
        } else {
            AggregatorCodegenUtil.sumAndCountClearCodegen(this.parent.isDistinct(), column, method);
        }
    }

    @Override
    public void getValueCodegen(int column, CodegenMethodNode method, CodegenClassScope classScope) {
        if (this.inputValueType == BigInteger.class) {
            AggregatorSumBigInteger.getValueCodegen(column, method);
        } else if (this.inputValueType == BigDecimal.class) {
            AggregatorSumBigDecimal.getValueCodegen(column, method);
        } else {
            AggregatorCodegenUtil.getValueSum(column, method);
        }
    }

    private AggregationMethod makeSumAggregator(Class type, boolean hasFilter) {
        if (!hasFilter) {
            if (type == BigInteger.class) {
                return new AggregatorSumBigInteger();
            }
            if (type == BigDecimal.class) {
                return new AggregatorSumBigDecimal();
            }
            if (type == Long.class || type == Long.TYPE) {
                return new AggregatorSumLong();
            }
            if (type == Integer.class || type == Integer.TYPE) {
                return new AggregatorSumInteger();
            }
            if (type == Double.class || type == Double.TYPE) {
                return new AggregatorSumDouble();
            }
            if (type == Float.class || type == Float.TYPE) {
                return new AggregatorSumFloat();
            }
            return new AggregatorSumNumInteger();
        }
        if (type == BigInteger.class) {
            return new AggregatorSumBigIntegerFilter();
        }
        if (type == BigDecimal.class) {
            return new AggregatorSumBigDecimalFilter();
        }
        if (type == Long.class || type == Long.TYPE) {
            return new AggregatorSumLongFilter();
        }
        if (type == Integer.class || type == Integer.TYPE) {
            return new AggregatorSumIntegerFilter();
        }
        if (type == Double.class || type == Double.TYPE) {
            return new AggregatorSumDoubleFilter();
        }
        if (type == Float.class || type == Float.TYPE) {
            return new AggregatorSumFloatFilter();
        }
        return new AggregatorSumNumIntegerFilter();
    }

    private SimpleNumberCoercer getCoercerNonBigIntDec(Class inputValueType) {
        SimpleNumberCoercer coercer = inputValueType == Long.class || inputValueType == Long.TYPE ? SimpleNumberCoercerFactory.SimpleNumberCoercerLong.INSTANCE : (inputValueType == Integer.class || inputValueType == Integer.TYPE ? SimpleNumberCoercerFactory.SimpleNumberCoercerInt.INSTANCE : (inputValueType == Double.class || inputValueType == Double.TYPE ? SimpleNumberCoercerFactory.SimpleNumberCoercerDouble.INSTANCE : (inputValueType == Float.class || inputValueType == Float.TYPE ? SimpleNumberCoercerFactory.SimpleNumberCoercerFloat.INSTANCE : SimpleNumberCoercerFactory.SimpleNumberCoercerInt.INSTANCE)));
        return coercer;
    }
}

