/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.agg.service.common;

import com.espertech.esper.client.EPException;
import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.client.annotation.Hint;
import com.espertech.esper.client.annotation.HintEnum;
import com.espertech.esper.client.annotation.HookType;
import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.epl.agg.access.AggregationAccessorForge;
import com.espertech.esper.epl.agg.access.AggregationAccessorSlotPair;
import com.espertech.esper.epl.agg.access.AggregationAccessorSlotPairForge;
import com.espertech.esper.epl.agg.access.AggregationAgent;
import com.espertech.esper.epl.agg.access.AggregationAgentForge;
import com.espertech.esper.epl.agg.service.common.AggregationGroupByRollupDesc;
import com.espertech.esper.epl.agg.service.common.AggregationMethodFactory;
import com.espertech.esper.epl.agg.service.common.AggregationMultiFunctionAnalysisHelper;
import com.espertech.esper.epl.agg.service.common.AggregationMultiFunctionAnalysisResult;
import com.espertech.esper.epl.agg.service.common.AggregationRowStateForgeDesc;
import com.espertech.esper.epl.agg.service.common.AggregationServiceAggExpressionDesc;
import com.espertech.esper.epl.agg.service.common.AggregationServiceFactoryForge;
import com.espertech.esper.epl.agg.service.common.AggregationServiceFactoryService;
import com.espertech.esper.epl.agg.service.common.AggregationServiceForgeDesc;
import com.espertech.esper.epl.agg.service.common.AggregationServiceMatchRecognizeFactoryDesc;
import com.espertech.esper.epl.agg.service.common.AggregationServiceMatchRecognizeFactoryImpl;
import com.espertech.esper.epl.agg.service.common.AggregationStateFactoryForge;
import com.espertech.esper.epl.agg.service.common.AggregatorUtil;
import com.espertech.esper.epl.agg.service.groupby.AggGroupByDesc;
import com.espertech.esper.epl.agg.service.groupby.AggSvcGroupByReclaimAgedEvalFunc;
import com.espertech.esper.epl.agg.service.groupby.AggSvcGroupByReclaimAgedEvalFuncConstant;
import com.espertech.esper.epl.agg.service.groupby.AggSvcGroupByReclaimAgedEvalFuncFactory;
import com.espertech.esper.epl.agg.service.groupby.AggSvcGroupByReclaimAgedEvalFuncVariable;
import com.espertech.esper.epl.agg.util.AggregationGroupByLocalGroupByAnalyzer;
import com.espertech.esper.epl.agg.util.AggregationGroupByLocalGroupDesc;
import com.espertech.esper.epl.agg.util.AggregationGroupByLocalGroupLevel;
import com.espertech.esper.epl.agg.util.AggregationLocalGroupByPlanForge;
import com.espertech.esper.epl.agg.util.AggregationLocalLevelHook;
import com.espertech.esper.epl.core.engineimport.EngineImportService;
import com.espertech.esper.epl.core.engineimport.EngineImportUtil;
import com.espertech.esper.epl.declexpr.ExprDeclaredNode;
import com.espertech.esper.epl.expression.baseagg.ExprAggregateLocalGroupByDesc;
import com.espertech.esper.epl.expression.baseagg.ExprAggregateNode;
import com.espertech.esper.epl.expression.baseagg.ExprAggregateNodeBase;
import com.espertech.esper.epl.expression.baseagg.ExprAggregateNodeGroupKey;
import com.espertech.esper.epl.expression.codegen.ExprNodeCompiler;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprForge;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprNodeUtilityCore;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.expression.methodagg.ExprMethodAggUtil;
import com.espertech.esper.epl.expression.table.ExprTableNodeUtil;
import com.espertech.esper.epl.expression.time.TimeAbacus;
import com.espertech.esper.epl.expression.visitor.ExprNodePreviousVisitorWParent;
import com.espertech.esper.epl.spec.IntoTableSpec;
import com.espertech.esper.epl.table.mgmt.TableColumnMethodPair;
import com.espertech.esper.epl.table.mgmt.TableMetadata;
import com.espertech.esper.epl.table.mgmt.TableMetadataColumnAggregation;
import com.espertech.esper.epl.table.mgmt.TableService;
import com.espertech.esper.epl.util.EPLValidationUtil;
import com.espertech.esper.epl.util.ExprNodeUtilityRich;
import com.espertech.esper.epl.variable.VariableMetaData;
import com.espertech.esper.epl.variable.VariableReader;
import com.espertech.esper.epl.variable.VariableService;
import com.espertech.esper.epl.variable.VariableServiceUtil;
import com.espertech.esper.util.JavaClassHelper;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;

public class AggregationServiceFactoryFactory {
    public static AggregationServiceMatchRecognizeFactoryDesc getServiceMatchRecognize(int numStreams, Map<Integer, List<ExprAggregateNode>> measureExprNodesPerStream, EventType[] typesPerStream, EngineImportService engineImportService, String statementName) throws ExprValidationException {
        TreeMap equivalencyListPerStream = new TreeMap();
        for (Map.Entry<Integer, List<ExprAggregateNode>> entry : measureExprNodesPerStream.entrySet()) {
            ArrayList equivalencyList = new ArrayList();
            equivalencyListPerStream.put(entry.getKey(), equivalencyList);
            for (ExprAggregateNode selectAggNode : entry.getValue()) {
                AggregationServiceFactoryFactory.addEquivalent(selectAggNode, equivalencyList);
            }
        }
        LinkedHashMap<Integer, AggregationMethodFactory[]> aggregatorsPerStream = new LinkedHashMap<Integer, AggregationMethodFactory[]>();
        HashMap<Integer, ExprEvaluator[]> evaluatorsPerStream = new HashMap<Integer, ExprEvaluator[]>();
        for (Map.Entry entry : equivalencyListPerStream.entrySet()) {
            int index = 0;
            int stream = (Integer)entry.getKey();
            AggregationMethodFactory[] aggregators = new AggregationMethodFactory[((List)entry.getValue()).size()];
            aggregatorsPerStream.put(stream, aggregators);
            ExprEvaluator[] evaluators = new ExprEvaluator[((List)entry.getValue()).size()];
            evaluatorsPerStream.put(stream, evaluators);
            for (AggregationServiceAggExpressionDesc aggregation : (List)entry.getValue()) {
                ExprAggregateNode aggregateNode = aggregation.getAggregationNode();
                evaluators[index] = aggregateNode.getChildNodes().length > 1 ? ExprMethodAggUtil.getMultiNodeEvaluator(aggregateNode.getChildNodes(), typesPerStream.length > 1, typesPerStream) : (aggregateNode.getChildNodes().length > 0 ? ExprNodeCompiler.allocateEvaluator(aggregateNode.getChildNodes()[0].getForge(), engineImportService, AggregationServiceFactoryFactory.class, false, statementName) : new ExprEvaluator(){

                    @Override
                    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
                        return null;
                    }
                });
                aggregators[index] = aggregateNode.getFactory();
                ++index;
            }
        }
        int columnNumber = 0;
        ArrayList<AggregationServiceAggExpressionDesc> arrayList = new ArrayList<AggregationServiceAggExpressionDesc>();
        for (Map.Entry equivalencyPerStream : equivalencyListPerStream.entrySet()) {
            for (AggregationServiceAggExpressionDesc entry : (List)equivalencyPerStream.getValue()) {
                entry.setColumnNum(columnNumber++);
            }
            arrayList.addAll((Collection)equivalencyPerStream.getValue());
        }
        AggregationServiceMatchRecognizeFactoryImpl factory = new AggregationServiceMatchRecognizeFactoryImpl(numStreams, aggregatorsPerStream, evaluatorsPerStream);
        return new AggregationServiceMatchRecognizeFactoryDesc(factory, arrayList);
    }

    public static AggregationServiceForgeDesc getService(List<ExprAggregateNode> selectAggregateExprNodes, Map<ExprNode, String> selectClauseNamedNodes, List<ExprDeclaredNode> declaredExpressions, ExprNode[] groupByNodes, List<ExprAggregateNode> havingAggregateExprNodes, List<ExprAggregateNode> orderByAggregateExprNodes, List<ExprAggregateNodeGroupKey> groupKeyExpressions, boolean hasGroupByClause, Annotation[] annotations, VariableService variableService, boolean isJoin, boolean isDisallowNoReclaim, ExprNode whereClause, ExprNode havingClause, AggregationServiceFactoryService factoryService, EventType[] typesPerStream, AggregationGroupByRollupDesc groupByRollupDesc, String optionalContextName, IntoTableSpec intoTableSpec, TableService tableService, boolean isUnidirectional, boolean isFireAndForget, boolean isOnSelect, EngineImportService engineImportService, String statementName, TimeAbacus timeAbacus) throws ExprValidationException {
        AggregationServiceFactoryForge serviceForge;
        if (selectAggregateExprNodes.isEmpty() && havingAggregateExprNodes.isEmpty()) {
            if (intoTableSpec != null) {
                throw new ExprValidationException("Into-table requires at least one aggregation function");
            }
            return new AggregationServiceForgeDesc(factoryService.getNullAggregationService(), Collections.emptyList(), Collections.emptyList());
        }
        if (whereClause != null || havingClause != null) {
            ExprNodePreviousVisitorWParent visitor = new ExprNodePreviousVisitorWParent();
            if (whereClause != null) {
                whereClause.accept(visitor);
            }
            if (havingClause != null) {
                havingClause.accept(visitor);
            }
            if (visitor.getPrevious() != null && !visitor.getPrevious().isEmpty()) {
                String funcname = visitor.getPrevious().get(0).getSecond().getPreviousType().toString().toLowerCase(Locale.ENGLISH);
                throw new ExprValidationException("The '" + funcname + "' function may not occur in the where-clause or having-clause of a statement with aggregations as 'previous' does not provide remove stream data; Use the 'first','last','window' or 'count' aggregation functions instead");
            }
        }
        ArrayList<AggregationServiceAggExpressionDesc> aggregations = new ArrayList<AggregationServiceAggExpressionDesc>();
        for (ExprAggregateNode exprAggregateNode : selectAggregateExprNodes) {
            AggregationServiceFactoryFactory.addEquivalent(exprAggregateNode, aggregations);
        }
        for (ExprAggregateNode exprAggregateNode : havingAggregateExprNodes) {
            AggregationServiceFactoryFactory.addEquivalent(exprAggregateNode, aggregations);
        }
        for (ExprAggregateNode exprAggregateNode : orderByAggregateExprNodes) {
            AggregationServiceFactoryFactory.addEquivalent(exprAggregateNode, aggregations);
        }
        ArrayList<ExprForge[]> methodAggForgesList = new ArrayList<ExprForge[]>();
        for (AggregationServiceAggExpressionDesc aggregation : aggregations) {
            ExprAggregateNode aggregateNode = aggregation.getAggregationNode();
            if (aggregateNode.getFactory().isAccessAggregation()) continue;
            ExprForge[] forges = aggregateNode.getFactory().getMethodAggregationForge(typesPerStream.length > 1, typesPerStream);
            methodAggForgesList.add(forges);
        }
        AggregationGroupByLocalGroupDesc aggregationGroupByLocalGroupDesc = AggregationServiceFactoryFactory.analyzeLocalGroupBy(aggregations, groupByNodes, groupByRollupDesc, intoTableSpec);
        if (intoTableSpec != null) {
            TableMetadata metadata = tableService.getTableMetadata(intoTableSpec.getName());
            if (metadata == null) {
                throw new ExprValidationException("Invalid into-table clause: Failed to find table by name '" + intoTableSpec.getName() + "'");
            }
            EPLValidationUtil.validateContextName(true, intoTableSpec.getName(), metadata.getContextName(), optionalContextName, false);
            Class[] groupByTypes = ExprNodeUtilityCore.getExprResultTypes(groupByNodes);
            ExprTableNodeUtil.validateExpressions(intoTableSpec.getName(), groupByTypes, "group-by", groupByNodes, metadata.getKeyTypes(), "group-by");
            BindingMatchResult bindingMatchResult = AggregationServiceFactoryFactory.matchBindingsAssignColumnNumbers(intoTableSpec, metadata, aggregations, selectClauseNamedNodes, methodAggForgesList, declaredExpressions, engineImportService, statementName, isFireAndForget);
            AggregationAccessorSlotPair[] accessorPairs = AggregatorUtil.getAccessorsForForges(bindingMatchResult.getAccessors(), engineImportService, isFireAndForget, statementName);
            AggregationAgent[] agents = AggregatorUtil.getAgentForges(bindingMatchResult.getAgents(), engineImportService, isFireAndForget, statementName);
            AggregationServiceFactoryForge serviceForge2 = factoryService.getTable(tableService, metadata, bindingMatchResult.getMethodPairs(), bindingMatchResult.getAccessors(), accessorPairs, isJoin, bindingMatchResult.getTargetStates(), bindingMatchResult.getAccessStateExpr(), bindingMatchResult.getAgents(), agents, groupByRollupDesc, hasGroupByClause);
            return new AggregationServiceForgeDesc(serviceForge2, aggregations, groupKeyExpressions);
        }
        int columnNumber = 0;
        for (AggregationServiceAggExpressionDesc entry : aggregations) {
            if (entry.getFactory().isAccessAggregation()) continue;
            entry.setColumnNum(columnNumber++);
        }
        for (AggregationServiceAggExpressionDesc entry : aggregations) {
            if (!entry.getFactory().isAccessAggregation()) continue;
            entry.setColumnNum(columnNumber++);
        }
        ExprForge[][] methodAggForges = (ExprForge[][])methodAggForgesList.toArray((T[])new ExprForge[methodAggForgesList.size()][]);
        AggregationMethodFactory[] methodAggFactories = new AggregationMethodFactory[methodAggForges.length];
        int count = 0;
        for (AggregationServiceAggExpressionDesc aggregation : aggregations) {
            ExprAggregateNode aggregateNode = aggregation.getAggregationNode();
            if (aggregateNode.getFactory().isAccessAggregation()) continue;
            methodAggFactories[count] = aggregateNode.getFactory();
            ++count;
        }
        AggregationMultiFunctionAnalysisResult multiFunctionAggPlan = AggregationMultiFunctionAnalysisHelper.analyzeAccessAggregations(aggregations, engineImportService, isFireAndForget, statementName, groupByNodes);
        AggregationAccessorSlotPairForge[] accessorPairsForge = multiFunctionAggPlan.getAccessorPairsForge();
        AggregationStateFactoryForge[] accessFactories = multiFunctionAggPlan.getStateFactoryForges();
        boolean hasAccessAgg = accessorPairsForge.length > 0;
        boolean hasMethodAgg = methodAggFactories.length > 0;
        AggregationLocalGroupByPlanForge localGroupByPlan = null;
        if (aggregationGroupByLocalGroupDesc != null) {
            localGroupByPlan = AggregationGroupByLocalGroupByAnalyzer.analyze(methodAggForges, methodAggFactories, accessFactories, aggregationGroupByLocalGroupDesc, groupByNodes, accessorPairsForge, engineImportService, isFireAndForget, statementName);
            try {
                AggregationLocalLevelHook hook = (AggregationLocalLevelHook)EngineImportUtil.getAnnotationHook(annotations, HookType.INTERNAL_AGGLOCALLEVEL, AggregationLocalLevelHook.class, engineImportService);
                if (hook != null) {
                    hook.planned(aggregationGroupByLocalGroupDesc, localGroupByPlan);
                }
            }
            catch (ExprValidationException e) {
                throw new EPException("Failed to obtain hook for " + (Object)((Object)HookType.INTERNAL_AGGLOCALLEVEL));
            }
        }
        AggregationRowStateForgeDesc rowStateDesc = new AggregationRowStateForgeDesc(hasMethodAgg ? methodAggForges : (ExprForge[][])null, (AggregationMethodFactory[])(hasMethodAgg ? methodAggFactories : null), (AggregationAccessorSlotPairForge[])(hasAccessAgg ? accessorPairsForge : null), (AggregationStateFactoryForge[])(hasAccessAgg ? accessFactories : null));
        if (!hasGroupByClause) {
            serviceForge = localGroupByPlan != null ? factoryService.getGroupLocalGroupBy(false, isJoin, localGroupByPlan, isUnidirectional, isFireAndForget, isOnSelect) : factoryService.getNoGroup(rowStateDesc, isJoin, isUnidirectional, isFireAndForget, isOnSelect);
        } else {
            AggGroupByDesc groupDesc = new AggGroupByDesc(rowStateDesc, isJoin, isUnidirectional, isFireAndForget, isOnSelect, groupByNodes);
            boolean hasNoReclaim = HintEnum.DISABLE_RECLAIM_GROUP.getHint(annotations) != null;
            Hint reclaimGroupAged = HintEnum.RECLAIM_GROUP_AGED.getHint(annotations);
            Hint reclaimGroupFrequency = HintEnum.RECLAIM_GROUP_AGED.getHint(annotations);
            if (localGroupByPlan != null) {
                serviceForge = factoryService.getGroupLocalGroupBy(true, isJoin, localGroupByPlan, isUnidirectional, isFireAndForget, isOnSelect);
            } else if (!isDisallowNoReclaim && hasNoReclaim) {
                if (groupByRollupDesc != null) {
                    throw AggregationServiceFactoryFactory.getRollupReclaimEx();
                }
                serviceForge = factoryService.getGroupBy(groupDesc, timeAbacus, isUnidirectional, isFireAndForget, isOnSelect);
            } else if (!isDisallowNoReclaim && reclaimGroupAged != null) {
                if (groupByRollupDesc != null) {
                    throw AggregationServiceFactoryFactory.getRollupReclaimEx();
                }
                AggregationServiceFactoryFactory.compileReclaim(groupDesc, reclaimGroupAged, reclaimGroupFrequency, variableService, optionalContextName);
                serviceForge = factoryService.getGroupBy(groupDesc, timeAbacus, isUnidirectional, isFireAndForget, isOnSelect);
            } else if (groupByRollupDesc != null) {
                serviceForge = factoryService.getRollup(groupByNodes, groupByRollupDesc, rowStateDesc, isJoin, groupByRollupDesc, isUnidirectional, isFireAndForget, isOnSelect);
            } else {
                groupDesc.setRefcounted(true);
                serviceForge = factoryService.getGroupBy(groupDesc, timeAbacus, isUnidirectional, isFireAndForget, isOnSelect);
            }
        }
        return new AggregationServiceForgeDesc(serviceForge, aggregations, groupKeyExpressions);
    }

    private static void compileReclaim(AggGroupByDesc groupDesc, Hint reclaimGroupAged, Hint reclaimGroupFrequency, VariableService variableService, String optionalContextName) throws ExprValidationException {
        String hintValueMaxAge = HintEnum.RECLAIM_GROUP_AGED.getHintAssignedValue(reclaimGroupAged);
        if (hintValueMaxAge == null) {
            throw new ExprValidationException("Required hint value for hint '" + (Object)((Object)HintEnum.RECLAIM_GROUP_AGED) + "' has not been provided");
        }
        AggSvcGroupByReclaimAgedEvalFuncFactory evaluationFunctionMaxAge = AggregationServiceFactoryFactory.getEvaluationFunction(variableService, hintValueMaxAge, optionalContextName);
        groupDesc.setReclaimAged(true);
        groupDesc.setReclaimEvaluationFunctionMaxAge(evaluationFunctionMaxAge);
        String hintValueFrequency = HintEnum.RECLAIM_GROUP_FREQ.getHintAssignedValue(reclaimGroupAged);
        AggSvcGroupByReclaimAgedEvalFuncFactory evaluationFunctionFrequency = reclaimGroupFrequency == null || hintValueFrequency == null ? evaluationFunctionMaxAge : AggregationServiceFactoryFactory.getEvaluationFunction(variableService, hintValueFrequency, optionalContextName);
        groupDesc.setReclaimEvaluationFunctionFrequency(evaluationFunctionFrequency);
    }

    private static AggregationGroupByLocalGroupDesc analyzeLocalGroupBy(List<AggregationServiceAggExpressionDesc> aggregations, ExprNode[] groupByNodes, AggregationGroupByRollupDesc groupByRollupDesc, IntoTableSpec intoTableSpec) throws ExprValidationException {
        boolean hasOver = false;
        for (AggregationServiceAggExpressionDesc desc : aggregations) {
            if (desc.getAggregationNode().getOptionalLocalGroupBy() == null) continue;
            hasOver = true;
            break;
        }
        if (!hasOver) {
            return null;
        }
        if (groupByRollupDesc != null) {
            throw new ExprValidationException("Roll-up and group-by parameters cannot be combined");
        }
        if (intoTableSpec != null) {
            throw new ExprValidationException("Into-table and group-by parameters cannot be combined");
        }
        ArrayList<AggregationGroupByLocalGroupLevel> partitions = new ArrayList<AggregationGroupByLocalGroupLevel>();
        for (AggregationServiceAggExpressionDesc desc : aggregations) {
            ExprAggregateLocalGroupByDesc localGroupBy = desc.getAggregationNode().getOptionalLocalGroupBy();
            ExprNode[] partitionExpressions = localGroupBy == null ? groupByNodes : localGroupBy.getPartitionExpressions();
            List<AggregationServiceAggExpressionDesc> found = AggregationServiceFactoryFactory.findPartition(partitions, partitionExpressions);
            if (found == null) {
                found = new ArrayList<AggregationServiceAggExpressionDesc>();
                AggregationGroupByLocalGroupLevel level = new AggregationGroupByLocalGroupLevel(partitionExpressions, found);
                partitions.add(level);
            }
            found.add(desc);
        }
        if (partitions.size() == 1 && ExprNodeUtilityCore.deepEqualsIgnoreDupAndOrder(((AggregationGroupByLocalGroupLevel)partitions.get(0)).getPartitionExpr(), groupByNodes)) {
            return null;
        }
        return new AggregationGroupByLocalGroupDesc(aggregations.size(), partitions.toArray(new AggregationGroupByLocalGroupLevel[partitions.size()]));
    }

    private static List<AggregationServiceAggExpressionDesc> findPartition(List<AggregationGroupByLocalGroupLevel> partitions, ExprNode[] partitionExpressions) {
        for (AggregationGroupByLocalGroupLevel level : partitions) {
            if (!ExprNodeUtilityCore.deepEqualsIgnoreDupAndOrder(level.getPartitionExpr(), partitionExpressions)) continue;
            return level.getExpressions();
        }
        return null;
    }

    private static BindingMatchResult matchBindingsAssignColumnNumbers(IntoTableSpec bindings, TableMetadata metadata, List<AggregationServiceAggExpressionDesc> aggregations, Map<ExprNode, String> selectClauseNamedNodes, List<ExprForge[]> methodAggForgesList, List<ExprDeclaredNode> declaredExpressions, EngineImportService engineImportService, String statementName, boolean isFireAndForget) throws ExprValidationException {
        LinkedHashMap<AggregationServiceAggExpressionDesc, TableMetadataColumnAggregation> methodAggs = new LinkedHashMap<AggregationServiceAggExpressionDesc, TableMetadataColumnAggregation>();
        LinkedHashMap<AggregationServiceAggExpressionDesc, TableMetadataColumnAggregation> accessAggs = new LinkedHashMap<AggregationServiceAggExpressionDesc, TableMetadataColumnAggregation>();
        for (AggregationServiceAggExpressionDesc aggDesc : aggregations) {
            String columnName = AggregationServiceFactoryFactory.findColumnNameForAggregation(selectClauseNamedNodes, declaredExpressions, aggDesc.getAggregationNode());
            if (columnName == null) {
                throw new ExprValidationException("Failed to find an expression among the select-clause expressions for expression '" + ExprNodeUtilityCore.toExpressionStringMinPrecedenceSafe(aggDesc.getAggregationNode()) + "'");
            }
            TableMetadataColumnAggregation tableMetadataColumnAggregation = (TableMetadataColumnAggregation)metadata.getTableColumns().get(columnName);
            if (tableMetadataColumnAggregation == null) {
                throw new ExprValidationException("Failed to find name '" + (String)columnName + "' among the columns for table '" + bindings.getName() + "'");
            }
            AggregationServiceFactoryFactory.validateIntoTableCompatible(bindings.getName(), columnName, tableMetadataColumnAggregation, aggDesc);
            if (!tableMetadataColumnAggregation.getFactory().isAccessAggregation()) {
                methodAggs.put(aggDesc, tableMetadataColumnAggregation);
                continue;
            }
            accessAggs.put(aggDesc, tableMetadataColumnAggregation);
        }
        TableColumnMethodPair[] methodPairs = new TableColumnMethodPair[methodAggForgesList.size()];
        int methodIndex = -1;
        for (Map.Entry entry : methodAggs.entrySet()) {
            int targetIndex = ((TableMetadataColumnAggregation)entry.getValue()).getMethodOffset();
            ExprForge[] forges = methodAggForgesList.get(++methodIndex);
            ExprEvaluator evaluator = ExprNodeUtilityRich.getEvaluatorMayCompileWMultiValue(forges, engineImportService, AggregationServiceFactoryFactory.class, isFireAndForget, statementName);
            methodPairs[methodIndex] = new TableColumnMethodPair(evaluator, forges, targetIndex, ((AggregationServiceAggExpressionDesc)entry.getKey()).getAggregationNode());
            ((AggregationServiceAggExpressionDesc)entry.getKey()).setColumnNum(targetIndex);
        }
        LinkedHashMap<Integer, ExprAggregateNode> accessSlots = new LinkedHashMap<Integer, ExprAggregateNode>();
        ArrayList<AggregationAccessorSlotPairForge> arrayList = new ArrayList<AggregationAccessorSlotPairForge>();
        int accessIndex = -1;
        ArrayList<AggregationAgentForge> agents = new ArrayList<AggregationAgentForge>();
        for (Map.Entry entry : accessAggs.entrySet()) {
            ++accessIndex;
            int slot = ((TableMetadataColumnAggregation)entry.getValue()).getAccessAccessorSlotPair().getSlot();
            AggregationMethodFactory aggregationMethodFactory = ((AggregationServiceAggExpressionDesc)entry.getKey()).getFactory();
            AggregationAccessorForge accessorForge = aggregationMethodFactory.getAccessorForge();
            accessSlots.put(slot, ((AggregationServiceAggExpressionDesc)entry.getKey()).getAggregationNode());
            arrayList.add(new AggregationAccessorSlotPairForge(slot, accessorForge));
            ((AggregationServiceAggExpressionDesc)entry.getKey()).setColumnNum(metadata.getNumberMethodAggregations() + accessIndex);
            agents.add(aggregationMethodFactory.getAggregationStateAgent(engineImportService, statementName));
        }
        AggregationAgentForge[] agentArr = agents.toArray(new AggregationAgentForge[agents.size()]);
        AggregationAccessorSlotPairForge[] aggregationAccessorSlotPairForgeArray = arrayList.toArray(new AggregationAccessorSlotPairForge[arrayList.size()]);
        int[] targetStates = new int[accessSlots.size()];
        ExprNode[] accessStateExpr = new ExprNode[accessSlots.size()];
        int count = 0;
        for (Map.Entry entry : accessSlots.entrySet()) {
            targetStates[count] = (Integer)entry.getKey();
            accessStateExpr[count] = (ExprNode)entry.getValue();
            ++count;
        }
        return new BindingMatchResult(methodPairs, aggregationAccessorSlotPairForgeArray, targetStates, accessStateExpr, agentArr);
    }

    private static String findColumnNameForAggregation(Map<ExprNode, String> selectClauseNamedNodes, List<ExprDeclaredNode> declaredExpressions, ExprAggregateNode aggregationNode) {
        if (selectClauseNamedNodes.containsKey(aggregationNode)) {
            return selectClauseNamedNodes.get(aggregationNode);
        }
        for (ExprDeclaredNode node : declaredExpressions) {
            if (node.getBody() != aggregationNode) continue;
            return node.getPrototype().getName();
        }
        return null;
    }

    private static void validateIntoTableCompatible(String tableName, String columnName, TableMetadataColumnAggregation columnMetadata, AggregationServiceAggExpressionDesc aggDesc) throws ExprValidationException {
        AggregationMethodFactory factoryProvided = aggDesc.getFactory();
        AggregationMethodFactory factoryRequired = columnMetadata.getFactory();
        try {
            factoryRequired.validateIntoTableCompatible(factoryProvided);
        }
        catch (ExprValidationException ex) {
            String text = AggregationServiceFactoryFactory.getMessage(tableName, columnName, factoryRequired.getAggregationExpression(), factoryProvided.getAggregationExpression());
            throw new ExprValidationException(text + ": " + ex.getMessage(), ex);
        }
    }

    private static String getMessage(String tableName, String columnName, ExprAggregateNodeBase aggregationRequired, ExprAggregateNodeBase aggregationProvided) {
        return "Incompatible aggregation function for table '" + tableName + "' column '" + columnName + "', expecting '" + ExprNodeUtilityCore.toExpressionStringMinPrecedenceSafe(aggregationRequired) + "' and received '" + ExprNodeUtilityCore.toExpressionStringMinPrecedenceSafe(aggregationProvided) + "'";
    }

    private static void addEquivalent(ExprAggregateNode aggNodeToAdd, List<AggregationServiceAggExpressionDesc> equivalencyList) {
        boolean foundEquivalent = false;
        for (AggregationServiceAggExpressionDesc existing : equivalencyList) {
            ExprAggregateNode aggNode = existing.getAggregationNode();
            if (!aggNode.equalsNode(aggNodeToAdd, false) || !ExprNodeUtilityCore.deepEquals(aggNode.getPositionalParams(), aggNodeToAdd.getPositionalParams(), false) || !ExprNodeUtilityCore.deepEqualsNullChecked(aggNode.getOptionalFilter(), aggNodeToAdd.getOptionalFilter(), false) || (aggNode.getOptionalLocalGroupBy() != null || aggNodeToAdd.getOptionalLocalGroupBy() != null) && (aggNode.getOptionalLocalGroupBy() == null && aggNodeToAdd.getOptionalLocalGroupBy() != null || aggNode.getOptionalLocalGroupBy() != null && aggNodeToAdd.getOptionalLocalGroupBy() == null || !ExprNodeUtilityCore.deepEqualsIgnoreDupAndOrder(aggNode.getOptionalLocalGroupBy().getPartitionExpressions(), aggNodeToAdd.getOptionalLocalGroupBy().getPartitionExpressions()))) continue;
            existing.addEquivalent(aggNodeToAdd);
            foundEquivalent = true;
            break;
        }
        if (!foundEquivalent) {
            equivalencyList.add(new AggregationServiceAggExpressionDesc(aggNodeToAdd, aggNodeToAdd.getFactory()));
        }
    }

    private static AggSvcGroupByReclaimAgedEvalFuncFactory getEvaluationFunction(final VariableService variableService, String hintValue, String optionalContextName) throws ExprValidationException {
        Double valueDouble;
        final VariableMetaData variableMetaData = variableService.getVariableMetaData(hintValue);
        if (variableMetaData != null) {
            if (!JavaClassHelper.isNumeric(variableMetaData.getType())) {
                throw new ExprValidationException("Variable type of variable '" + variableMetaData.getVariableName() + "' is not numeric");
            }
            String message = VariableServiceUtil.checkVariableContextName(optionalContextName, variableMetaData);
            if (message != null) {
                throw new ExprValidationException(message);
            }
            return new AggSvcGroupByReclaimAgedEvalFuncFactory(){

                @Override
                public AggSvcGroupByReclaimAgedEvalFunc make(AgentInstanceContext agentInstanceContext) {
                    VariableReader reader = variableService.getReader(variableMetaData.getVariableName(), agentInstanceContext.getAgentInstanceId());
                    return new AggSvcGroupByReclaimAgedEvalFuncVariable(reader);
                }
            };
        }
        try {
            valueDouble = Double.parseDouble(hintValue);
        }
        catch (RuntimeException ex) {
            throw new ExprValidationException("Failed to parse hint parameter value '" + hintValue + "' as a double-typed seconds value or variable name");
        }
        if (valueDouble <= 0.0) {
            throw new ExprValidationException("Hint parameter value '" + hintValue + "' is an invalid value, expecting a double-typed seconds value or variable name");
        }
        return new AggSvcGroupByReclaimAgedEvalFuncFactory(){

            @Override
            public AggSvcGroupByReclaimAgedEvalFunc make(AgentInstanceContext agentInstanceContext) {
                return new AggSvcGroupByReclaimAgedEvalFuncConstant(valueDouble);
            }
        };
    }

    public static ExprValidationException getRollupReclaimEx() {
        return new ExprValidationException("Reclaim hints are not available with rollup");
    }

    private static class BindingMatchResult {
        private final TableColumnMethodPair[] methodPairs;
        private final AggregationAccessorSlotPairForge[] accessors;
        private final int[] targetStates;
        private final ExprNode[] accessStateExpr;
        private final AggregationAgentForge[] agents;

        private BindingMatchResult(TableColumnMethodPair[] methodPairs, AggregationAccessorSlotPairForge[] accessors, int[] targetStates, ExprNode[] accessStateExpr, AggregationAgentForge[] agents) {
            this.methodPairs = methodPairs;
            this.accessors = accessors;
            this.targetStates = targetStates;
            this.accessStateExpr = accessStateExpr;
            this.agents = agents;
        }

        public TableColumnMethodPair[] getMethodPairs() {
            return this.methodPairs;
        }

        public AggregationAccessorSlotPairForge[] getAccessors() {
            return this.accessors;
        }

        public int[] getTargetStates() {
            return this.targetStates;
        }

        public AggregationAgentForge[] getAgents() {
            return this.agents;
        }

        public ExprNode[] getAccessStateExpr() {
            return this.accessStateExpr;
        }
    }
}

