/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.agg.service.groupby;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.agg.aggregator.AggregationMethod;
import com.espertech.esper.epl.agg.service.common.AggSvcGroupByUtil;
import com.espertech.esper.epl.agg.service.common.AggregationGroupByRollupLevel;
import com.espertech.esper.epl.agg.service.common.AggregationMethodFactory;
import com.espertech.esper.epl.agg.service.common.AggregationMethodRow;
import com.espertech.esper.epl.agg.service.common.AggregationRowRemovedCallback;
import com.espertech.esper.epl.agg.service.common.AggregationServiceBaseGrouped;
import com.espertech.esper.epl.agg.service.common.AggregationServiceVisitor;
import com.espertech.esper.epl.agg.service.common.AggregationServiceVisitorWGroupDetail;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AggSvcGroupByRefcountedNoAccessImpl
extends AggregationServiceBaseGrouped {
    protected Map<Object, AggregationMethodRow> aggregatorsPerGroup = new HashMap<Object, AggregationMethodRow>();
    private AggregationMethod[] currentAggregatorRow;
    private Object currentGroupKey;
    private List<Object> removedKeys = new ArrayList<Object>();

    public AggSvcGroupByRefcountedNoAccessImpl(ExprEvaluator[] evaluators, AggregationMethodFactory[] prototypes) {
        super(evaluators, prototypes);
    }

    @Override
    public void clearResults(ExprEvaluatorContext exprEvaluatorContext) {
        this.aggregatorsPerGroup.clear();
    }

    @Override
    public void applyEnter(EventBean[] eventsPerStream, Object groupByKey, ExprEvaluatorContext exprEvaluatorContext) {
        AggregationMethod[] groupAggregators;
        this.handleRemovedKeys();
        AggregationMethodRow row = this.aggregatorsPerGroup.get(groupByKey);
        if (row == null) {
            groupAggregators = AggSvcGroupByUtil.newAggregators(this.aggregators);
            row = new AggregationMethodRow(1L, groupAggregators);
            this.aggregatorsPerGroup.put(groupByKey, row);
        } else {
            groupAggregators = row.getMethods();
            row.increaseRefcount();
        }
        this.currentAggregatorRow = groupAggregators;
        for (int i = 0; i < this.evaluators.length; ++i) {
            Object columnResult = this.evaluators[i].evaluate(eventsPerStream, true, exprEvaluatorContext);
            groupAggregators[i].enter(columnResult);
        }
    }

    @Override
    public void applyLeave(EventBean[] eventsPerStream, Object groupByKey, ExprEvaluatorContext exprEvaluatorContext) {
        AggregationMethod[] groupAggregators;
        AggregationMethodRow row = this.aggregatorsPerGroup.get(groupByKey);
        if (row != null) {
            groupAggregators = row.getMethods();
        } else {
            groupAggregators = AggSvcGroupByUtil.newAggregators(this.aggregators);
            row = new AggregationMethodRow(1L, groupAggregators);
            this.aggregatorsPerGroup.put(groupByKey, row);
        }
        this.currentAggregatorRow = groupAggregators;
        for (int i = 0; i < this.evaluators.length; ++i) {
            Object columnResult = this.evaluators[i].evaluate(eventsPerStream, false, exprEvaluatorContext);
            groupAggregators[i].leave(columnResult);
        }
        row.decreaseRefcount();
        if (row.getRefcount() <= 0L) {
            this.removedKeys.add(groupByKey);
        }
    }

    @Override
    public void setCurrentAccess(Object groupByKey, int agentInstanceId, AggregationGroupByRollupLevel rollupLevel) {
        AggregationMethodRow row = this.aggregatorsPerGroup.get(groupByKey);
        this.currentAggregatorRow = row != null ? row.getMethods() : null;
        if (this.currentAggregatorRow == null) {
            this.currentAggregatorRow = AggSvcGroupByUtil.newAggregators(this.aggregators);
        }
        this.currentGroupKey = groupByKey;
    }

    @Override
    public Object getValue(int column, int agentInstanceId, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        return this.currentAggregatorRow[column].getValue();
    }

    @Override
    public Collection<EventBean> getCollectionOfEvents(int column, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        return null;
    }

    @Override
    public Collection<Object> getCollectionScalar(int column, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        return null;
    }

    @Override
    public EventBean getEventBean(int column, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        return null;
    }

    @Override
    public void setRemovedCallback(AggregationRowRemovedCallback callback) {
    }

    @Override
    public void accept(AggregationServiceVisitor visitor) {
        visitor.visitAggregations(this.aggregatorsPerGroup.size(), this.aggregatorsPerGroup);
    }

    @Override
    public void acceptGroupDetail(AggregationServiceVisitorWGroupDetail visitor) {
        visitor.visitGrouped(this.aggregatorsPerGroup.size());
        for (Map.Entry<Object, AggregationMethodRow> entry : this.aggregatorsPerGroup.entrySet()) {
            visitor.visitGroup(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public boolean isGrouped() {
        return true;
    }

    @Override
    public Object getGroupKey(int agentInstanceId) {
        return this.currentGroupKey;
    }

    protected void handleRemovedKeys() {
        if (!this.removedKeys.isEmpty()) {
            for (Object removedKey : this.removedKeys) {
                this.aggregatorsPerGroup.remove(removedKey);
            }
            this.removedKeys.clear();
        }
    }

    @Override
    public Collection<Object> getGroupKeys(ExprEvaluatorContext exprEvaluatorContext) {
        this.handleRemovedKeys();
        return this.aggregatorsPerGroup.keySet();
    }
}

