/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.core.poll;

import com.espertech.esper.client.ConfigurationInformation;
import com.espertech.esper.client.EPException;
import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.IterablesArrayIterator;
import com.espertech.esper.core.service.StatementContext;
import com.espertech.esper.epl.core.engineimport.EngineImportService;
import com.espertech.esper.epl.core.poll.MethodPollingExecStrategyEnum;
import com.espertech.esper.epl.core.poll.MethodPollingExecStrategyEventBeans;
import com.espertech.esper.epl.core.poll.MethodPollingExecStrategyMapArray;
import com.espertech.esper.epl.core.poll.MethodPollingExecStrategyMapCollection;
import com.espertech.esper.epl.core.poll.MethodPollingExecStrategyMapIterator;
import com.espertech.esper.epl.core.poll.MethodPollingExecStrategyMapPlain;
import com.espertech.esper.epl.core.poll.MethodPollingExecStrategyOAArray;
import com.espertech.esper.epl.core.poll.MethodPollingExecStrategyOACollection;
import com.espertech.esper.epl.core.poll.MethodPollingExecStrategyOAIterator;
import com.espertech.esper.epl.core.poll.MethodPollingExecStrategyOAPlain;
import com.espertech.esper.epl.core.poll.MethodPollingExecStrategyPOJOArray;
import com.espertech.esper.epl.core.poll.MethodPollingExecStrategyPOJOCollection;
import com.espertech.esper.epl.core.poll.MethodPollingExecStrategyPOJOIterator;
import com.espertech.esper.epl.core.poll.MethodPollingExecStrategyPOJOPlain;
import com.espertech.esper.epl.core.poll.MethodPollingExecStrategyScript;
import com.espertech.esper.epl.core.poll.MethodPollingViewableMeta;
import com.espertech.esper.epl.core.streamtype.StreamTypeService;
import com.espertech.esper.epl.db.DataCache;
import com.espertech.esper.epl.db.PollExecStrategy;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprNodeOrigin;
import com.espertech.esper.epl.expression.core.ExprNodePropOrStreamDesc;
import com.espertech.esper.epl.expression.core.ExprNodeUtilMethodDesc;
import com.espertech.esper.epl.expression.core.ExprNodeUtilResolveExceptionHandler;
import com.espertech.esper.epl.expression.core.ExprNodeUtilityCore;
import com.espertech.esper.epl.expression.core.ExprValidationContext;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.expression.visitor.ExprNodeIdentifierAndStreamRefVisitor;
import com.espertech.esper.epl.join.pollindex.PollResultIndexingStrategy;
import com.espertech.esper.epl.join.table.EventTable;
import com.espertech.esper.epl.join.table.UnindexedEventTableList;
import com.espertech.esper.epl.spec.MethodStreamSpec;
import com.espertech.esper.epl.table.mgmt.TableService;
import com.espertech.esper.epl.util.ExprNodeUtilityRich;
import com.espertech.esper.epl.variable.VariableReader;
import com.espertech.esper.epl.variable.VariableService;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.schedule.SchedulingService;
import com.espertech.esper.schedule.TimeProvider;
import com.espertech.esper.util.JavaClassHelper;
import com.espertech.esper.view.HistoricalEventViewable;
import com.espertech.esper.view.View;
import com.espertech.esper.view.ViewSupport;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import net.sf.cglib.reflect.FastMethod;

public class MethodPollingViewable
implements HistoricalEventViewable {
    private final MethodStreamSpec methodStreamSpec;
    private final DataCache dataCache;
    private final EventType eventType;
    private final ThreadLocal<DataCache> dataCacheThreadLocal = new ThreadLocal();
    private final ExprEvaluatorContext exprEvaluatorContext;
    private final MethodPollingViewableMeta metadata;
    private PollExecStrategy pollExecStrategy;
    private SortedSet<Integer> requiredStreams;
    private ExprEvaluator[] validatedExprNodes;
    private StatementContext statementContext;
    private static final EventBean[][] NULL_ROWS = new EventBean[1][];
    private static final PollResultIndexingStrategy ITERATOR_INDEXING_STRATEGY;

    public MethodPollingViewable(MethodStreamSpec methodStreamSpec, DataCache dataCache, EventType eventType, ExprEvaluatorContext exprEvaluatorContext, MethodPollingViewableMeta metadata) {
        this.methodStreamSpec = methodStreamSpec;
        this.dataCache = dataCache;
        this.eventType = eventType;
        this.exprEvaluatorContext = exprEvaluatorContext;
        this.metadata = metadata;
    }

    @Override
    public void stop() {
        this.pollExecStrategy.destroy();
        this.dataCache.destroy();
    }

    @Override
    public ThreadLocal<DataCache> getDataCacheThreadLocal() {
        return this.dataCacheThreadLocal;
    }

    @Override
    public DataCache getOptionalDataCache() {
        return this.dataCache;
    }

    @Override
    public void validate(EngineImportService engineImportService, StreamTypeService streamTypeService, TimeProvider timeProvider, VariableService variableService, TableService tableService, ExprEvaluatorContext exprEvaluatorContext, ConfigurationInformation configSnapshot, SchedulingService schedulingService, String engineURI, Map<Integer, List<ExprNode>> sqlParameters, EventAdapterService eventAdapterService, StatementContext statementContext) throws ExprValidationException {
        this.statementContext = statementContext;
        ExprValidationContext validationContext = new ExprValidationContext(streamTypeService, engineImportService, statementContext.getStatementExtensionServicesContext(), null, timeProvider, variableService, tableService, exprEvaluatorContext, eventAdapterService, statementContext.getStatementName(), statementContext.getStatementId(), statementContext.getAnnotations(), null, false, false, true, false, null, false);
        ExprNodeIdentifierAndStreamRefVisitor visitor = new ExprNodeIdentifierAndStreamRefVisitor(true);
        final ArrayList<ExprNode> validatedInputParameters = new ArrayList<ExprNode>();
        for (ExprNode exprNode : this.methodStreamSpec.getExpressions()) {
            ExprNode validated = ExprNodeUtilityRich.getValidatedSubtree(ExprNodeOrigin.METHODINVJOIN, exprNode, validationContext);
            validatedInputParameters.add(validated);
            validated.accept(visitor);
        }
        this.requiredStreams = new TreeSet<Integer>();
        for (ExprNodePropOrStreamDesc ref : visitor.getRefs()) {
            this.requiredStreams.add(ref.getStreamNum());
        }
        if (this.metadata.getMethodProviderClass() != null) {
            ExprNodeUtilResolveExceptionHandler handler = new ExprNodeUtilResolveExceptionHandler(){

                @Override
                public ExprValidationException handle(Exception e) {
                    if (MethodPollingViewable.this.methodStreamSpec.getExpressions().size() == 0) {
                        return new ExprValidationException("Method footprint does not match the number or type of expression parameters, expecting no parameters in method: " + e.getMessage());
                    }
                    Class[] resultTypes = ExprNodeUtilityCore.getExprResultTypes(validatedInputParameters);
                    return new ExprValidationException("Method footprint does not match the number or type of expression parameters, expecting a method where parameters are typed '" + JavaClassHelper.getParameterAsString(resultTypes) + "': " + e.getMessage());
                }
            };
            ExprNodeUtilMethodDesc desc = ExprNodeUtilityRich.resolveMethodAllowWildcardAndStream(this.metadata.getMethodProviderClass().getName(), this.metadata.isStaticMethod() ? null : this.metadata.getMethodProviderClass(), this.methodStreamSpec.getMethodName(), validatedInputParameters, engineImportService, eventAdapterService, statementContext.getStatementId(), false, null, handler, this.methodStreamSpec.getMethodName(), tableService, statementContext.getEngineURI());
            this.validatedExprNodes = ExprNodeUtilityRich.getEvaluatorsMayCompile(desc.getChildForges(), engineImportService, this.getClass(), streamTypeService.isOnDemandStreams(), statementContext.getStatementName());
            Object invocationTarget = this.metadata.getInvocationTarget();
            MethodPollingExecStrategyEnum strategy = this.metadata.getStrategy();
            VariableReader variableReader = this.metadata.getVariableReader();
            String variableName = this.metadata.getVariableName();
            FastMethod methodFastClass = desc.getFastMethod();
            this.pollExecStrategy = this.metadata.getEventTypeEventBeanArray() != null ? new MethodPollingExecStrategyEventBeans(eventAdapterService, methodFastClass, this.eventType, invocationTarget, strategy, variableReader, variableName, variableService) : (this.metadata.getOptionalMapType() != null ? (desc.getFastMethod().getReturnType().isArray() ? new MethodPollingExecStrategyMapArray(eventAdapterService, methodFastClass, this.eventType, invocationTarget, strategy, variableReader, variableName, variableService) : (this.metadata.isCollection() ? new MethodPollingExecStrategyMapCollection(eventAdapterService, methodFastClass, this.eventType, invocationTarget, strategy, variableReader, variableName, variableService) : (this.metadata.isIterator() ? new MethodPollingExecStrategyMapIterator(eventAdapterService, methodFastClass, this.eventType, invocationTarget, strategy, variableReader, variableName, variableService) : new MethodPollingExecStrategyMapPlain(eventAdapterService, methodFastClass, this.eventType, invocationTarget, strategy, variableReader, variableName, variableService)))) : (this.metadata.getOptionalOaType() != null ? (desc.getFastMethod().getReturnType() == Object[][].class ? new MethodPollingExecStrategyOAArray(eventAdapterService, methodFastClass, this.eventType, invocationTarget, strategy, variableReader, variableName, variableService) : (this.metadata.isCollection() ? new MethodPollingExecStrategyOACollection(eventAdapterService, methodFastClass, this.eventType, invocationTarget, strategy, variableReader, variableName, variableService) : (this.metadata.isIterator() ? new MethodPollingExecStrategyOAIterator(eventAdapterService, methodFastClass, this.eventType, invocationTarget, strategy, variableReader, variableName, variableService) : new MethodPollingExecStrategyOAPlain(eventAdapterService, methodFastClass, this.eventType, invocationTarget, strategy, variableReader, variableName, variableService)))) : (desc.getFastMethod().getReturnType().isArray() ? new MethodPollingExecStrategyPOJOArray(eventAdapterService, methodFastClass, this.eventType, invocationTarget, strategy, variableReader, variableName, variableService) : (this.metadata.isCollection() ? new MethodPollingExecStrategyPOJOCollection(eventAdapterService, methodFastClass, this.eventType, invocationTarget, strategy, variableReader, variableName, variableService) : (this.metadata.isIterator() ? new MethodPollingExecStrategyPOJOIterator(eventAdapterService, methodFastClass, this.eventType, invocationTarget, strategy, variableReader, variableName, variableService) : new MethodPollingExecStrategyPOJOPlain(eventAdapterService, methodFastClass, this.eventType, invocationTarget, strategy, variableReader, variableName, variableService))))));
        } else {
            this.pollExecStrategy = new MethodPollingExecStrategyScript(this.metadata.getScriptExpression());
            this.validatedExprNodes = ExprNodeUtilityRich.getEvaluatorsMayCompile(validatedInputParameters, engineImportService, this.getClass(), streamTypeService.isOnDemandStreams(), statementContext.getStatementName());
        }
    }

    @Override
    public EventTable[][] poll(EventBean[][] lookupEventsPerStream, PollResultIndexingStrategy indexingStrategy, ExprEvaluatorContext exprEvaluatorContext) {
        DataCache localDataCache = this.dataCacheThreadLocal.get();
        boolean strategyStarted = false;
        EventTable[][] resultPerInputRow = new EventTable[lookupEventsPerStream.length][];
        for (int row = 0; row < lookupEventsPerStream.length; ++row) {
            Object[] methodParams = new Object[this.validatedExprNodes.length];
            for (int valueNum = 0; valueNum < this.validatedExprNodes.length; ++valueNum) {
                Object parameterValue;
                methodParams[valueNum] = parameterValue = this.validatedExprNodes[valueNum].evaluate(lookupEventsPerStream[row], true, exprEvaluatorContext);
            }
            EventTable[] result = null;
            if (localDataCache != null) {
                result = localDataCache.getCached(methodParams, this.methodStreamSpec.getExpressions().size());
            }
            if (result == null && (result = this.dataCache.getCached(methodParams, this.methodStreamSpec.getExpressions().size())) != null && localDataCache != null) {
                localDataCache.put(methodParams, this.methodStreamSpec.getExpressions().size(), result);
            }
            if (result != null) {
                resultPerInputRow[row] = result;
                continue;
            }
            try {
                if (!strategyStarted) {
                    this.pollExecStrategy.start();
                    strategyStarted = true;
                }
                List<EventBean> pollResult = this.pollExecStrategy.poll(methodParams, exprEvaluatorContext);
                EventTable[] indexTable = indexingStrategy.index(pollResult, this.dataCache.isActive(), this.statementContext);
                resultPerInputRow[row] = indexTable;
                this.dataCache.put(methodParams, this.methodStreamSpec.getExpressions().size(), indexTable);
                if (localDataCache == null) continue;
                localDataCache.put(methodParams, this.methodStreamSpec.getExpressions().size(), indexTable);
                continue;
            }
            catch (EPException ex) {
                if (strategyStarted) {
                    this.pollExecStrategy.done();
                }
                throw ex;
            }
        }
        if (strategyStarted) {
            this.pollExecStrategy.done();
        }
        return resultPerInputRow;
    }

    @Override
    public View addView(View view) {
        view.setParent(this);
        return view;
    }

    @Override
    public View[] getViews() {
        return ViewSupport.EMPTY_VIEW_ARRAY;
    }

    @Override
    public boolean removeView(View view) {
        throw new UnsupportedOperationException("Subviews not supported");
    }

    @Override
    public void removeAllViews() {
        throw new UnsupportedOperationException("Subviews not supported");
    }

    @Override
    public boolean hasViews() {
        return false;
    }

    @Override
    public EventType getEventType() {
        return this.eventType;
    }

    @Override
    public Iterator<EventBean> iterator() {
        EventTable[][] result = this.poll(NULL_ROWS, ITERATOR_INDEXING_STRATEGY, this.exprEvaluatorContext);
        return new IterablesArrayIterator(result);
    }

    @Override
    public SortedSet<Integer> getRequiredStreams() {
        return this.requiredStreams;
    }

    @Override
    public boolean hasRequiredStreams() {
        return !this.requiredStreams.isEmpty();
    }

    static {
        MethodPollingViewable.NULL_ROWS[0] = new EventBean[1];
        ITERATOR_INDEXING_STRATEGY = new PollResultIndexingStrategy(){

            @Override
            public EventTable[] index(List<EventBean> pollResult, boolean isActiveCache, StatementContext statementContext) {
                return new EventTable[]{new UnindexedEventTableList(pollResult, -1)};
            }

            @Override
            public String toQueryPlan() {
                return this.getClass().getSimpleName() + " unindexed";
            }
        };
    }
}

