/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.core.resultset.core;

import com.espertech.esper.client.ConfigurationInformation;
import com.espertech.esper.client.annotation.HintEnum;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.spec.OutputLimitLimitType;
import java.lang.annotation.Annotation;

public enum ResultSetProcessorOutputConditionType {
    SNAPSHOT,
    POLICY_FIRST,
    POLICY_LASTALL_UNORDERED,
    POLICY_NONFIRST;


    public static ResultSetProcessorOutputConditionType getConditionType(OutputLimitLimitType displayLimit, boolean isAggregated, boolean hasOrderBy, boolean hasOptHint, boolean isGrouped) {
        if (displayLimit == OutputLimitLimitType.SNAPSHOT) {
            return SNAPSHOT;
        }
        if (displayLimit == OutputLimitLimitType.FIRST && !isGrouped) {
            return POLICY_FIRST;
        }
        if (!isAggregated && !isGrouped && displayLimit == OutputLimitLimitType.LAST) {
            return POLICY_LASTALL_UNORDERED;
        }
        if (hasOptHint && displayLimit == OutputLimitLimitType.ALL && !hasOrderBy) {
            return POLICY_LASTALL_UNORDERED;
        }
        if (hasOptHint && displayLimit == OutputLimitLimitType.LAST && !hasOrderBy) {
            return POLICY_LASTALL_UNORDERED;
        }
        return POLICY_NONFIRST;
    }

    public static boolean getOutputLimitOpt(Annotation[] annotations, ConfigurationInformation configurationInformation, boolean hasOrderBy) throws ExprValidationException {
        if (hasOrderBy) {
            if (ResultSetProcessorOutputConditionType.hasOptHintEnable(annotations)) {
                throw new ExprValidationException("The " + (Object)((Object)HintEnum.ENABLE_OUTPUTLIMIT_OPT) + " hint is not supported with order-by");
            }
            return false;
        }
        boolean opt = configurationInformation.getEngineDefaults().getViewResources().isOutputLimitOpt();
        if (annotations == null) {
            return opt;
        }
        return opt ? HintEnum.DISABLE_OUTPUTLIMIT_OPT.getHint(annotations) == null : ResultSetProcessorOutputConditionType.hasOptHintEnable(annotations);
    }

    private static boolean hasOptHintEnable(Annotation[] annotations) {
        return HintEnum.ENABLE_OUTPUTLIMIT_OPT.getHint(annotations) != null;
    }
}

