/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.datetime.dtlocal;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.codegen.base.CodegenBlock;
import com.espertech.esper.codegen.base.CodegenClassScope;
import com.espertech.esper.codegen.base.CodegenMember;
import com.espertech.esper.codegen.base.CodegenMethodNode;
import com.espertech.esper.codegen.base.CodegenMethodScope;
import com.espertech.esper.codegen.model.expression.CodegenExpression;
import com.espertech.esper.codegen.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.codegen.model.expression.CodegenExpressionRef;
import com.espertech.esper.epl.datetime.calop.CalendarOp;
import com.espertech.esper.epl.datetime.dtlocal.DTLocalDateOpsIntervalForge;
import com.espertech.esper.epl.datetime.dtlocal.DTLocalEvaluatorCalOpsIntervalBase;
import com.espertech.esper.epl.datetime.dtlocal.DTLocalUtil;
import com.espertech.esper.epl.datetime.interval.IntervalOp;
import com.espertech.esper.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;

class DTLocalDateOpsIntervalEval
extends DTLocalEvaluatorCalOpsIntervalBase {
    private final TimeZone timeZone;

    public DTLocalDateOpsIntervalEval(List<CalendarOp> calendarOps, IntervalOp intervalOp, TimeZone timeZone) {
        super(calendarOps, intervalOp);
        this.timeZone = timeZone;
    }

    @Override
    public Object evaluate(Object target, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        Calendar cal = Calendar.getInstance(this.timeZone);
        cal.setTimeInMillis(((Date)target).getTime());
        DTLocalUtil.evaluateCalOpsCalendar(this.calendarOps, cal, eventsPerStream, isNewData, exprEvaluatorContext);
        long time = cal.getTimeInMillis();
        return this.intervalOp.evaluate(time, time, eventsPerStream, isNewData, exprEvaluatorContext);
    }

    public static CodegenExpression codegenPointInTime(DTLocalDateOpsIntervalForge forge, CodegenExpression inner, Class innerType, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        CodegenMethodNode methodNode = codegenMethodScope.makeChild(Boolean.class, DTLocalDateOpsIntervalEval.class, codegenClassScope).addParam(Date.class, "target");
        CodegenMember tz = codegenClassScope.makeAddMember(TimeZone.class, forge.timeZone);
        CodegenBlock block = methodNode.getBlock().declareVar(Calendar.class, "cal", CodegenExpressionBuilder.staticMethod(Calendar.class, "getInstance", CodegenExpressionBuilder.member(tz.getMemberId()))).expression(CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("cal"), "setTimeInMillis", CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("target"), "getTime", new CodegenExpression[0])));
        DTLocalUtil.evaluateCalOpsCalendarCodegen(block, forge.calendarForges, CodegenExpressionBuilder.ref("cal"), methodNode, exprSymbol, codegenClassScope);
        block.declareVar(Long.TYPE, "time", CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("cal"), "getTimeInMillis", new CodegenExpression[0])).methodReturn(forge.intervalForge.codegen(CodegenExpressionBuilder.ref("time"), CodegenExpressionBuilder.ref("time"), methodNode, exprSymbol, codegenClassScope));
        return CodegenExpressionBuilder.localMethod(methodNode, inner);
    }

    @Override
    public Object evaluate(Object startTimestamp, Object endTimestamp, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        long startLong = ((Date)startTimestamp).getTime();
        long endLong = ((Date)endTimestamp).getTime();
        Calendar cal = Calendar.getInstance(this.timeZone);
        cal.setTimeInMillis(startLong);
        DTLocalUtil.evaluateCalOpsCalendar(this.calendarOps, cal, eventsPerStream, isNewData, exprEvaluatorContext);
        long startTime = cal.getTimeInMillis();
        long endTime = startTime + (endLong - startLong);
        return this.intervalOp.evaluate(startTime, endTime, eventsPerStream, isNewData, exprEvaluatorContext);
    }

    public static CodegenExpression codegenStartEnd(DTLocalDateOpsIntervalForge forge, CodegenExpressionRef start, CodegenExpressionRef end, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        CodegenMethodNode methodNode = codegenMethodScope.makeChild(Boolean.class, DTLocalDateOpsIntervalEval.class, codegenClassScope).addParam(Date.class, "startTimestamp").addParam(Date.class, "endTimestamp");
        CodegenMember tz = codegenClassScope.makeAddMember(TimeZone.class, forge.timeZone);
        CodegenBlock block = methodNode.getBlock().declareVar(Long.TYPE, "startLong", CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("startTimestamp"), "getTime", new CodegenExpression[0])).declareVar(Long.TYPE, "endLong", CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("endTimestamp"), "getTime", new CodegenExpression[0])).declareVar(Calendar.class, "cal", CodegenExpressionBuilder.staticMethod(Calendar.class, "getInstance", CodegenExpressionBuilder.member(tz.getMemberId()))).expression(CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("cal"), "setTimeInMillis", CodegenExpressionBuilder.ref("startLong")));
        DTLocalUtil.evaluateCalOpsCalendarCodegen(block, forge.calendarForges, CodegenExpressionBuilder.ref("cal"), methodNode, exprSymbol, codegenClassScope);
        block.declareVar(Long.TYPE, "startTime", CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("cal"), "getTimeInMillis", new CodegenExpression[0])).declareVar(Long.TYPE, "endTime", CodegenExpressionBuilder.op(CodegenExpressionBuilder.ref("startTime"), "+", CodegenExpressionBuilder.op(CodegenExpressionBuilder.ref("endLong"), "-", CodegenExpressionBuilder.ref("startLong")))).methodReturn(forge.intervalForge.codegen(CodegenExpressionBuilder.ref("startTime"), CodegenExpressionBuilder.ref("endTime"), methodNode, exprSymbol, codegenClassScope));
        return CodegenExpressionBuilder.localMethod(methodNode, start, end);
    }
}

