/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.datetime.reformatop;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.codegen.base.CodegenBlock;
import com.espertech.esper.codegen.base.CodegenClassScope;
import com.espertech.esper.codegen.base.CodegenMember;
import com.espertech.esper.codegen.base.CodegenMethodScope;
import com.espertech.esper.codegen.model.expression.CodegenExpression;
import com.espertech.esper.codegen.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.epl.datetime.eval.DatetimeMethodEnum;
import com.espertech.esper.epl.datetime.reformatop.ReformatForge;
import com.espertech.esper.epl.datetime.reformatop.ReformatOp;
import com.espertech.esper.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.dot.ExprDotNodeFilterAnalyzerInput;
import com.espertech.esper.epl.expression.time.TimeAbacus;
import com.espertech.esper.epl.join.plan.FilterExprAnalyzerAffector;
import java.text.DateFormat;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class ReformatFormatForge
implements ReformatForge,
ReformatOp {
    private final DateFormat dateFormat;
    private final DateTimeFormatter dateTimeFormatter;
    private final TimeAbacus timeAbacus;

    public ReformatFormatForge(Object formatter, TimeAbacus timeAbacus) {
        if (formatter instanceof DateFormat) {
            this.dateFormat = (DateFormat)formatter;
            this.dateTimeFormatter = null;
        } else {
            this.dateFormat = null;
            this.dateTimeFormatter = (DateTimeFormatter)formatter;
        }
        this.timeAbacus = timeAbacus;
    }

    @Override
    public ReformatOp getOp() {
        return this;
    }

    @Override
    public synchronized Object evaluate(Long ts, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext exprEvaluatorContext) {
        if (this.timeAbacus.getOneSecond() == 1000L) {
            return this.dateFormat.format(ts);
        }
        return this.dateFormat.format(this.timeAbacus.toDate(ts));
    }

    @Override
    public CodegenExpression codegenLong(CodegenExpression inner, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        CodegenMember df = codegenClassScope.makeAddMember(DateFormat.class, this.dateFormat);
        CodegenBlock blockMethod = codegenMethodScope.makeChild(String.class, ReformatFormatForge.class, codegenClassScope).addParam(Long.TYPE, "ts").getBlock();
        CodegenBlock syncBlock = blockMethod.synchronizedOn(CodegenExpressionBuilder.member(df.getMemberId()));
        if (this.timeAbacus.getOneSecond() == 1000L) {
            syncBlock.blockReturn(CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.member(df.getMemberId()), "format", CodegenExpressionBuilder.ref("ts")));
        } else {
            syncBlock.blockReturn(CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.member(df.getMemberId()), "format", this.timeAbacus.toDateCodegen(CodegenExpressionBuilder.ref("ts"))));
        }
        return CodegenExpressionBuilder.localMethodBuild(blockMethod.methodEnd()).pass(inner).call();
    }

    @Override
    public synchronized Object evaluate(Date d, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext exprEvaluatorContext) {
        return this.dateFormat.format(d);
    }

    @Override
    public CodegenExpression codegenDate(CodegenExpression inner, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        CodegenMember df = codegenClassScope.makeAddMember(DateFormat.class, this.dateFormat);
        CodegenBlock blockMethod = codegenMethodScope.makeChild(String.class, ReformatFormatForge.class, codegenClassScope).addParam(Date.class, "d").getBlock().synchronizedOn(CodegenExpressionBuilder.member(df.getMemberId())).blockReturn(CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.member(df.getMemberId()), "format", CodegenExpressionBuilder.ref("d")));
        return CodegenExpressionBuilder.localMethodBuild(blockMethod.methodEnd()).pass(inner).call();
    }

    @Override
    public synchronized Object evaluate(Calendar cal, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext exprEvaluatorContext) {
        return this.dateFormat.format(cal.getTime());
    }

    @Override
    public CodegenExpression codegenCal(CodegenExpression inner, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        CodegenMember df = codegenClassScope.makeAddMember(DateFormat.class, this.dateFormat);
        CodegenBlock blockMethod = codegenMethodScope.makeChild(String.class, ReformatFormatForge.class, codegenClassScope).addParam(Calendar.class, "cal").getBlock().synchronizedOn(CodegenExpressionBuilder.member(df.getMemberId())).blockReturn(CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.member(df.getMemberId()), "format", CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("cal"), "getTime", new CodegenExpression[0])));
        return CodegenExpressionBuilder.localMethodBuild(blockMethod.methodEnd()).pass(inner).call();
    }

    @Override
    public Object evaluate(LocalDateTime ldt, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext exprEvaluatorContext) {
        return ldt.format(this.dateTimeFormatter);
    }

    @Override
    public CodegenExpression codegenLDT(CodegenExpression inner, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        CodegenMember df = codegenClassScope.makeAddMember(DateTimeFormatter.class, this.dateTimeFormatter);
        return CodegenExpressionBuilder.exprDotMethod(inner, "format", CodegenExpressionBuilder.member(df.getMemberId()));
    }

    @Override
    public Object evaluate(ZonedDateTime zdt, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext exprEvaluatorContext) {
        return zdt.format(this.dateTimeFormatter);
    }

    @Override
    public CodegenExpression codegenZDT(CodegenExpression inner, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        CodegenMember df = codegenClassScope.makeAddMember(DateTimeFormatter.class, this.dateTimeFormatter);
        return CodegenExpressionBuilder.exprDotMethod(inner, "format", CodegenExpressionBuilder.member(df.getMemberId()));
    }

    @Override
    public Class getReturnType() {
        return String.class;
    }

    @Override
    public FilterExprAnalyzerAffector getFilterDesc(EventType[] typesPerStream, DatetimeMethodEnum currentMethod, List<ExprNode> currentParameters, ExprDotNodeFilterAnalyzerInput inputDesc) {
        return null;
    }
}

